import 'dart:convert';

import 'package:dio/dio.dart';
import 'package:dropdown_button2/dropdown_button2.dart';
import 'package:flutter/material.dart';
import 'package:flutter/services.dart';
import 'package:flutter_bloc/flutter_bloc.dart';
import 'package:flutter_cupertino_datetime_picker/flutter_cupertino_datetime_picker.dart';
import 'package:intl/intl.dart';
import 'package:hamlemuhcrm/core/constants/app_constants.dart';
import 'package:hamlemuhcrm/core/constants/font_styles.dart';
import 'package:hamlemuhcrm/core/constants/url_services_constant.dart';
import 'package:hamlemuhcrm/core/extensions/image_enum_extension.dart';
import 'package:hamlemuhcrm/core/extensions/log_extension.dart';
import 'package:hamlemuhcrm/core/extensions/responsive_extension.dart';
import 'package:hamlemuhcrm/data/dropdown_models/personal_getdata_api.dart';
import 'package:hamlemuhcrm/features/auth/login/cubit/login_cubit.dart';
import 'package:hamlemuhcrm/features/projects/cubit/project_cubit.dart';
import 'package:hamlemuhcrm/features/projects/widgets/multiselect_widgets/multi_select_employee.dart';
import 'package:hamlemuhcrm/features/projects/widgets/multiselect_widgets/multi_select_leaders.dart';

import '../../../../../core/constants/color_constants.dart';
import '../../../../core/utility/toast_manager.dart';
import '../../widgets/employee_type_headline.dart';
import '../../widgets/multiselect_widgets/selected_employee_chip.dart';

class ProjectCreatePage extends StatefulWidget {
  const ProjectCreatePage({super.key});

  @override
  State<ProjectCreatePage> createState() => _ProjectCreatePageState();
}

class _ProjectCreatePageState extends State<ProjectCreatePage> {
  final tfProjeAd = TextEditingController();
  final tfAciklama = TextEditingController();
  String? secilenRenk;

  String dbSaatbaslangic = '';
  String dbSaatbitis = '';
  String gosterilenSaatbaslangic = '';
  String gosterilenSaatbitis = '';
  DateTime birincidateTime = DateTime.now();
  DateTime ikincidateTime = DateTime.now();
  bool baslangicSecildi = false;
  bool tarihUygun = false;

  List<String> _secilenPersonelList = [];
  String selectedPersonelValues = '';

  List<String> _secilenAmirList = [];
  String selectedAmirlValues = '';

  //////////////////////////////////////////////////////////////////////

  String gonderilenfirmaID = "";
  String? _secilenFirma;
  var gelenFirmalar;
  final String baseURL = URLAPIService.baseURL;

  Future<void> firmaData(
      String userfirmid, String token, String loginuserid) async {
    var url = "$baseURL/mobil/api/dd/userfirme_gore_firma_dd_pdo.php";
    var veri = {
      "firma_firmuser_id": userfirmid,
      "token": token,
      "loginuserid": loginuserid
    };
    var cevapFirmalar = await Dio().post(url, data: FormData.fromMap(veri));
    if (cevapFirmalar.statusCode == 200) {
      setState(() {
        gelenFirmalar = json.decode(cevapFirmalar.data.toString()); //
        //"data_03 = $gelenFirmalar".log();
      });
    } else {}
  }

  Widget firmalarDD() {
    List<FirmaDDModel> firmalar = List<FirmaDDModel>.from(
      gelenFirmalar['firmalar'].map(
        (i) {
          return FirmaDDModel.fromJSON(i);
        },
      ),
    );
    firmalar.sort(
      (a, b) => a.firmaIsim.compareTo(b.firmaIsim),
    ); // DROPDOWN SIRALAMASI
    return DropdownButtonHideUnderline(
      child: DropdownButton2(
        hint: const Text(
          'Firma Seçiniz...',
          style: TextStyle(color: Colors.black54, fontSize: 13),
        ),
        isExpanded: true,
        items: firmalar.map((firmalar) {
          return DropdownMenuItem(
            value: firmalar.firmaId,
            child: Text(
                firmalar.firmaIsim.toString().length > 35
                    ? "${firmalar.firmaIsim.toString().substring(0, 34)}.. "
                    : firmalar.firmaIsim,
                style: FontStyles.instance.projectbxDdyazi),
            onTap: () {}, //value
          );
        }).toList(),
        value: _secilenFirma,
        onChanged: (newValue) {
          setState(() {
            _secilenFirma = newValue.toString();
            _secilenFirma?.log();
            gonderilenfirmaID = _secilenFirma!;
          });
        },
        buttonStyleData: ButtonStyleData(
          height: context.dynamicHeight(0.054),
          width: context.dynamicWidth(0.9),
          padding: const EdgeInsets.symmetric(horizontal: 10),
          decoration: BoxDecoration(
              borderRadius: BorderRadius.circular(10),
              color: Colors.white,
              border: Border.all(color: Colors.grey.withOpacity(0.7))),
          elevation: 0,
        ),
        iconStyleData: IconStyleData(
          icon: const Icon(
            Icons.keyboard_arrow_down_outlined, //ilk icon
          ),
          openMenuIcon: const Icon(
              Icons.keyboard_arrow_left_outlined), //açıldıktan sonraki icon
          iconSize: 23,
          iconEnabledColor: ColorsConstants.instance.baseTheme,
          iconDisabledColor: Colors.white,
        ),
        dropdownStyleData: DropdownStyleData(
          maxHeight: context.dynamicHeight(0.17),
          isOverButton: false,
          padding: null,
          decoration: BoxDecoration(
            borderRadius: BorderRadius.circular(10),
            color: ColorsConstants
                .instance.backgroundColor, //açılır menü arkaplan rengi
          ),
          elevation: 8,
          offset: const Offset(0, 0),
          scrollbarTheme: ScrollbarThemeData(
            thumbColor: MaterialStateColor.resolveWith((states) =>
                ColorsConstants
                    .instance.baseTheme), //dropdown scroll rengi değiştirme
            radius: const Radius.circular(10),
            thickness: MaterialStateProperty.all<double>(6),
            thumbVisibility: MaterialStateProperty.all<bool>(true),
          ),
        ),
        menuItemStyleData: const MenuItemStyleData(
          height: 35,
          padding: EdgeInsets.symmetric(horizontal: 14),
        ),
      ),
    );
  }

  ///

  void _showMultiSelectEmployee() async {
    final List<String> items = [];

    final List<String>? results = await showDialog(
      context: context,
      builder: (BuildContext context) {
        return MultiSelectEmployee(items: items);
      },
    );

    if (results != null) {
      setState(() {
        _secilenPersonelList = results;
        List<int> personelIdler = _secilenPersonelList
            .where((eleman) => int.tryParse(eleman) != null)
            .map((eleman) => int.parse(eleman))
            .toList();
        _gonderilecekPersonelIdler = personelIdler.join(',');
      });
    }
  }

  void _showMultiSelectLeaders() async {
    final List<String> items2 = [];

    final List<String>? results2 = await showDialog(
      context: context,
      builder: (BuildContext context) {
        return MultiSelectLeaders(items: items2);
      },
    );

    if (results2 != null) {
      setState(() {
        _secilenAmirList = results2;
        List<int> sorumluIdler = _secilenAmirList
            .where((eleman) => int.tryParse(eleman) != null)
            .map((eleman) => int.parse(eleman))
            .toList();
        _gonderilecekAmirIdler = sorumluIdler.join(',');
      });
    }
  }

  String _gonderilecekPersonelIdler = '';
  String _gonderilecekAmirIdler = '';

  //////////////////////////////////////////////////////////////////////////

  dateTimePickerWidget1(BuildContext context) {
    return DatePicker.showDatePicker(
      context,
      dateFormat: 'dd/MM/yyyy',
      locale: DateTimePickerLocale.tr,
      initialDateTime: DateTime.now(),
      minDateTime: DateTime(2005),
      maxDateTime: DateTime(2100),
      pickerTheme: DateTimePickerTheme(
        backgroundColor: ColorsConstants.instance.backgroundColor,
        confirm: Text(
          'Onay',
          style: TextStyle(
              color: ColorsConstants.instance.baseTheme.withOpacity(0.7)),
        ),
      ),
      onConfirm: (dateTime, List<int> index) {
        DateTime selectdate1 = dateTime;
        birincidateTime = selectdate1;
        final baslangicTarihi =
            DateFormat('yyyy-MM-dd HH:mm').format(selectdate1);
        setState(() {
          dbSaatbaslangic = '$baslangicTarihi:00';
          gosterilenSaatbaslangic = dbSaatbaslangic.substring(0, 16);
          final DateFormat format = DateFormat.yMd('tr');
          var trTarih = format.format(DateTime.parse(gosterilenSaatbaslangic));
          gosterilenSaatbaslangic = trTarih;
          'birinci tarih ikinci tarihten önce ? ${ikincidateTime.isAfter(birincidateTime)}'
              .log();
          'birinci dateTimeNow $birincidateTime'.log();
          'ikinci dateTimeNow $ikincidateTime'.log();
          if (dbSaatbaslangic != '' && dbSaatbitis != '') {
            dbSaatbaslangic.log();
            dbSaatbitis.log();
          }
          baslangicSecildi = true;
          dbSaatbaslangic.log();
          gosterilenSaatbaslangic.log();
        });
      },
    );
  }

  dateTimePickerWidget2(BuildContext context) {
    return DatePicker.showDatePicker(
      context,
      dateFormat: 'dd/MM/yyyy',
      locale: DateTimePickerLocale.tr,
      minDateTime: DateTime(2005),
      maxDateTime: DateTime(2100),
      pickerTheme: DateTimePickerTheme(
        backgroundColor: ColorsConstants.instance.backgroundColor,
        confirm: Text(
          'Onay',
          style: TextStyle(
              color: ColorsConstants.instance.baseTheme.withOpacity(0.7)),
        ),
      ),
      onConfirm: (dateTime, List<int> index) {
        DateTime selectdate2 = dateTime;
        ikincidateTime = selectdate2;
        final bitisTarihi = DateFormat('yyyy-MM-dd HH:mm').format(selectdate2);
        setState(() {
          dbSaatbitis = '$bitisTarihi:00';
          gosterilenSaatbitis = dbSaatbitis.substring(0, 16);
          final DateFormat format = DateFormat.yMd('tr');
          var trTarih = format.format(DateTime.parse(gosterilenSaatbitis));
          gosterilenSaatbitis = trTarih;
          'ikinci tarih birinci tarihten sonra mı ? ${ikincidateTime.isAfter(birincidateTime)}'
              .log();
          if (ikincidateTime.isAfter(birincidateTime) == false) {
            gosterilenSaatbitis = '';
            ToastManager.instance
                .toastMessageService("Geçerli bir tarih seçin..");
          }
          if (dbSaatbaslangic != '' && dbSaatbitis != '') {
            //Saatler boş geçilmedi ise gerekli metot yazılsın
            dbSaatbaslangic.log();
            dbSaatbitis.log();
          }
        });
      },
    );
  }

  @override
  void initState() {
    isFinish = false;
    firmaData(context.read<LoginCubit>().userfirmId,
            context.read<LoginCubit>().token, context.read<LoginCubit>().id)
        .whenComplete(() {
      isFinish = true;
    });
    super.initState();
  }

  @override
  void deactivate() {
    super.deactivate();
    context.read<ProjectCubit>().secilenPersonelAdlar.clear();
    context.read<ProjectCubit>().secilenPersonelIdler.clear();
    context.read<ProjectCubit>().secilenAmirAdlar.clear();
    context.read<ProjectCubit>().secilenAmirIdler.clear();
  }

  bool isFinish = true;

  @override
  Widget build(BuildContext context) {
    return isFinish
        ? Scaffold(
            appBar: appBar(context),
            body: SingleChildScrollView(
              child: Column(
                children: [
                  SizedBox(
                      height: context.dynamicHeight(0.2),
                      child: ImageEnums.cproject.toPageImage),
                  _emptyLowHeightSpace(context),
                  Padding(
                    padding: EdgeInsets.symmetric(
                        horizontal: context.dynamicWidth(0.07)),
                    child: Column(
                      children: [
                        Column(
                          children: [
                            _headLine(context, 'Firma'),
                            _emptyLowHeightSpace(context),
                            firmalarDD(),
                          ],
                        ),
                        _emptyLowHeightSpace(context),
                        Column(
                          children: [
                            _headLine(context, 'Proje Adı'),
                            _emptyLowHeightSpace(context),
                            _tfProjectNameContainer,
                          ],
                        ),
                        _emptyMiddleHeightSpace(context),
                        Row(
                          mainAxisAlignment: MainAxisAlignment.spaceBetween,
                          children: [
                            Column(
                              crossAxisAlignment: CrossAxisAlignment.start,
                              children: [
                                _headLine(context, 'Başlangıç Tarihi'),
                                _emptyLowHeightSpace(context),
                                Container(
                                    height: context.dynamicHeight(0.055),
                                    width: context.dynamicWidth(0.4),
                                    decoration: BoxDecoration(
                                      borderRadius: BorderRadius.circular(10),
                                      color: Colors.white,
                                      border: Border.all(
                                          color: Colors.grey.withOpacity(0.6)),
                                    ),
                                    child: Row(
                                      children: [
                                        const SizedBox(width: 10),
                                        Text(
                                          gosterilenSaatbaslangic,
                                          style: FontStyles.instance.ddYazi,
                                        ),
                                        const Spacer(),
                                        IconButton(
                                            padding: EdgeInsets.zero,
                                            onPressed: () {
                                              dateTimePickerWidget1(context);
                                            },
                                            tooltip: 'Tarih Seç',
                                            icon: Icon(
                                              Icons.calendar_month_outlined,
                                              size: 23,
                                              color: ColorsConstants
                                                  .instance.baseTheme,
                                            )),
                                      ],
                                    )),
                              ],
                            ),
                            Column(
                              crossAxisAlignment: CrossAxisAlignment.start,
                              children: [
                                _headLine(context, 'Bitiş Tarihi'),
                                _emptyLowHeightSpace(context),
                                Container(
                                  height: context.dynamicHeight(0.055),
                                  width: context.dynamicWidth(0.4),
                                  decoration: BoxDecoration(
                                    borderRadius: BorderRadius.circular(10),
                                    color: Colors.white,
                                    border: Border.all(
                                      color: Colors.grey.withOpacity(0.6),
                                    ),
                                  ),
                                  child: Row(
                                    children: [
                                      const SizedBox(width: 10),
                                      Text(
                                        gosterilenSaatbitis,
                                        style: FontStyles.instance.ddYazi,
                                      ),
                                      const Spacer(),
                                      baslangicSecildi
                                          ? IconButton(
                                              padding: EdgeInsets.zero,
                                              onPressed: () {
                                                dateTimePickerWidget2(context);
                                              },
                                              tooltip: 'Bitiş Tarihi Seç',
                                              icon: Icon(
                                                Icons.calendar_month_outlined,
                                                size: 23,
                                                color: ColorsConstants
                                                    .instance.baseTheme,
                                              ))
                                          : IconButton(
                                              padding: EdgeInsets.zero,
                                              onPressed: () {
                                                ToastManager.instance
                                                    .toastMessageService(
                                                        "Başlangıç tarihini seçin..");
                                              },
                                              tooltip: 'Bitiş Tarihi Seç',
                                              icon: Icon(
                                                Icons.calendar_month_outlined,
                                                size: 23,
                                                color: ColorsConstants
                                                    .instance.baseTheme,
                                              ))
                                    ],
                                  ),
                                ),
                              ],
                            ),
                          ],
                        ),
                        _emptyMiddleHeightSpace(context),
                        Row(
                          mainAxisAlignment: MainAxisAlignment.spaceBetween,
                          children: [
                            Column(
                              crossAxisAlignment: CrossAxisAlignment.start,
                              children: [
                                _headLine(context, 'Proje Sorumluları'),
                                _emptyLowHeightSpace(context),
                                Container(
                                  height: context.dynamicHeight(0.055),
                                  width: context.dynamicWidth(0.40),
                                  decoration: BoxDecoration(
                                    borderRadius: BorderRadius.circular(10),
                                    color: _secilenAmirList.isNotEmpty
                                        ? Colors.grey.shade200
                                        : Colors.white,
                                    border: Border.all(
                                      color: Colors.grey.withOpacity(0.6),
                                    ),
                                  ),
                                  child: Row(
                                    children: [
                                      SizedBox(
                                          width: context.dynamicWidth(0.04)),
                                      Text(
                                        _secilenAmirList.isNotEmpty
                                            ? 'Seçildi'
                                            : '',
                                        style: const TextStyle(fontSize: 13.5),
                                      ),
                                      const Spacer(),
                                      IconButton(
                                          padding: EdgeInsets.zero,
                                          onPressed: () {
                                            isFinish = false;
                                            _showMultiSelectLeaders();
                                            isFinish = true;
                                          },
                                          tooltip: 'Sorumlu Seç',
                                          icon: Icon(
                                            Icons.arrow_drop_down_sharp,
                                            size: 23,
                                            color: ColorsConstants
                                                .instance.baseTheme,
                                          ))
                                    ],
                                  ),
                                ),
                              ],
                            ),
                            Column(
                              crossAxisAlignment: CrossAxisAlignment.start,
                              children: [
                                _headLine(context, 'Proje Görevlileri'),
                                _emptyLowHeightSpace(context),
                                Container(
                                  height: context.dynamicHeight(0.055),
                                  width: context.dynamicWidth(0.40),
                                  decoration: BoxDecoration(
                                    borderRadius: BorderRadius.circular(10),
                                    color: _secilenPersonelList.isNotEmpty
                                        ? Colors.grey.shade200
                                        : Colors.white,
                                    border: Border.all(
                                      color: Colors.grey.withOpacity(0.6),
                                    ),
                                  ),
                                  child: Row(
                                    children: [
                                      SizedBox(
                                          width: context.dynamicWidth(0.04)),
                                      Text(
                                        _secilenPersonelList.isNotEmpty
                                            ? 'Seçildi'
                                            : '',
                                        style: const TextStyle(fontSize: 13.5),
                                      ),
                                      const Spacer(),
                                      IconButton(
                                          padding: EdgeInsets.zero,
                                          onPressed: () {
                                            isFinish = false;
                                            _showMultiSelectEmployee();
                                            isFinish = true;
                                          },
                                          tooltip: 'Görevli Seç',
                                          icon: Icon(
                                            Icons.arrow_drop_down_sharp,
                                            size: 23,
                                            color: ColorsConstants
                                                .instance.baseTheme,
                                          ))
                                    ],
                                  ),
                                ),
                              ],
                            ),
                          ],
                        ),
                        _emptyMiddleHeightSpace(context),
                        context
                                .read<ProjectCubit>()
                                .secilenPersonelIdler
                                .isNotEmpty
                            ? Column(children: [
                                const EmployeeTypeHeadline(
                                    employeeType: "Görevliler"),
                                SelectedEmployeeWidget(
                                    selectedLeaders: context
                                        .read<ProjectCubit>()
                                        .secilenPersonelAdlar),
                                context
                                        .read<ProjectCubit>()
                                        .secilenAmirIdler
                                        .isNotEmpty
                                    ? const SizedBox()
                                    : const Divider(
                                        height: 20,
                                      ),
                              ])
                            : _emptyLowHeightSpace(context),
                        context.read<ProjectCubit>().secilenAmirIdler.isNotEmpty
                            ? Column(children: [
                                const EmployeeTypeHeadline(
                                    employeeType: "Sorumlular"),
                                SelectedEmployeeWidget(
                                    selectedLeaders: context
                                        .read<ProjectCubit>()
                                        .secilenAmirAdlar),
                                Divider(
                                  height: context.dynamicHeight(0.02),
                                ),
                              ])
                            : _emptyLowHeightSpace(context),
                        Column(
                          children: [
                            _headLine(context, 'Açıklama'),
                            _emptyLowHeightSpace(context),
                            Container(
                              padding: const EdgeInsets.all(5),
                              height: context.dynamicHeight(0.11),
                              width: context.dynamicWidth(1),
                              decoration: BoxDecoration(
                                color: Colors.white,
                                borderRadius: BorderRadius.circular(10),
                                border: Border.all(
                                  color: Colors.grey.withOpacity(0.6),
                                ),
                              ),
                              child: TextFormField(
                                textInputAction: TextInputAction.done,
                                maxLines: 3,
                                cursorColor: ColorsConstants.instance.baseTheme,
                                style: FontStyles.instance.projectbxDdyazi,
                                controller: tfAciklama,
                                decoration: const InputDecoration(
                                  border: InputBorder.none,
                                  contentPadding:
                                      EdgeInsets.symmetric(horizontal: 2),
                                ),
                              ),
                            ),
                          ],
                        ),
                        _emptyLowHeightSpace(context),
                        _addProjectButton,
                      ],
                    ),
                  ),
                ],
              ),
            ),
          )
        : const Scaffold();
  }

  AppBar appBar(BuildContext context) {
    return AppBar(
      backgroundColor: Colors.transparent,
      elevation: 0,
      title: Text('Proje Oluştur', style: FontStyles.instance.appbarTitleStyle),
      centerTitle: true,
      leading: IconButton(
          onPressed: () {
            Navigator.of(context).popUntil((route) => route.isFirst);
          },
          icon: const Icon(
            Icons.arrow_back_ios_new,
            color: Colors.black54,
            size: 20,
          )),
    );
  }

  Widget get _tfProjectNameContainer => Container(
        height: context.dynamicHeight(0.05),
        width: context.dynamicWidth(0.88),
        alignment: Alignment.center,
        decoration: BoxDecoration(
            color: Colors.white,
            border: Border.all(color: Colors.grey.shade400),
            borderRadius: BorderRadius.circular(10)),
        child: TextFormField(
          inputFormatters: [LengthLimitingTextInputFormatter(100)],
          style: FontStyles.instance.projectbxDdyazi,
          magnifierConfiguration: TextMagnifierConfiguration.disabled,
          validator: (value) {
            if (value!.isEmpty ||
                !RegExp(r"^[a-zA-Z]+(([',. -][a-zA-Z ])?[a-zA-Z]*)*$")
                    .hasMatch(value)) {
              tfProjeAd.text = 'geçersiz';
              ScaffoldMessenger.of(context).showSnackBar(
                SnackBar(
                  backgroundColor: ColorsConstants.instance.backgroundColor,
                  content: const Text(
                    'Geçerli bir proje adı girin..',
                  ),
                  behavior: SnackBarBehavior.floating,
                  action: SnackBarAction(
                    label: "Tamam",
                    textColor: Colors.white,
                    onPressed: () {},
                  ),
                ),
              );
            }
            return null;
          },
          textInputAction: TextInputAction.done,
          cursorColor: ColorsConstants.instance.baseTheme,
          controller: tfProjeAd,
          decoration: const InputDecoration(
            contentPadding: EdgeInsets.symmetric(horizontal: 8),
            border: OutlineInputBorder(borderSide: BorderSide.none),
          ),
        ),
      );

  Widget get _addProjectButton => Row(
        mainAxisAlignment: MainAxisAlignment.end,
        children: [
          TextButton(
            onPressed: () {
              _gonderilecekAmirIdler.log();
              _gonderilecekPersonelIdler.log();
              if (_secilenFirma != null &&
                  tfProjeAd.text.isNotEmpty &&
                  dbSaatbaslangic.isNotEmpty &&
                  dbSaatbitis.isNotEmpty &&
                  _gonderilecekAmirIdler.isNotEmpty &&
                  _gonderilecekPersonelIdler.isNotEmpty &&
                  tfAciklama.text.isNotEmpty) {
                context
                    .read<ProjectCubit>()
                    .projEkle(
                        context.read<LoginCubit>().id,
                        context.read<LoginCubit>().userfirmId,
                        _secilenFirma!,
                        tfProjeAd.text,
                        tfAciklama.text,
                        dbSaatbaslangic,
                        dbSaatbitis,
                        _gonderilecekAmirIdler,
                        _gonderilecekPersonelIdler,
                        context.read<LoginCubit>().token,
                        context.read<LoginCubit>().tip)
                    .whenComplete(() {
                  _showSnackBarMsg(context, 'Proje Eklendi');
                  Future.delayed(const Duration(milliseconds: 1500), () {
                    Navigator.pop(context);
                  });
                });
              } else {
                _showSnackBarMsg(context, 'Eksik Alanlar Var !');
              }
            },
            style: TextButton.styleFrom(
              backgroundColor: ColorsConstants.instance.baseTheme,
            ),
            child: Text(
              ApplicationConstants.instance.moduleSaveTxt,
              style: const TextStyle(color: Colors.white),
            ),
          ),
        ],
      );
}

Widget _emptyLowHeightSpace(BuildContext context) {
  return SizedBox(height: context.dynamicHeight(0.012));
}

Widget _emptyMiddleHeightSpace(BuildContext context) {
  return SizedBox(height: context.dynamicHeight(0.02));
}

Widget _headLine(BuildContext context, String title, {bool isRequired = true}) {
  return Row(
    children: [
      Text(
        title,
        style: FontStyles.instance.projectbxBaslik,
      ),
      isRequired
          ? Row(
              children: [
                SizedBox(
                  width: context.dynamicWidth(0.01),
                ),
                Text(
                  '(zorunlu)',
                  style: FontStyles.instance.employeetbxRequired,
                ),
              ],
            )
          : const SizedBox.shrink()
    ],
  );
}

void _showSnackBarMsg(BuildContext context, String msg) {
  ScaffoldMessenger.of(context).showSnackBar(
    SnackBar(
        content: Text(msg, selectionColor: Colors.white),
        backgroundColor: ColorsConstants.instance.baseTheme),
  );
}
