import 'package:flutter/material.dart';
import 'package:flutter_bloc/flutter_bloc.dart';
import 'package:flutter_cupertino_datetime_picker/flutter_cupertino_datetime_picker.dart';
import 'package:intl/intl.dart';
import 'package:hamlemuhcrm/core/constants/url_services_constant.dart';
import 'package:hamlemuhcrm/core/extensions/log_extension.dart';
import 'package:hamlemuhcrm/features/projects/view/missions_partial/project_add_main_mission.dart';
import 'package:hamlemuhcrm/features/projects/widgets/multiselect_widgets/multi_select_leaders.dart';

import '../../../../core/constants/color_constants.dart';
import '../../../../core/utility/toast_manager.dart';
import '../../cubit/project_cubit.dart';
import '../../widgets/multiselect_widgets/multi_select_employee.dart';

mixin ProjectAddMainMissionMixin on State<ProjectAddMainMission> {
  final String baseURL = URLAPIService.baseURL;

  final tfGorevAd = TextEditingController();
  final tfAciklama = TextEditingController();

  String dbSaatbaslangic = '';
  String dbSaatbitis = '';
  String gosterilenSaatbaslangic = '';
  String gosterilenSaatbitis = '';

  DateTime birincidateTime = DateTime.now();
  DateTime ikincidateTime = DateTime.now();

  bool baslangicSecildi = false;
  bool tarihUygun = false;

  Color selectedcolor = Colors.red;

  void rgbConvert(String red, String green, String blue) {
    secilenRenkKodu = "rgb($red,$green,$blue)";
    debugPrint(secilenRenkKodu);
  }

  String secilenRenkKodu = "rgb(68,197,54)";

  final colorhistory = [
    Colors.red,
    Colors.amber,
    Colors.teal,
    Colors.blueGrey,
    Colors.indigo
  ];

  List<String> secilenPersonelList = [];
  String selectedPersonelValues = '';

  List<String> secilenAmirList = [];
  String selectedAmirlValues = '';

  @override
  void initState() {
    isFinish = false;
    _degerleriAta();
    isFinish = true;
    super.initState();
  }

  void _degerleriAta() {
    seciliGorevlileriEkle();
    seciliSorumlulariEkle();
  }
  //////////////////////////////////////////////////////////////////////

  void showMultiSelectEmployee() async {
    final List<String> items = [];

    final List<String>? results = await showDialog(
      context: context,
      builder: (BuildContext context) {
        return MultiSelectEmployee(items: items);
      },
    );

    if (results != null) {
      setState(() {
        secilenPersonelList = results;
      });
    }
  }

  void showMultiSelectLeaders() async {
    final List<String> items2 = [];

    final List<String>? results2 = await showDialog(
      context: context,
      builder: (BuildContext context) {
        return MultiSelectLeaders(items: items2);
      },
    );

    if (results2 != null) {
      setState(() {
        secilenAmirList = results2;
      });
    }
  }

  String gonderilecekPersonelIdler = '';
  String gonderilecekAmirIdler = '';

  //////////////////////////////////////////////////////////////////////////////////////////////////////

  dateTimePickerWidget1(BuildContext context) {
    return DatePicker.showDatePicker(
      context,
      dateFormat: 'dd/MM/yyyy',
      locale: DateTimePickerLocale.tr,
      initialDateTime: DateTime.now(),
      minDateTime: DateTime(2005),
      maxDateTime: DateTime(2100),
      pickerTheme: DateTimePickerTheme(
        backgroundColor: ColorsConstants.instance.backgroundColor,
        confirm: Text(
          'Onay',
          style: TextStyle(
              color: ColorsConstants.instance.baseTheme.withOpacity(0.7)),
        ),
      ),
      onConfirm: (dateTime, List<int> index) {
        DateTime selectdate1 = dateTime;
        birincidateTime = selectdate1;
        final baslangicTarihi =
            DateFormat('yyyy-MM-dd HH:mm').format(selectdate1);
        setState(() {
          dbSaatbaslangic = '$baslangicTarihi:00';
          gosterilenSaatbaslangic = dbSaatbaslangic.substring(0, 16);
          final DateFormat format = DateFormat.yMd('tr');
          var trTarih = format.format(DateTime.parse(gosterilenSaatbaslangic));
          gosterilenSaatbaslangic = trTarih;
          if (dbSaatbaslangic != '' && dbSaatbitis != '') {}
          baslangicSecildi = true;
        });
      },
    );
  }

  dateTimePickerWidget2(BuildContext context) {
    return DatePicker.showDatePicker(
      context,
      dateFormat: 'dd/MM/yyyy',
      locale: DateTimePickerLocale.tr,
      minDateTime: DateTime(2005),
      maxDateTime: DateTime(2100),
      pickerTheme: DateTimePickerTheme(
        backgroundColor: ColorsConstants.instance.backgroundColor,
        confirm: Text(
          'Onay',
          style: TextStyle(
              color: ColorsConstants.instance.baseTheme.withOpacity(0.7)),
        ),
      ),
      onConfirm: (dateTime, List<int> index) {
        DateTime selectdate2 = dateTime;
        ikincidateTime = selectdate2;
        final bitisTarihi = DateFormat('yyyy-MM-dd HH:mm').format(selectdate2);
        setState(() {
          dbSaatbitis = '$bitisTarihi:00';
          gosterilenSaatbitis = dbSaatbitis.substring(0, 16);
          final DateFormat format = DateFormat.yMd('tr');
          var trTarih = format.format(DateTime.parse(gosterilenSaatbitis));
          gosterilenSaatbitis = trTarih;
          'ikinci tarih birinci tarihten sonra mı ? ${ikincidateTime.isAfter(birincidateTime)}'
              .log();
          if (ikincidateTime.isAfter(birincidateTime) == false) {
            gosterilenSaatbitis = '';
            ToastManager.instance
                .toastMessageService("Geçerli bir tarih seçin..");
          }
          if (dbSaatbaslangic != '' && dbSaatbitis != '') {
            //Saatler boş geçilmedi ise gerekli metot yazılsın
            debugPrint(dbSaatbaslangic);
            debugPrint(dbSaatbitis);
          }
        });
      },
    );
  }

  void seciliSorumlulariEkle() {
    if (widget.initialModel.initialSorumluAdlar != ',' &&
        widget.initialModel.initialSorumluAdlar.isNotEmpty) {
      context.read<ProjectCubit>().secilenAmirAdlar =
          widget.initialModel.initialSorumluAdlar.split(',').toSet().toList();
    }

    if (widget.initialModel.initialSorumluIdler != ',' &&
        widget.initialModel.initialSorumluIdler.isNotEmpty) {
      secilenAmirList = widget.initialModel.initialSorumluIdler.split(',');

      context.read<ProjectCubit>().secilenAmirIdler =
          widget.initialModel.initialSorumluIdler.split(',');

      gonderilecekAmirIdler = widget.initialModel.initialSorumluIdler
          .trim()
          .replaceAll(RegExp('^,|,\$'), '');
    }
  }

  void seciliGorevlileriEkle() {
    if (widget.initialModel.initialGorevlilerAdlar != ',' &&
        widget.initialModel.initialGorevlilerAdlar.isNotEmpty) {
      context.read<ProjectCubit>().secilenPersonelAdlar = widget
          .initialModel.initialGorevlilerAdlar
          .split(',')
          .toSet()
          .toList();
    }
    if (widget.initialModel.initialGorevliIdler != ',' &&
        widget.initialModel.initialGorevliIdler.isNotEmpty) {
      secilenPersonelList = widget.initialModel.initialGorevliIdler.split(',');
      context.read<ProjectCubit>().secilenPersonelIdler =
          widget.initialModel.initialGorevliIdler.split(',');
      gonderilecekPersonelIdler = widget.initialModel.initialGorevliIdler
          .trim()
          .replaceAll(RegExp('^,|,\$'), '');
    }
  }

  @override
  void deactivate() {
    super.deactivate();
    context.read<ProjectCubit>().secilenPersonelAdlar.clear();
    context.read<ProjectCubit>().secilenPersonelIdler.clear();
    context.read<ProjectCubit>().secilenAmirAdlar.clear();
    context.read<ProjectCubit>().secilenAmirIdler.clear();
  }

  bool isFinish = true;
}
