import 'package:flutter/material.dart';
import 'package:flutter_bloc/flutter_bloc.dart';
import 'package:hamlemuhcrm/core/extensions/responsive_extension.dart';
import 'package:hamlemuhcrm/core/extensions/string_extension.dart';
import 'package:hamlemuhcrm/features/auth/login/cubit/login_cubit.dart';
import 'package:hamlemuhcrm/features/profile/cubit/profile_cubit.dart';
import 'package:hamlemuhcrm/features/profile/cubit/profile_state.dart';
import 'package:hamlemuhcrm/features/profile/model/profile_permission.dart';

import '../../../core/constants/font_styles.dart';
import 'profile_user_permission_detail.dart';

class ProfilePermissionList extends StatelessWidget {
  const ProfilePermissionList({super.key});

  @override
  Widget build(BuildContext context) {
    return SizedBox(
      height: context.dynamicHeight(0.4),
      child: BlocBuilder<ProfileCubit, ProfileState>(
        bloc: ProfileCubit()
          ..profilePermissionList(
              context.read<LoginCubit>().token, context.read<LoginCubit>().id),
        builder: (context, state) => ListView.builder(
          itemCount: state.permissionList.length,
          itemBuilder: (context, index) {
            var izinlerNesnesi = state.permissionList[index];
            if (state.isLoading && !state.isError) {
              return const Center(child: CircularProgressIndicator.adaptive());
            } else if (state.isComplete && !state.isLoading && !state.isError) {
              if (state.permissionList.isNotEmpty) {
                String baslamaTarihiTR =
                    ''.toTrTypeNoHour(izinlerNesnesi.izinBaslamaTarihi!);
                String isbasiTarihiTR =
                    ''.toTrTypeNoHour(izinlerNesnesi.izinIsbasiTarihi!);

                return InkWell(
                  onTap: () =>
                      navDetailPage(context, state.permissionList[index]),
                  child: Stack(
                    children: [
                      Container(
                        margin: _marginPaddingAll(context),
                        height: context.dynamicHeight(0.045),
                        decoration: BoxDecoration(
                            border: Border.all(
                                color: Colors.grey.withOpacity(0.5), width: 1),
                            borderRadius: BorderRadius.circular(5)),
                        child: Row(
                          mainAxisAlignment: MainAxisAlignment.spaceEvenly,
                          children: [
                            Text('$baslamaTarihiTR - $isbasiTarihiTR',
                                style: FontStyles
                                    .instance.cevaplananIzinYaziKalin
                                    .copyWith(
                                        fontSize: Theme.of(context)
                                            .textTheme
                                            .labelSmall
                                            ?.fontSize)),
                            _emptyWidhtContainerSpace(context),
                            Text(
                                '${izinlerNesnesi.izinAlanAd} ${izinlerNesnesi.izinAlanSoyad}',
                                style: FontStyles.instance.cevaplananIzinYazi),
                          ],
                        ),
                      ),
                      Positioned(
                        top: 0,
                        right: 4,
                        child: Container(
                          height: context.dynamicHeight(0.023),
                          width: context.dynamicWidth(0.035),
                          decoration: const BoxDecoration(color: Colors.white),
                          child: Icon(
                            izinlerNesnesi.izinDurum == "2"
                                ? Icons.remove_circle_sharp
                                : Icons
                                    .check_circle_rounded, // bu kısım gelen değere göre değişecek... 1 gelirse onaylanmış 0 gelirse onaylanmamış
                            color: izinlerNesnesi.izinDurum == "2"
                                ? Colors.red
                                : Colors.green,
                            size: context.dynamicWidth(0.033),
                          ),
                        ),
                      ),
                    ],
                  ),
                );
              } else {
                return const Center(
                  child: Text('İzin Listesi Boş'),
                );
              }
            } else if (state.isError) {
              return Center(
                child: Text(
                  'Bir Sorun Oluştu !',
                  style: Theme.of(context).textTheme.bodyMedium,
                ),
              );
            }
            return Center(
              child: Text(
                'Bir Sorun Oluştu !',
                style: Theme.of(context).textTheme.bodyMedium,
              ),
            );
          },
        ),
      ),
    );
  }

  void navDetailPage(BuildContext context, ProfilePermission izinler) {
    context.read<ProfileCubit>().viewUpdateUserPermission(
        context.read<LoginCubit>().token,
        context.read<LoginCubit>().id,
        izinler.izinId!);
    Navigator.push(
        context,
        MaterialPageRoute(
            builder: (context) => ProfilePermissionDetail(izinler: izinler)));
  }

  Widget _emptyWidhtContainerSpace(BuildContext context) => SizedBox(
        width: context.dynamicWidth(0.01),
      );

  EdgeInsets _marginPaddingAll(BuildContext context) =>
      EdgeInsets.all(context.dynamicHeight(0.012));
}
