import 'package:hamlemuhcrm/features/permissions/model/izinler.dart';

class IzinlerCevap {
  List<Izinler>? izinler;
  int? success;
  String? message;

  IzinlerCevap({this.izinler, this.success, this.message});

  IzinlerCevap.fromJson(Map<String, dynamic> json) {
    if (json['izin_almalar'] != null) {
      izinler = <Izinler>[];
      json['izin_almalar'].forEach((v) {
        izinler!.add(Izinler.fromJson(v));
      });
    }
    success = json['success'];
    message = json['message'];
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = <String, dynamic>{};
    if (izinler != null) {
      data['izin_almalar'] = izinler!.map((v) => v.toJson()).toList();
    }
    data['success'] = success;
    data['message'] = message;
    return data;
  }
}
