class Izinler {
  String? izinId;
  String? izinUserfirmId;
  String? izinUserId;
  String? izinBaslamaTarihi;
  String? izinIsbasiTarihi;
  String? izinYerineBakacakUser;
  String? izinAciklama;
  String? izinSure;
  String? izinTipi;
  String? izinIslemYapanUserId;
  String? izinDurum;
  String? izinOnayUserId;
  String? izinAlanAd;
  String? izinAlanSoyad;

  Izinler({
    this.izinId,
    this.izinUserfirmId,
    this.izinUserId,
    this.izinBaslamaTarihi,
    this.izinIsbasiTarihi,
    this.izinYerineBakacakUser,
    this.izinAciklama,
    this.izinSure,
    this.izinTipi,
    this.izinIslemYapanUserId,
    this.izinDurum,
    this.izinOnayUserId,
    this.izinAlanAd,
    this.izinAlanSoyad,
  });

  factory Izinler.fromJson(Map<String, dynamic> json) {
    return Izinler(
      izinId: json["izin_id"] ?? "0",
      izinUserfirmId: json["izin_userfirm_id"] ?? "0",
      izinUserId: json["izin_user_id"] ?? "0",
      izinBaslamaTarihi: json["izin_baslama_tarihi"] ?? "0",
      izinIsbasiTarihi: json["izin_isbasi_tarihi"] ?? "0",
      izinYerineBakacakUser: json["izin_yerine_bakacak_user"] ?? "0",
      izinAciklama: json['izin_aciklama'] ?? "girilmemis",
      izinSure: json['izin_sure'] ?? "0",
      izinTipi: json['izin_tipi'] ?? "0",
      izinIslemYapanUserId: json['izin_islemyapan_user_id'] ?? "0",
      izinDurum: json['izin_durum'] ?? "1",
      izinOnayUserId: json['izin_onay_user_id'] ?? "0",
      izinAlanAd: json['izin_alan_ad'] ?? "0",
      izinAlanSoyad: json['izin_alan_soyad'] ?? "1",
    );
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = <String, dynamic>{};
    data['izin_id'] = izinId;
    data['izin_userfirm_id'] = izinUserfirmId;
    data['izin_user_id'] = izinUserId;
    data['izin_baslama_tarihi'] = izinBaslamaTarihi;
    data['izin_isbasi_tarihi'] = izinIsbasiTarihi;
    data['izin_yerine_bakacak_user'] = izinYerineBakacakUser;
    data['izin_aciklama'] = izinAciklama;
    data['izin_sure'] = izinSure;
    data['izin_tipi'] = izinTipi;
    data['izin_islemyapan_user_id'] = izinIslemYapanUserId;
    data['izin_durum'] = izinDurum;
    data['izin_onay_user_id'] = izinOnayUserId;
    data['izin_alan_ad'] = izinAlanAd;
    data['izin_alan_soyad'] = izinAlanSoyad;
    return data;
  }
}
