import 'package:flutter/material.dart';
import '../../../core/constants/color_constants.dart';
import 'package:hamlemuhcrm/core/extensions/image_enum_extension.dart';
import 'package:hamlemuhcrm/core/extensions/responsive_extension.dart';

class PermissionsButton extends StatelessWidget {
  const PermissionsButton({super.key});

  @override
  Widget build(BuildContext context) {
    return SizedBox(
      height: context.dynamicHeight(0.05),
      width: context.dynamicWidth(0.30),
      child: TextButton(
        onPressed: () {
          showDialog(
              context: context,
              builder: (context) {
                return AlertDialog(
                  shape: const RoundedRectangleBorder(
                      borderRadius: BorderRadius.all(Radius.circular(15))),
                  content: SizedBox(
                    height: context.dynamicHeight(0.44),
                    width: context.dynamicWidth(0.85),
                    child: Column(
                      children: [
                        Row(
                          children: [
                            Text(
                              'İzni Onayla',
                              style: TextStyle(
                                  fontSize: 12, color: Colors.grey.shade600),
                            ),
                            const Spacer(),
                            const Icon(Icons.close_rounded,
                                size: 12, color: Colors.black87),
                          ],
                        ),
                        Divider(
                          color: Colors.black.withOpacity(0.7),
                        ),
                        SizedBox(
                            height: context.dynamicHeight(0.23),
                            child: ImageEnums.question.toPageImage),
                        SizedBox(
                          height: context.dynamicHeight(0.04),
                        ),
                        Text(
                          'Şu şu şu kişi şu tarihlerde şu sebepten izin istiyor',
                          style: TextStyle(
                              color: Colors.orange.shade900, fontSize: 14),
                          textAlign: TextAlign.center,
                        ),
                        SizedBox(
                          height: context.dynamicHeight(0.04),
                        ),
                        const Text(
                          "Devam etmek için tamam'a veya geçerli sayfada kalmak için reddet'e basın ",
                          style: TextStyle(color: Colors.black, fontSize: 11),
                          textAlign: TextAlign.center,
                        ),
                      ],
                    ),
                  ),
                  actions: [
                    Row(
                      mainAxisAlignment: MainAxisAlignment.center,
                      children: [
                        SizedBox(
                          height: context.dynamicHeight(0.05),
                          width: context.dynamicWidth(0.25),
                          child: TextButton(
                            onPressed: () {},
                            style: TextButton.styleFrom(
                                backgroundColor: Colors.orange.shade900,
                                side: BorderSide(
                                    color: Colors.black.withOpacity(0.3))),
                            child: const Text(
                              'Onayla',
                              style: TextStyle(color: Colors.white),
                            ),
                          ),
                        ),
                        SizedBox(
                          width: context.dynamicWidth(0.05),
                        ),
                        SizedBox(
                          height: context.dynamicHeight(0.05),
                          width: context.dynamicWidth(0.25),
                          child: TextButton(
                            onPressed: () {
                              Navigator.pop(context);
                            },
                            style: TextButton.styleFrom(
                              backgroundColor: Colors.grey.shade300,
                              side: BorderSide(
                                  color: Colors.black.withOpacity(0.3)),
                            ),
                            child: Text(
                              'Reddet',
                              style: TextStyle(color: Colors.orange.shade900),
                            ),
                          ),
                        ),
                        SizedBox(
                          height: context.dynamicHeight(0.1),
                        ),
                      ],
                    ),
                  ],
                );
              });
        },
        style: TextButton.styleFrom(
          backgroundColor: ColorsConstants.instance.backgroundColor,
        ),
        child: const Text(
          'İzin Talepleri',
          style: TextStyle(color: Colors.white),
        ),
      ),
    );
  }
}
