import 'package:flutter/material.dart';
import '../../../../core/extensions/responsive_extension.dart';

class EmployeeTextFieldInput extends InputDecoration {
  EmployeeTextFieldInput(BuildContext context, String hintTxt)
      : super(
            hintText: hintTxt,
            hintStyle: const TextStyle(color: Colors.black54, fontSize: 14),
            contentPadding:
                EdgeInsets.symmetric(horizontal: context.dynamicWidth(0.02)),
            border: const OutlineInputBorder(
              borderSide: BorderSide.none,
            ));
}
