import 'package:equatable/equatable.dart';

final class HomeState extends Equatable {
  final int pageIndex;
  final int badgeCount;
  final bool isLoading;
  final bool isComplete;
  final bool isError;

  const HomeState(
      {required this.pageIndex,
      required this.badgeCount,
      required this.isLoading,
      required this.isComplete,
      required this.isError});

  factory HomeState.initial() {
    return const HomeState(
      pageIndex: 0,
      badgeCount: 0,
      isLoading: false,
      isError: false,
      isComplete: false,
    );
  }

  HomeState copyWith({
    int? pageIndex,
    int? badgeCount,
    bool? isLoading,
    bool? isError,
    bool? isComplete,
  }) {
    return HomeState(
      pageIndex: pageIndex ?? this.pageIndex,
      badgeCount: badgeCount ?? this.badgeCount,
      isLoading: isLoading ?? this.isLoading,
      isError: isError ?? this.isError,
      isComplete: isComplete ?? this.isComplete,
    );
  }

  @override
  List<Object?> get props =>
      [pageIndex, badgeCount, isLoading, isError, isComplete];
}
