import 'package:flutter/material.dart';
import 'package:google_fonts/google_fonts.dart';

import 'package:hamlemuhcrm/core/extensions/image_enum_extension.dart';
import 'package:hamlemuhcrm/features/customers/widgets/int_textfield.dart';
import 'package:hamlemuhcrm/features/customers/widgets/string_textfield.dart';
import 'package:hamlemuhcrm/features/customers/widgets/web_textfield.dart';
import 'package:hamlemuhcrm/core/extensions/responsive_extension.dart';

import '../../../../core/constants/app_constants.dart';
import '../../../../core/constants/color_constants.dart';

class AddPerson extends StatefulWidget {
  const AddPerson({super.key});

  @override
  State<AddPerson> createState() => _AddPersonState();
}

class _AddPersonState extends State<AddPerson> {
  final _addPersonKey = GlobalKey<FormState>();

  final tcKisiAdSoyad = TextEditingController();
  final tcKisiBirim = TextEditingController();
  final tcKisiCepNo = TextEditingController();
  final tcKisiMail = TextEditingController();
  final tcKisiAdres = TextEditingController();

  @override
  Widget build(BuildContext context) {
    return Scaffold(
      appBar: AppBar(
        backgroundColor: Colors.transparent,
        elevation: 0,
        title: Text('Kişi Ekle',
            style: GoogleFonts.inter(
                color: Colors.black,
                fontWeight: FontWeight.w400,
                fontSize: 16)),
        centerTitle: true,
        actions: [
          IconButton(
              onPressed: () {},
              icon: const Icon(
                Icons.notifications_none_outlined,
                color: Colors.black,
              )),
        ],
        leading: IconButton(
            onPressed: () {
              Navigator.pop(context, true);
            },
            icon: const Icon(
              Icons.arrow_back_ios_new,
              color: Colors.black54,
              size: 20,
            )),
      ),
      body: SingleChildScrollView(
        child: Padding(
          padding:
              EdgeInsets.symmetric(horizontal: context.dynamicHeight(0.03)),
          child: Column(
            children: [
              const SizedBox(height: 4),
              Container(
                width: context.dynamicWidth(1),
                decoration: BoxDecoration(
                    borderRadius: BorderRadius.circular(15),
                    color: Colors.white,
                    boxShadow: [
                      BoxShadow(
                        color: Colors.grey.withOpacity(0.2),
                        blurRadius: 7,
                        offset: const Offset(4, 5),
                      )
                    ]),
                child: Padding(
                  padding:
                      const EdgeInsets.symmetric(vertical: 10, horizontal: 17),
                  child: Form(
                    key: _addPersonKey,
                    child: Column(
                      mainAxisAlignment: MainAxisAlignment.center,
                      children: [
                        SizedBox(
                            height: context.dynamicHeight(0.2),
                            child: ImageEnums.employee.toPageImage),
                        const SizedBox(height: 10),
                        const Row(
                          mainAxisAlignment: MainAxisAlignment.start,
                          children: [
                            Text(
                              'Ad Soyad',
                              style:
                                  TextStyle(color: Colors.grey, fontSize: 11),
                            ),
                          ],
                        ),
                        const SizedBox(height: 5),
                        StringTextField(
                          textEditingController: tcKisiAdSoyad,
                          aciklama: '',
                          yukseklik: context.dynamicHeight(0.05),
                          satirSayisi: 1,
                          kenarlik: true,
                          golge: false,
                          arkaplanRengi:
                              ColorsConstants.instance.backgroundColor,
                          tekSatirMi: true,
                          kisitlama: 30,
                        ),
                        const SizedBox(height: 10),
                        const Row(
                          mainAxisAlignment: MainAxisAlignment.start,
                          children: [
                            Text(
                              'İlgili Birim',
                              style:
                                  TextStyle(color: Colors.grey, fontSize: 11),
                            ),
                          ],
                        ),
                        const SizedBox(height: 5),
                        WebTextField(
                          textEditingController: tcKisiBirim,
                          aciklama: '',
                          yukseklik: context.dynamicHeight(0.05),
                          satirSayisi: 1,
                          kenarlik: true,
                          golge: false,
                          arkaplanRengi:
                              ColorsConstants.instance.backgroundColor,
                          tekSatirMi: true,
                          kisitlama: 37,
                        ),
                        const SizedBox(height: 10),
                        const Row(
                          mainAxisAlignment: MainAxisAlignment.start,
                          children: [
                            Text(
                              'Mail Adresi',
                              style:
                                  TextStyle(color: Colors.grey, fontSize: 11),
                            ),
                          ],
                        ),
                        const SizedBox(height: 5),
                        StringTextField(
                          textEditingController: tcKisiMail,
                          aciklama: 'Mail Adresi Girin',
                          yukseklik: context.dynamicHeight(0.05),
                          satirSayisi: 1,
                          kenarlik: true,
                          golge: false,
                          arkaplanRengi:
                              ColorsConstants.instance.backgroundColor,
                          tekSatirMi: true,
                          kisitlama: 70,
                        ),
                        const SizedBox(height: 10),
                        const Row(
                          mainAxisAlignment: MainAxisAlignment.start,
                          children: [
                            Text(
                              'Cep No',
                              style:
                                  TextStyle(color: Colors.grey, fontSize: 11),
                            ),
                          ],
                        ),
                        const SizedBox(height: 5),
                        IntTextField(
                          textEditingController: tcKisiCepNo,
                          aciklama: '',
                          yukseklik: context.dynamicHeight(0.05),
                          satirSayisi: 1,
                          kenarlik: true,
                          golge: false,
                          arkaplanRengi:
                              ColorsConstants.instance.backgroundColor,
                          tekSatirMi: true,
                          kisitlama: 11,
                        ),
                        const SizedBox(height: 10),
                        const Row(
                          mainAxisAlignment: MainAxisAlignment.start,
                          children: [
                            Text(
                              'Adres',
                              style:
                                  TextStyle(color: Colors.grey, fontSize: 11),
                            ),
                          ],
                        ),
                        const SizedBox(height: 5),
                        StringTextField(
                          textEditingController: tcKisiAdres,
                          aciklama: '',
                          yukseklik: context.dynamicHeight(0.09),
                          satirSayisi: 3,
                          kenarlik: true,
                          golge: false,
                          arkaplanRengi:
                              ColorsConstants.instance.backgroundColor,
                          tekSatirMi: false,
                          kisitlama: 100,
                        ),
                        const SizedBox(height: 14),
                        Container(
                          height: context.dynamicHeight(0.05),
                          decoration: BoxDecoration(
                              color: ColorsConstants.instance.baseTheme,
                              borderRadius: BorderRadius.circular(10),
                              boxShadow: [
                                BoxShadow(
                                  color: Colors.grey.withOpacity(0.4),
                                  blurRadius: 8,
                                  offset: const Offset(1, 1),
                                )
                              ]),
                          child: TextButton(
                              onPressed: () {
                                if (_addPersonKey.currentState!.validate()) {}
                              },
                              style: TextButton.styleFrom(
                                  backgroundColor: Colors.transparent,
                                  shape: RoundedRectangleBorder(
                                    borderRadius: BorderRadius.circular(10),
                                  )),
                              child: Padding(
                                padding: const EdgeInsets.symmetric(
                                    horizontal: 10.0),
                                child: Text(
                                  ApplicationConstants.instance.moduleSaveTxt,
                                  style: const TextStyle(color: Colors.white),
                                ),
                              )),
                        ),
                      ],
                    ),
                  ),
                ),
              ),
              const SizedBox(height: 15),
            ],
          ),
        ),
      ),
    );
  }
}
