import 'dart:convert';

import 'package:dio/dio.dart';
import 'package:flutter/material.dart';
import 'package:flutter_bloc/flutter_bloc.dart';
import 'package:hamlemuhcrm/core/extensions/log_extension.dart';

import '../../../../../core/constants/url_services_constant.dart';
import '../../../../auth/login/cubit/login_cubit.dart';
import '../create_activity.dart';

mixin CreateActivityMixin on State<CreateActivity> {
  //////////////////////////////// class fields /////////////////////////////////////////////////////////
  final String baseURL = URLAPIService.baseURL;
  bool isFinish = false;
  final textcAktiviteBaslik = TextEditingController();
  final textcAciklama = TextEditingController();

  bool saatSecildi = false;
  String dbSaat = '';
  String gosterilenSaat = '';

  //////////////////////////////// firmalar dd /////////////////////////////////////////////////////////

  String gonderilenfirmaID = "";
  String? secilenFirma;
  final String firmaid = "1";
  String secilifirmaAdi = '';
  bool onceYetkiliSec = false;
  Map<String, dynamic>? gelenFirmalar;

  Future<void> firmaData(String token, String loginuserid) async {
    var firmalarURL = "$baseURL/mobil/api/dd/firma_dd_pdo.php";
    var veri = {"token": token, "loginuserid": loginuserid};
    var firmalarCevap =
        await Dio().post(firmalarURL, data: FormData.fromMap(veri));
    if (firmalarCevap.statusCode == 200) {
      setState(() {
        gelenFirmalar = json.decode(firmalarCevap.data.toString());
        debugPrint("data_01 = $gelenFirmalar");
      });
    } else {}
  }

  //////////////////////////////// yetkili dd /////////////////////////////////////////////////////////

  Map<String, dynamic>? gelenYetkililer;
  String? secilenYetkili;
  String gonderilenYetkiliID = "";
  bool yetkiliListesiBosMu = false;

  Future<void> yetkiliData(res01, String token, String loginuserid) async {
    var yetkililerURL = "$baseURL/mobil/api/dd/yetkili_dd_pdo.php";
    var veri = {
      "yetkili_firma_id": secilenFirma ?? firmaid,
      "token": token,
      "loginuserid": loginuserid
    };
    var yetkililerCevap =
        await Dio().post(yetkililerURL, data: FormData.fromMap(veri));
    '${yetkililerCevap.data}'.log();

    if (yetkililerCevap.statusCode == 200) {
      setState(() {
        gelenYetkililer = json.decode(yetkililerCevap.data.toString());
        yetkiliListesiBosMu =
            gelenYetkililer.toString().contains('{firma_yetkililer: []}');
      });
    } else {}
  }

  String txtSigdir(String txt, String? txt2) {
    return txt.length > 24
        ? '${txt.substring(0, 23)} ${txt2 ?? 'Unvan Yok'}'
        : '$txt $txt2';
  }

  //////////////////////////////// calisan dd /////////////////////////////////////////////////////////

  Map<String, dynamic>? gelenCalisanlar;
  String gonderilenCalisanID = "";
  String? secilenCalisan;

  Future<void> calisanData(
      String token, String loginuserid, String userfirmid) async {
    var calisanURL = "$baseURL/mobil/api/dd/personel_dd_pdo.php";
    var veri = {
      "token": token,
      "loginuserid": loginuserid,
      "userfirmid": userfirmid
    };
    var calisanCevap =
        await Dio().post(calisanURL, data: FormData.fromMap(veri));
    if (calisanCevap.statusCode == 200) {
      setState(() {
        gelenCalisanlar = json.decode(calisanCevap.data);
      });
    } else {}
  }

  //////////////////////////////// gorusme tipi dd /////////////////////////////////////////////////////////

  String? secilenGorusme;

  /////////////////////////////////////////////////////////////////////////////////////////////////////////////

  void ddBilgilerCek() async {
    isFinish = false;
    final String token = context.read<LoginCubit>().token;
    final String loginid = context.read<LoginCubit>().id;
    final String userfirmid = context.read<LoginCubit>().userfirmId;
    // ilk açıldığında seçili olarak login olan kişi gelecek
    secilenCalisan = loginid;
    gonderilenCalisanID = loginid;
    await firmaData(
        context.read<LoginCubit>().token, context.read<LoginCubit>().id);
    await yetkiliData(firmaid, token, loginid);
    await calisanData(token, loginid, userfirmid);
    isFinish = true;
  }

  @override
  void initState() {
    ddBilgilerCek();
    super.initState();
  }
}
