import 'package:dropdown_button2/dropdown_button2.dart';
import 'package:flutter/material.dart';
import 'package:flutter_bloc/flutter_bloc.dart';
import 'package:flutter_cupertino_datetime_picker/flutter_cupertino_datetime_picker.dart';
import 'package:intl/intl.dart';
import 'package:hamlemuhcrm/core/extensions/log_extension.dart';
import 'package:hamlemuhcrm/features/customers/model/new_activity.dart';

import '../../../../core/constants/app_constants.dart';
import '../../../../core/constants/color_constants.dart';
import '../../../../core/constants/font_styles.dart';
import '../../../../core/extensions/responsive_extension.dart';
import '../../../../core/utility/toast_manager.dart';
import '../../../../data/dropdown_models/personal_getdata_api.dart';
import '../../../auth/login/cubit/login_cubit.dart';
import '../../cubit/activity_cubit.dart';
import '../../cubit/activity_state.dart';
import '../../cubit/customers_cubit.dart';
import '../../widgets/custom_activity_textfield.dart';
import '../../widgets/string_textfield.dart';
import '../companies/add_person_parametry.dart';
import 'mixin/create_activity_mixin.dart';

class CreateActivity extends StatefulWidget {
  const CreateActivity({super.key});

  @override
  State<CreateActivity> createState() => _CreateActivityState();
}

class _CreateActivityState extends State<CreateActivity>
    with CreateActivityMixin {
  Widget get firmalarDD {
    List<FirmaDDModel> firmalar = List<FirmaDDModel>.from(
      gelenFirmalar?['firmalar'].map(
        (i) {
          return FirmaDDModel.fromJSON(i);
        },
      ),
    );
    firmalar.sort(
      (a, b) => a.firmaIsim.compareTo(b.firmaIsim),
    ); // DROPDOWN SIRALAMASI
    return DropdownButtonHideUnderline(
      child: DropdownButton2(
        hint: Row(
          children: [
            Icon(Icons.business_rounded,
                color: ColorsConstants.instance.baseTheme),
            const SizedBox(width: 14),
            const Text(
              'Firma Seçiniz...',
              style: TextStyle(color: Colors.grey, fontSize: 14),
            )
          ],
        ), //Data1
        isExpanded: true,
        items: firmalar.map((firmalar) {
          return DropdownMenuItem(
            value: firmalar.firmaId,
            child: Text(
                firmalar.firmaIsim.toString().length > 35
                    ? "${firmalar.firmaIsim.toString().substring(0, 34)}.. "
                    : firmalar.firmaIsim,
                style: FontStyles.instance.ddYazi),
            onTap: () {
              secilifirmaAdi = firmalar.firmaIsim.toString();
            }, //value
          );
        }).toList(),
        value: secilenFirma,
        onChanged: (newValue) {
          setState(() {
            onceYetkiliSec = true;
            secilenFirma = newValue.toString();
            gonderilenfirmaID = secilenFirma!;
            yetkiliData(firmaid, context.read<LoginCubit>().token,
                context.read<LoginCubit>().id);
            secilenYetkili = null;
          });
        },
        buttonStyleData: ButtonStyleData(
          height: context.dynamicHeight(0.054),
          width: context.dynamicWidth(0.9),
          padding: const EdgeInsets.symmetric(horizontal: 10),
          decoration: BoxDecoration(
              borderRadius: BorderRadius.circular(10),
              color: Colors.white,
              border: Border.all(color: Colors.grey.withOpacity(0.25))),
          elevation: 0,
        ),
        iconStyleData: IconStyleData(
          icon: const Icon(
            Icons.keyboard_arrow_down_outlined, //ilk icon
          ),
          openMenuIcon: const Icon(
              Icons.keyboard_arrow_left_outlined), //açıldıktan sonraki icon
          iconSize: 23,
          iconEnabledColor: ColorsConstants.instance.baseTheme,
          iconDisabledColor: Colors.white,
        ),
        dropdownStyleData: DropdownStyleData(
          maxHeight: context.dynamicHeight(0.17),
          isOverButton: false,
          padding: null,
          decoration: BoxDecoration(
            borderRadius: BorderRadius.circular(10),
            color: ColorsConstants
                .instance.backgroundColor, //açılır menü arkaplan rengi
          ),
          elevation: 8,
          offset: const Offset(0, 0),
          scrollbarTheme: ScrollbarThemeData(
            thumbColor: MaterialStateColor.resolveWith((states) =>
                ColorsConstants
                    .instance.baseTheme), //dropdown scroll rengi değiştirme
            radius: const Radius.circular(10),
            thickness: MaterialStateProperty.all<double>(6),
            thumbVisibility: MaterialStateProperty.all<bool>(true),
          ),
        ),
        menuItemStyleData: const MenuItemStyleData(
          height: 35,
          padding: EdgeInsets.symmetric(horizontal: 14),
        ),
      ),
    );
  }

  Widget get yetkiliDD {
    List<YetkiliDDModel> personelListesi =
        List<YetkiliDDModel>.from(gelenYetkililer?['firma_yetkililer'].map((i) {
      return YetkiliDDModel.fromJSON(i);
    }));

    return DropdownButtonHideUnderline(
      child: onceYetkiliSec
          ? DropdownButton2(
              hint: yetkiliListesiBosMu
                  ? const Text(
                      "Lütfen önce yetkili ekleyin",
                      style: TextStyle(fontSize: 13, color: Colors.black54),
                    )
                  : const Text(
                      "",
                      style: TextStyle(fontSize: 13, color: Colors.black54),
                    ),
              isExpanded: true,
              items: personelListesi.map((personel) {
                return DropdownMenuItem(
                  value: personel.yetkiliId,
                  child: Text(
                    txtSigdir(
                        personel.yetkiliAdSoyad, personel.yetkiliIlgiliBirim),
                    style: FontStyles.instance.ddYazi,
                  ), //DATA SENDING
                );
              }).toList(),
              value: secilenYetkili,
              onChanged: (newValue) {
                setState(() {
                  secilenYetkili = newValue.toString();
                  gonderilenYetkiliID = secilenYetkili!; //medium new
                  "seçilen personel == $secilenYetkili".log();
                });
              },
              buttonStyleData: ButtonStyleData(
                height: context.dynamicHeight(0.054),
                width: context.dynamicWidth(0.9),
                padding: const EdgeInsets.symmetric(horizontal: 10),
                decoration: BoxDecoration(
                  borderRadius: BorderRadius.circular(10),
                  color: Colors.white,
                  boxShadow: [
                    BoxShadow(
                        color: Colors.grey.withOpacity(0.3),
                        offset: const Offset(0.4, 0.3),
                        blurRadius: 7)
                  ],
                ),
                elevation: 0,
              ),
              iconStyleData: IconStyleData(
                icon: const Icon(
                  Icons.keyboard_arrow_down_outlined, //ilk icon
                ),
                openMenuIcon: const Icon(Icons
                    .keyboard_arrow_left_outlined), //açıldıktan sonraki icon
                iconSize: 23,
                iconEnabledColor: ColorsConstants.instance.baseTheme,
                iconDisabledColor: Colors.white,
              ),
              dropdownStyleData: DropdownStyleData(
                maxHeight: context.dynamicHeight(0.17),
                isOverButton: false,
                width: context.dynamicWidth(0.9),
                padding: null,
                decoration: BoxDecoration(
                  borderRadius: BorderRadius.circular(10),
                  color: ColorsConstants
                      .instance.backgroundColor, //açılır menü arkaplan rengi
                ),
                elevation: 8,
                offset: const Offset(0, 0),
                scrollbarTheme: ScrollbarThemeData(
                  thumbColor: MaterialStateColor.resolveWith((states) =>
                      ColorsConstants.instance
                          .baseTheme), //dropdown scroll rengi değiştirme
                  radius: const Radius.circular(10),
                  thickness: MaterialStateProperty.all<double>(6),
                  thumbVisibility: MaterialStateProperty.all<bool>(true),
                ),
              ),
              menuItemStyleData: const MenuItemStyleData(
                height: 35,
                padding: EdgeInsets.symmetric(horizontal: 14),
              ),
            )
          : _inActiveDD(context),
    );
  }

  Widget calisanDD() {
    List<CalisanDDModel> calisanListesi = List<CalisanDDModel>.from(
      gelenCalisanlar?["users"].map(
        (i) {
          return CalisanDDModel.fromJSON(i);
        },
      ),
    );

    return DropdownButtonHideUnderline(
      child: DropdownButton2(
        hint: const Text(
          "",
          style: TextStyle(fontSize: 12, color: Colors.black54),
        ), //Data1
        isExpanded: true,
        items: calisanListesi.map((calisan) {
          return DropdownMenuItem(
            value: calisan.id,
            child: Text('${calisan.firstName} ${calisan.lastName}',
                style: FontStyles.instance.ddYazi), //value
          );
        }).toList(),
        value: calisanListesi
            .where((element) => element.id == secilenCalisan)
            .first
            .id,
        onChanged: (newValue) {
          setState(() {
            secilenCalisan = newValue.toString();
            gonderilenCalisanID = secilenCalisan!;
            "_secilen CalisanID == $secilenCalisan".log();
          });
        },
        buttonStyleData: ButtonStyleData(
          height: context.dynamicHeight(0.054),
          width: context.dynamicWidth(0.9),
          padding: const EdgeInsets.symmetric(horizontal: 10),
          decoration: BoxDecoration(
            borderRadius: BorderRadius.circular(10),
            color: Colors.white,
            boxShadow: [
              BoxShadow(
                  color: Colors.grey.withOpacity(0.3),
                  offset: const Offset(0.4, 0.3),
                  blurRadius: 7)
            ],
          ),
          elevation: 0,
        ),
        iconStyleData: IconStyleData(
          icon: const Icon(
            Icons.keyboard_arrow_down_outlined, //ilk icon
          ),
          openMenuIcon: const Icon(
              Icons.keyboard_arrow_left_outlined), //açıldıktan sonraki icon
          iconSize: 23,
          iconEnabledColor: ColorsConstants.instance.baseTheme,
          iconDisabledColor: Colors.white,
        ),
        dropdownStyleData: DropdownStyleData(
          maxHeight: context.dynamicHeight(0.17),
          isOverButton: false,
          width: context.dynamicWidth(0.9),
          padding: null,
          decoration: BoxDecoration(
            borderRadius: BorderRadius.circular(10),
            color: ColorsConstants
                .instance.backgroundColor, //açılır menü arkaplan rengi
          ),
          elevation: 8,
          offset: const Offset(0, 0),
          scrollbarTheme: ScrollbarThemeData(
            thumbColor: MaterialStateColor.resolveWith((states) =>
                ColorsConstants
                    .instance.baseTheme), //dropdown scroll rengi değiştirme
            radius: const Radius.circular(10),
            thickness: MaterialStateProperty.all<double>(6),
            thumbVisibility: MaterialStateProperty.all<bool>(true),
          ),
        ),
        menuItemStyleData: const MenuItemStyleData(
          height: 35,
          padding: EdgeInsets.symmetric(horizontal: 14),
        ),
      ),
    );
  }

  @override
  Widget build(BuildContext context) {
    return Scaffold(
      appBar: AppBar(
        backgroundColor: Colors.transparent,
        elevation: 0,
        title: Text('Aktivite Oluştur',
            style: FontStyles.instance.appbarTitleStyle),
        centerTitle: true,
        actions: [
          IconButton(
            onPressed: () {},
            icon: const Icon(
              Icons.notifications_none_outlined,
              color: Colors.black,
            ),
          ),
        ],
        leading: IconButton(
          onPressed: () {
            Navigator.of(context).popUntil((route) => route.isFirst);
          },
          icon: const Icon(
            Icons.arrow_back_ios_new,
            color: Colors.black54,
            size: 20,
          ),
        ),
      ),
      body: SingleChildScrollView(
        child: isFinish
            ? Padding(
                padding: EdgeInsets.symmetric(
                    horizontal: context.dynamicHeight(0.02)),
                child: Column(
                  children: [
                    const SizedBox(height: 4),
                    Container(
                      padding: const EdgeInsets.symmetric(horizontal: 14),
                      height: context.dynamicHeight(0.164),
                      decoration: BoxDecoration(
                          borderRadius: BorderRadius.circular(15),
                          color: Colors.white,
                          boxShadow: [
                            BoxShadow(
                              color: Colors.grey.withOpacity(0.2),
                              blurRadius: 7,
                              offset: const Offset(4, 5),
                            )
                          ]),
                      child: Column(
                        mainAxisAlignment: MainAxisAlignment.spaceEvenly,
                        children: [
                          CustomActivityTextField(
                              tf: textcAktiviteBaslik,
                              icon: Icons.stacked_line_chart_rounded,
                              icYazi: 'Aktivite Başlığı Giriniz..',
                              iconRenk: Colors.blue,
                              yukseklik: 0.054),
                          firmalarDD,
                        ],
                      ),
                    ),
                    const SizedBox(height: 15),
                    Row(
                      mainAxisAlignment: MainAxisAlignment.start,
                      children: [
                        const SizedBox(width: 5),
                        Container(
                          height: context.dynamicWidth(0.042),
                          width: context.dynamicWidth(0.042),
                          decoration: BoxDecoration(
                            borderRadius: BorderRadius.circular(7),
                            color: Colors.blue.withOpacity(0.2),
                          ),
                          child: const Icon(
                            Icons.person_outline_outlined,
                            size: 13,
                            color: Colors.blue,
                          ),
                        ),
                        const SizedBox(width: 10),
                        Row(
                          children: [
                            const Text('Görüşülen Firma Yetkilisi'),
                            SizedBox(
                              height: context.dynamicHeight(0.044),
                              width: context.dynamicWidth(0.07),
                              child: IconButton(
                                  tooltip: "Yetkili Ekle",
                                  onPressed: () {
                                    gonderilenfirmaID == ''
                                        ? ToastManager.instance
                                            .toastMessageService(
                                                "Bir Firma Seçin !")
                                        : Navigator.push(
                                            context,
                                            MaterialPageRoute(
                                                builder: (context) =>
                                                    AddPersonParametry(
                                                        id: gonderilenfirmaID,
                                                        firmaAd: secilifirmaAdi,
                                                        durum: 3)));
                                  },
                                  icon: const Icon(
                                    Icons.add_circle_outlined,
                                    color: Colors.blue,
                                    size: 15,
                                  )),
                            ),
                          ],
                        ),
                        const SizedBox(height: 7),
                      ],
                    ),
                    const SizedBox(height: 5),
                    yetkiliDD,
                    yetkiliListesiBosMu
                        ? const SizedBox(height: 13)
                        : const SizedBox(height: 7),
                    Row(
                      mainAxisAlignment: MainAxisAlignment.start,
                      children: [
                        const SizedBox(width: 5),
                        Container(
                          height: context.dynamicWidth(0.042),
                          width: context.dynamicWidth(0.042),
                          decoration: BoxDecoration(
                            borderRadius: BorderRadius.circular(7),
                            color: Colors.orangeAccent.withOpacity(0.2),
                          ),
                          child: const Icon(
                            Icons.people_alt_outlined,
                            size: 13,
                            color: Colors.orangeAccent,
                          ),
                        ),
                        const SizedBox(width: 10),
                        const Text('Görüşmeye Katılan Personel'),
                      ],
                    ),
                    yetkiliListesiBosMu
                        ? const SizedBox(height: 10)
                        : const SizedBox(height: 8),
                    calisanDD(),
                    yetkiliListesiBosMu
                        ? const SizedBox(height: 10)
                        : const SizedBox(height: 7),
                    Row(
                      mainAxisAlignment: MainAxisAlignment.start,
                      children: [
                        const SizedBox(width: 5),
                        Container(
                          height: context.dynamicWidth(0.042),
                          width: context.dynamicWidth(0.042),
                          decoration: BoxDecoration(
                            borderRadius: BorderRadius.circular(7),
                            color: Colors.green.withOpacity(0.2),
                          ),
                          child: const Icon(
                            Icons.calendar_month,
                            size: 13,
                            color: Colors.green,
                          ),
                        ),
                        const SizedBox(width: 10),
                        const Text('Görüşme Tarihi'),
                      ],
                    ),
                    const SizedBox(height: 5),
                    Container(
                        height: context.dynamicHeight(0.055),
                        width: context.dynamicWidth(0.9),
                        decoration: BoxDecoration(
                            borderRadius: BorderRadius.circular(10),
                            color: Colors.white,
                            boxShadow: [
                              BoxShadow(
                                  color: Colors.grey.withOpacity(0.3),
                                  offset: const Offset(0.4, 0.3),
                                  blurRadius: 7)
                            ]),
                        child: Row(
                          children: [
                            const SizedBox(width: 10),
                            Text(
                              gosterilenSaat,
                              style: FontStyles.instance.ddYazi,
                            ),
                            const Spacer(),
                            IconButton(
                                onPressed: () {
                                  dateTimePickerWidget(context);
                                },
                                tooltip: 'Tarih Seç',
                                icon: Icon(
                                  Icons.keyboard_arrow_down_outlined,
                                  size: 23,
                                  color: ColorsConstants.instance.baseTheme,
                                )),
                          ],
                        )),
                    const SizedBox(height: 10),
                    Row(
                      mainAxisAlignment: MainAxisAlignment.start,
                      children: [
                        const SizedBox(width: 5),
                        Container(
                          height: context.dynamicWidth(0.042),
                          width: context.dynamicWidth(0.042),
                          decoration: BoxDecoration(
                            borderRadius: BorderRadius.circular(7),
                            color: Colors.purpleAccent.withOpacity(0.2),
                          ),
                          child: const Icon(
                            Icons.commit_outlined,
                            size: 13,
                            color: Colors.purpleAccent,
                          ),
                        ),
                        const SizedBox(width: 10),
                        Text(
                          'Görüşme Tipi',
                          style: FontStyles.instance.ddBaslik,
                        )
                      ],
                    ),
                    Padding(
                      padding: const EdgeInsets.only(top: 8.0, bottom: 8.0),
                      child: DropdownButtonHideUnderline(
                        child: DropdownButton2(
                          isExpanded: true,
                          value: secilenGorusme,
                          items: ApplicationConstants.instance.callType.entries
                              .map((entry) => DropdownMenuItem<String>(
                                    value: entry.key,
                                    child: Text(
                                      entry.value,
                                      style: FontStyles.instance.ddYazi,
                                    ),
                                  ))
                              .toList(),
                          onChanged: (value) {
                            secilenGorusme = value;
                            setState(() {
                              context
                                  .read<CustomersCubit>()
                                  .secilenGorusmeTipi = secilenGorusme!;
                            });
                            'Seçilen Deger DD : $value'.log();
                            'Secilen Deger Cubit : ${context.read<CustomersCubit>().secilenGorusmeTipi}'
                                .log();
                          },
                          buttonStyleData: ButtonStyleData(
                            height: context.dynamicHeight(0.054),
                            width: context.dynamicWidth(0.9),
                            padding: const EdgeInsets.symmetric(horizontal: 10),
                            decoration: BoxDecoration(
                                borderRadius: BorderRadius.circular(10),
                                color: Colors.white,
                                boxShadow: [
                                  BoxShadow(
                                      color: Colors.grey.withOpacity(0.3),
                                      offset: const Offset(0.4, 0.3),
                                      blurRadius: 7)
                                ]),
                            elevation: 0,
                          ),
                          iconStyleData: IconStyleData(
                            icon: const Icon(
                              Icons.keyboard_arrow_down_outlined, //ilk icon
                            ),
                            openMenuIcon: const Icon(Icons
                                .keyboard_arrow_left_outlined), //açıldıktan sonraki icon
                            iconSize: 23,
                            iconEnabledColor:
                                ColorsConstants.instance.baseTheme,
                            iconDisabledColor: Colors.white,
                          ),
                          dropdownStyleData: DropdownStyleData(
                            maxHeight: context.dynamicHeight(0.17),
                            isOverButton: false,
                            width: context.dynamicWidth(0.9),
                            padding: null,
                            decoration: BoxDecoration(
                              borderRadius: BorderRadius.circular(10),
                              color: ColorsConstants.instance
                                  .backgroundColor, //açılır menü arkaplan rengi
                            ),
                            elevation: 8,
                            offset: const Offset(0, 0),
                            scrollbarTheme: ScrollbarThemeData(
                              thumbColor: MaterialStateColor.resolveWith(
                                  (states) => ColorsConstants.instance
                                      .baseTheme), //dropdown scroll rengi değiştirme
                              radius: const Radius.circular(10),
                              thickness: MaterialStateProperty.all<double>(6),
                              thumbVisibility:
                                  MaterialStateProperty.all<bool>(true),
                            ),
                          ),
                          menuItemStyleData: const MenuItemStyleData(
                            height: 35,
                            padding: EdgeInsets.symmetric(horizontal: 14),
                          ),
                        ),
                      ),
                    ),
                    const SizedBox(height: 8),
                    Row(
                      mainAxisAlignment: MainAxisAlignment.start,
                      children: [
                        const SizedBox(width: 5),
                        Container(
                          height: context.dynamicWidth(0.042),
                          width: context.dynamicWidth(0.042),
                          decoration: BoxDecoration(
                            borderRadius: BorderRadius.circular(7),
                            color: Colors.grey.withOpacity(0.5),
                          ),
                          child: const Icon(
                            Icons.message_outlined,
                            size: 13,
                            color: Colors.black26,
                          ),
                        ),
                        const SizedBox(width: 10),
                        Text(
                          'Açıklama',
                          style: FontStyles.instance.ddBaslik,
                        ),
                      ],
                    ),
                    const SizedBox(height: 8),
                    StringTextField(
                      textEditingController: textcAciklama,
                      aciklama: 'Lütfen açıklama giriniz..',
                      kenarlik: false,
                      satirSayisi: 4,
                      yukseklik: context.dynamicHeight(0.13),
                      arkaplanRengi: Colors.white,
                      golge: true,
                      tekSatirMi: false,
                      kisitlama: 140,
                    ),
                    const SizedBox(height: 8),
                    Padding(
                      padding: const EdgeInsets.symmetric(vertical: 8.0),
                      child: Row(
                        mainAxisAlignment: MainAxisAlignment.center,
                        children: [
                          Container(
                            height: context.dynamicHeight(0.05),
                            decoration: BoxDecoration(
                                color: ColorsConstants.instance.baseTheme,
                                borderRadius: BorderRadius.circular(10),
                                boxShadow: [
                                  BoxShadow(
                                    color: Colors.grey.withOpacity(0.4),
                                    blurRadius: 8,
                                    offset: const Offset(1, 1),
                                  )
                                ]),
                            child: BlocConsumer<ActivityCubit, ActivityState>(
                              listener: (context, state) {
                                if (!state.isLoading & state.isComplete &&
                                    !state.isCorrect) {
                                  ToastManager.instance
                                      .toastMessageService("Aktivite Eklendi")
                                      .then((value) => Navigator.pop(context));
                                } else if (!state.isLoading &
                                        state.isComplete &&
                                    state.isCorrect) {
                                  ToastManager.instance
                                      .toastMessageService(
                                          "Aktivite Eklenemedi")
                                      .then((value) => Navigator.pop(context));
                                }
                              },
                              builder: (context, state) => TextButton(
                                  onPressed: yetkiliListesiBosMu == false
                                      ? () {
                                          if (gonderilenfirmaID.isNotEmpty &&
                                              gonderilenYetkiliID.isNotEmpty &&
                                              gonderilenCalisanID.isNotEmpty &&
                                              dbSaat.isNotEmpty &&
                                              secilenGorusme != '' &&
                                              textcAciklama.text.isNotEmpty &&
                                              context
                                                  .read<CustomersCubit>()
                                                  .secilenGorusmeTipi
                                                  .isNotEmpty) {
                                            context.read<ActivityCubit>().aktiviteEkle(
                                                NewActivityModel(
                                                    token: context
                                                        .read<LoginCubit>()
                                                        .token,
                                                    gorusmeUserFirmId: context
                                                        .read<LoginCubit>()
                                                        .userfirmId,
                                                    loginuserid: context
                                                        .read<LoginCubit>()
                                                        .id,
                                                    gorusmeUserId:
                                                        ',$gonderilenCalisanID,',
                                                    gorusmeFirmaId:
                                                        gonderilenfirmaID,
                                                    gorusmeYetkiliId:
                                                        gonderilenYetkiliID,
                                                    gorusmeBaslik:
                                                        textcAktiviteBaslik
                                                            .text,
                                                    gorusmeNot:
                                                        textcAciklama.text,
                                                    gorusmeTip: secilenGorusme !=
                                                            null
                                                        ? secilenGorusme!
                                                        : context
                                                            .read<
                                                                CustomersCubit>()
                                                            .secilenGorusmeTipi,
                                                    gorusmeTarihi: dbSaat),
                                                context.read<LoginCubit>().tip,
                                                context
                                                    .read<LoginCubit>()
                                                    .userfirmId);
                                          } else {
                                            _snackBarMessage(
                                                'Eksik Alanlar Var !');
                                          }
                                        }
                                      : () {
                                          _snackBarMessage(
                                              'Eksik Alanlar Var !');
                                        },
                                  style: TextButton.styleFrom(
                                      backgroundColor: Colors.transparent,
                                      shape: RoundedRectangleBorder(
                                        borderRadius: BorderRadius.circular(10),
                                      )),
                                  child: Padding(
                                    padding: const EdgeInsets.symmetric(
                                        horizontal: 10.0),
                                    child: Text(
                                      ApplicationConstants
                                          .instance.moduleSaveTxt,
                                      style:
                                          const TextStyle(color: Colors.white),
                                    ),
                                  )),
                            ),
                          )
                        ],
                      ),
                    ),
                  ],
                ),
              )
            : Container(
                alignment: Alignment.center,
                height: context.dynamicHeight(1),
                width: context.dynamicWidth(1),
                child: const CircularProgressIndicator(),
              ),
      ),
    );
  }

  void _snackBarMessage(String msg) {
    ScaffoldMessenger.of(context).showSnackBar(
      SnackBar(
        backgroundColor: ColorsConstants.instance.baseTheme,
        content: Text(
          msg,
        ),
        behavior: SnackBarBehavior.floating,
        action: SnackBarAction(
          label: "Tamam",
          textColor: Colors.white,
          onPressed: () {},
        ),
      ),
    );
  }

  dateTimePickerWidget(BuildContext context) {
    return DatePicker.showDatePicker(
      context,
      dateFormat: 'dd/MM/yyyy',
      locale: DateTimePickerLocale.tr,
      initialDateTime: DateTime.now(),
      minDateTime: DateTime(2005),
      maxDateTime: DateTime(2100),
      pickerTheme: DateTimePickerTheme(
        backgroundColor: ColorsConstants.instance.backgroundColor,
        confirm: saatSecildi
            ? Text(
                'Değiştir',
                style: TextStyle(color: ColorsConstants.instance.baseTheme),
              )
            : Text(
                'Yeni Tarih Seç',
                style: TextStyle(color: ColorsConstants.instance.baseTheme),
              ),
      ),
      onMonthChangeStartWithFirstDate: true,
      onConfirm: (dateTime, List<int> index) {
        DateTime selectdate = dateTime;
        final selIOS = DateFormat('yyyy-MM-dd HH:mm').format(selectdate);
        setState(() {
          dbSaat = '$selIOS:00';
          dbSaat == '' ? saatSecildi = false : saatSecildi = true;
          gosterilenSaat = dbSaat.substring(0, 16);
          final DateFormat format = DateFormat.yMd('tr');
          var trTarih = format.format(DateTime.parse(gosterilenSaat));
          gosterilenSaat = trTarih;
          dbSaat.log();
          gosterilenSaat.log();
        });
      },
    );
  }
}

Widget _inActiveDD(BuildContext context) {
  return Container(
    height: context.dynamicHeight(0.054),
    width: context.dynamicWidth(0.9),
    padding: const EdgeInsets.symmetric(horizontal: 10),
    decoration: BoxDecoration(
        borderRadius: BorderRadius.circular(10),
        color: Colors.white,
        boxShadow: [
          BoxShadow(
              color: Colors.grey.withOpacity(0.3),
              offset: const Offset(0.4, 0.3),
              blurRadius: 7)
        ]),
  );
}
