import 'package:flutter/material.dart';
import 'package:flutter_bloc/flutter_bloc.dart';
import 'package:google_fonts/google_fonts.dart';
import 'package:hamlemuhcrm/core/constants/font_styles.dart';
import 'package:hamlemuhcrm/core/extensions/responsive_extension.dart';
import 'package:hamlemuhcrm/features/auth/login/cubit/login_cubit.dart';
import 'package:hamlemuhcrm/features/customers/cubit/activity_cubit.dart';
import 'package:hamlemuhcrm/features/customers/cubit/activity_state.dart';
import 'package:hamlemuhcrm/features/customers/cubit/customers_cubit.dart';
import 'package:hamlemuhcrm/features/customers/model/firmalar.dart';
import 'package:hamlemuhcrm/features/customers/view/activities/activity_update.dart';
import 'package:hamlemuhcrm/features/customers/view/activities/create_activity_parametry.dart';
import 'package:hamlemuhcrm/features/customers/view/activities/mixin/shared_activity_mixin.dart';

import '../../../../core/constants/color_constants.dart';
import '../../../../core/route/page_route.dart';
import 'mixin/company_activity_mixin.dart';

class CompanyActivityPage extends StatefulWidget {
  final Firmalar firma;
  const CompanyActivityPage({super.key, required this.firma});

  @override
  State<CompanyActivityPage> createState() => _CompanyActivityPageState();
}

class _CompanyActivityPageState extends State<CompanyActivityPage>
    with CompanyActivityMixin, SharedActivityMixin {
  @override
  Widget build(BuildContext context) {
    return isFinish
        ? Scaffold(
            appBar: AppBar(
              backgroundColor: Colors.transparent,
              elevation: 0,
              title: Text(widget.firma.firmaIsim,
                  style: GoogleFonts.inter(
                      color: Colors.black,
                      fontWeight: FontWeight.w400,
                      fontSize: 16)),
              centerTitle: true,
              actions: [
                IconButton(
                    onPressed: () {},
                    icon: const Icon(
                      Icons.notifications_none_outlined,
                      color: Colors.black,
                    )),
              ],
              leading: IconButton(
                onPressed: () {
                  Navigator.popUntil(context, (route) => route.isFirst);
                },
                icon: const Icon(
                  Icons.arrow_back_ios_new,
                  color: Colors.black87,
                ),
              ),
            ),
            body: Padding(
              padding:
                  EdgeInsets.symmetric(horizontal: context.dynamicWidth(0.05)),
              child: Column(
                children: [
                  Container(
                    height: context.dynamicHeight(0.2),
                    decoration: BoxDecoration(
                      color: Colors.white,
                      borderRadius: BorderRadius.circular(15),
                      boxShadow: [
                        BoxShadow(
                          color: Colors.grey.withOpacity(0.3),
                          offset: const Offset(1, 3),
                          blurRadius: 5,
                        ),
                      ],
                    ),
                    child: Padding(
                      padding: EdgeInsets.symmetric(
                          horizontal: context.dynamicWidth(0.03)),
                      child: Column(
                        mainAxisAlignment: MainAxisAlignment.spaceEvenly,
                        children: [
                          Container(
                            height: context.dynamicHeight(0.0564),
                            decoration: BoxDecoration(
                                borderRadius: BorderRadius.circular(8),
                                color: ColorsConstants.instance.backgroundColor,
                                border: Border.all(
                                    color: Colors.grey.withOpacity(0.3))),
                            child: Row(
                              children: [
                                Flexible(
                                  flex: 2,
                                  child: TextFormField(
                                    controller: tfFirmaAktiviteAra,
                                    onChanged: (aramasonucu) {
                                      context
                                          .read<ActivityCubit>()
                                          .firmaktiviteleriAra(aramasonucu);
                                    },
                                    textAlign: TextAlign.left,
                                    style: const TextStyle(
                                        color: Colors.grey, fontSize: 16.0),
                                    decoration: InputDecoration(
                                        focusedBorder: const OutlineInputBorder(
                                            borderSide: BorderSide.none),
                                        border: const OutlineInputBorder(
                                            borderSide: BorderSide.none),
                                        prefixIcon: Icon(
                                          Icons.search,
                                          color: Colors.grey,
                                          size: context.dynamicWidth(0.062),
                                        ),
                                        hintText: 'Arama',
                                        hintStyle: const TextStyle(
                                            fontSize: 15.0,
                                            color: Colors.grey)),
                                  ),
                                ),
                              ],
                            ),
                          ),
                          Row(
                            children: [
                              Expanded(
                                flex: 1,
                                child: Material(
                                  color: Colors.transparent,
                                  child: InkWell(
                                      highlightColor: Colors.grey.shade50,
                                      onTap: () {
                                        aktiviteArsivMi = !aktiviteArsivMi;
                                        if (aktiviteArsivMi == true) {
                                          context
                                              .read<ActivityCubit>()
                                              .firmaArsivAktiviteleriListele(
                                                  widget.firma.firmaId,
                                                  context
                                                      .read<LoginCubit>()
                                                      .token,
                                                  context.read<LoginCubit>().id,
                                                  context
                                                      .read<LoginCubit>()
                                                      .userfirmId,
                                                  context
                                                      .read<LoginCubit>()
                                                      .tip);
                                        }
                                        if (aktiviteArsivMi == false) {
                                          context
                                              .read<ActivityCubit>()
                                              .firmaAktiviteleriListele(
                                                  widget.firma.firmaId,
                                                  context
                                                      .read<LoginCubit>()
                                                      .token,
                                                  context.read<LoginCubit>().id,
                                                  context
                                                      .read<LoginCubit>()
                                                      .userfirmId,
                                                  context
                                                      .read<LoginCubit>()
                                                      .tip,
                                                  1);
                                        }
                                      },
                                      splashColor: Colors.grey.shade200,
                                      borderRadius: BorderRadius.circular(15),
                                      child: _widthButton('Arşivler',
                                          Colors.red, Icons.archive_outlined)),
                                ),
                              ),
                              const SizedBox(width: 10),
                              Expanded(
                                flex: 1,
                                child: Material(
                                  color: Colors.transparent,
                                  child: InkWell(
                                      onTap: () {
                                        Navigator.push(
                                            context,
                                            CustomPageRoute(
                                                child: CreateActivityParametry(
                                                    firmaAd:
                                                        widget.firma.firmaIsim,
                                                    firmaID:
                                                        widget.firma.firmaId)));
                                      },
                                      splashColor: Colors.grey.shade200,
                                      borderRadius: BorderRadius.circular(15),
                                      child: _widthButton(
                                          'Aktivite Oluştur',
                                          Colors.blue,
                                          Icons.add_chart_outlined)),
                                ),
                              ),
                            ],
                          ),
                        ],
                      ),
                    ),
                  ),
                  const SizedBox(height: 15),
                  Expanded(
                    child: BlocBuilder<ActivityCubit, ActivityState>(
                        builder: (context, state) {
                      aktiviteYok = state.aktiviteler.isEmpty;
                      if (state.aktiviteler.isNotEmpty) {
                        return ListView.builder(
                            itemCount: state.aktiviteler.length,
                            itemBuilder: (context, indeks) {
                              var aktivite = state.aktiviteler[indeks];
                              bool arsiv;
                              arsiv = aktivite.gorusmeOnay == '0';
                              ///////////////////////////////////////////////////////////////
                              String id = "";
                              aktivite.gorusmeUserIdler! == ',' ||
                                      aktivite.gorusmeUserIdler! == ',,'
                                  ? id = ',14,'
                                  : id = aktivite.gorusmeUserIdler!;
                              List<String> ilksayiyiAl =
                                  id.substring(1).split(',');
                              String atanacakSayi = ilksayiyiAl[0];

                              return InkWell(
                                  onTap: () {
                                    context
                                            .read<CustomersCubit>()
                                            .secilenGorusmeTipi =
                                        aktivite.gorusmeTip!;
                                    Navigator.push(
                                        context,
                                        MaterialPageRoute(
                                            builder: (context) =>
                                                ActivityUpdate(
                                                    arsivMi:
                                                        aktivite.gorusmeOnay ==
                                                            "0",
                                                    gorusmeID:
                                                        aktivite.gorusmeId!,
                                                    firmaAd:
                                                        widget.firma.firmaIsim,
                                                    firmaID:
                                                        widget.firma.firmaId,
                                                    gorusmeBaslik:
                                                        aktivite.gorusmeBaslik!,
                                                    yetkiliID: aktivite
                                                        .gorusmeYetkiliId!,
                                                    katilanPersonelID:
                                                        atanacakSayi,
                                                    tarih:
                                                        aktivite.gorusmeTarihi!,
                                                    gorusmeTuru:
                                                        aktivite.gorusmeTip!,
                                                    aciklama:
                                                        aktivite.gorusmeNot!)));
                                  },
                                  child: Container(
                                    margin:
                                        const EdgeInsets.symmetric(vertical: 5),
                                    decoration: BoxDecoration(
                                        borderRadius: BorderRadius.circular(5),
                                        color: Colors.white,
                                        boxShadow: [
                                          BoxShadow(
                                              color:
                                                  Colors.grey.withOpacity(0.5),
                                              offset: const Offset(0.4, 0.5),
                                              blurRadius: 7)
                                        ]),
                                    child: Row(
                                      children: [
                                        Container(
                                          width: 10,
                                          height: context.dynamicHeight(0.092),
                                          decoration: BoxDecoration(
                                            borderRadius:
                                                const BorderRadius.only(
                                                    topLeft: Radius.circular(5),
                                                    bottomLeft:
                                                        Radius.circular(5)),
                                            color: arsiv
                                                ? Colors.red.withOpacity(0.2)
                                                : Colors.blue.withOpacity(0.2),
                                          ),
                                        ),
                                        Row(
                                          children: [
                                            const SizedBox(width: 20),
                                            const Icon(Icons.task_alt_outlined),
                                            const SizedBox(width: 10),
                                            Text(
                                                aktivite.gorusmeBaslik!.length >
                                                        21
                                                    ? aktivite.gorusmeBaslik!
                                                        .substring(0, 19)
                                                    : aktivite.gorusmeBaslik!,
                                                style: FontStyles
                                                    .instance.ortaYazi),
                                          ],
                                        ),
                                        const Spacer(),
                                        aktiviteArsivMi || arsiv
                                            ? Container(
                                                height: 35,
                                                width: 35,
                                                decoration: BoxDecoration(
                                                    color: Colors.red
                                                        .withOpacity(0.2),
                                                    borderRadius:
                                                        BorderRadius.circular(
                                                            10)),
                                                child: IconButton(
                                                  tooltip: 'Arşivden Çıkar',
                                                  onPressed: () {
                                                    ScaffoldMessenger.of(
                                                            context)
                                                        .showSnackBar(
                                                      SnackBar(
                                                        backgroundColor:
                                                            ColorsConstants
                                                                .instance
                                                                .baseTheme,
                                                        content: const Text(
                                                          "Arşivden Çıkarılsın Mı?",
                                                        ),
                                                        action: SnackBarAction(
                                                          label: "Evet",
                                                          backgroundColor:
                                                              ColorsConstants
                                                                  .instance
                                                                  .baseTheme,
                                                          textColor:
                                                              Colors.white,
                                                          onPressed: () {
                                                            context.read<ActivityCubit>().aktiviteArsivdenCikar(
                                                                aktivite
                                                                    .gorusmeId!,
                                                                context
                                                                    .read<
                                                                        LoginCubit>()
                                                                    .id,
                                                                context
                                                                    .read<
                                                                        LoginCubit>()
                                                                    .token,
                                                                context
                                                                    .read<
                                                                        LoginCubit>()
                                                                    .tip,
                                                                context
                                                                    .read<
                                                                        LoginCubit>()
                                                                    .userfirmId);
                                                            Future.delayed(
                                                                const Duration(
                                                                    seconds: 1),
                                                                () {
                                                              aktiviteArsivMi =
                                                                  false;
                                                              context.read<ActivityCubit>().firmaAktiviteleriListele(
                                                                  widget.firma
                                                                      .firmaId,
                                                                  context
                                                                      .read<
                                                                          LoginCubit>()
                                                                      .token,
                                                                  context
                                                                      .read<
                                                                          LoginCubit>()
                                                                      .id,
                                                                  context
                                                                      .read<
                                                                          LoginCubit>()
                                                                      .userfirmId,
                                                                  context
                                                                      .read<
                                                                          LoginCubit>()
                                                                      .tip,
                                                                  1);
                                                            });
                                                          },
                                                        ),
                                                      ),
                                                    );
                                                  },
                                                  icon: const Icon(
                                                      Icons.send_and_archive,
                                                      color: Colors.red,
                                                      size: 17),
                                                ))
                                            : Container(
                                                height: 35,
                                                width: 35,
                                                decoration: BoxDecoration(
                                                    color: Colors.blue
                                                        .withOpacity(0.2),
                                                    borderRadius:
                                                        BorderRadius.circular(
                                                            10)),
                                                child: Icon(
                                                  Icons.arrow_forward_ios_sharp,
                                                  color: Colors.blue
                                                      .withOpacity(0.5),
                                                  size: 17,
                                                ),
                                              ),
                                        const SizedBox(width: 15),
                                      ],
                                    ),
                                  ));
                            });
                      } else {
                        return Center(
                          child: SizedBox(
                            height: context.dynamicHeight(0.3),
                            width: context.dynamicWidth(0.9),
                            child: const Column(
                              mainAxisAlignment: MainAxisAlignment.center,
                              children: [
                                Text(
                                  'Aktivite Bulunamadı',
                                  style: TextStyle(fontSize: 18),
                                ),
                                SizedBox(height: 25),
                                Icon(Icons.search_off_rounded, size: 50),
                              ],
                            ),
                          ),
                        );
                      }
                    }),
                  ),
                ],
              ),
            ),
          )
        : const Scaffold();
  }

  Widget _widthButton(String text, Color renk, IconData iconData) {
    return Container(
      height: context.dynamicHeight(0.091),
      width: context.dynamicWidth(0.258),
      decoration: BoxDecoration(
        color: renk.withOpacity(0.24),
        border: Border.all(color: Colors.grey.withOpacity(0.3)),
        borderRadius: BorderRadius.circular(15),
      ),
      child: Column(
        mainAxisAlignment: MainAxisAlignment.spaceEvenly,
        children: [
          Icon(iconData, color: renk),
          Text(
            text,
            style: const TextStyle(fontSize: 13, color: Colors.black38),
          ),
        ],
      ),
    );
  }
}
