import 'package:flutter/material.dart';
import 'package:flutter_bloc/flutter_bloc.dart';
import 'package:hamlemuhcrm/core/extensions/log_extension.dart';
import 'package:hamlemuhcrm/core/extensions/string_extension.dart';
import 'package:hamlemuhcrm/features/calendar/view/calendar_detail_one_view.dart';
import '../../../core/cubits/dropdown_cubit.dart';
import '../../../core/utility/toast_manager.dart';
import '../../customers/cubit/customers_cubit.dart';
import '../cubit/calendar_cubit.dart';

import 'package:hamlemuhcrm/features/calendar/view/calendar_detail_second_view.dart';

mixin CalendarDetailOneViewMixin on State<CalendarDetailOneView> {
  static final GlobalKey<FormState> updateMeetKey = GlobalKey();

  /////////////////////////////////////////////////////////////////////////////

  final TextEditingController tfToplantiAd = TextEditingController();
  final TextEditingController tfToplantiGundem = TextEditingController();
  final TextEditingController tfToplantiSure = TextEditingController();
  final TextEditingController tfToplantiYeri = TextEditingController();
  final TextEditingController tfToplantiAciklama = TextEditingController();
  late DropdownCubit cubit = DropdownCubit();

  /////////////////////////////////////////////////////////////////////////////
  bool isLoading = true;
  bool saatSecildi = false;
  String dbSaat = '';
  String gosterilenSaat = '';

  void changeLoading() {
    setState(() {
      isLoading = !isLoading;
    });
  }

  @override
  void initState() {
    "calendar detail_one_view_mixin initState çalıştı".log();
    cubit = DropdownCubit();
    setData();
    Future.microtask(() {
      Future.delayed(const Duration(milliseconds: 900)).whenComplete(() {
        changeLoading();
        context
            .read<DropdownCubit>()
            .updateMeetSetInitialSelectedEmployess(widget.calendarModel);
      });
    });
    super.initState();
  }

  @override
  void didChangeDependencies() {
    super.didChangeDependencies();
  }

  void setData() {
    //textfields
    tfToplantiAd.text = widget.calendarModel.toplantiBaslik ?? '';
    tfToplantiGundem.text = widget.calendarModel.toplantiGundem ?? '';
    tfToplantiSure.text = widget.calendarModel.toplantiSuresi ?? '';
    tfToplantiYeri.text = widget.calendarModel.toplantiYeri ?? '';
    tfToplantiAciklama.text = widget.calendarModel.toplantiNot ?? '';

    /// dbSaat
    dbSaat = widget.calendarModel.toplantiTarihi ?? '';
    gosterilenSaat =
        ''.toTrTypeNoHour(widget.calendarModel.toplantiTarihi ?? '');

    /// toplanti-tipi - toplanti-tekrari
    context.read<CustomersCubit>().secilenGorusmeTipi =
        widget.calendarModel.toplantiTip ?? '';
    context.read<CalendarCubit>().secilenToplantiTekrarTipi =
        widget.calendarModel.toplantiTekrarlama ?? '';
    // toplantiProjeId - toplantiProjeFirmaId - toplantiYoneticiId
    context.read<CalendarCubit>().secilenProjeID =
        widget.calendarModel.toplantiProjeId ?? '';
    context.read<CalendarCubit>().secilenProjeFirmaID =
        widget.calendarModel.toplantiFirmaId ?? '';
    context.read<CalendarCubit>().secilenToplantiYoneticiID =
        widget.calendarModel.toplantiYoneticiId ?? '';
  }

  String toplantiAdiKucult(String gelenToplanti) => gelenToplanti.length > 34
      ? '${gelenToplanti.substring(0, 33)}..'
      : gelenToplanti;

  Future<void> nextToPage() async {
    if (context.read<CalendarCubit>().secilenProjeFirmaID.isNotEmpty &&
        context.read<CalendarCubit>().secilenProjeID.isNotEmpty &&
        context.read<CustomersCubit>().secilenGorusmeTipi.isNotEmpty &&
        context.read<CalendarCubit>().secilenToplantiYoneticiID.isNotEmpty &&
        dbSaat.isNotEmpty &&
        tfToplantiAd.text.isNotEmpty &&
        tfToplantiGundem.text.isNotEmpty &&
        tfToplantiSure.text.isNotEmpty &&
        tfToplantiYeri.text.isNotEmpty &&
        tfToplantiAciklama.text.isNotEmpty) {
      if (widget.calendarModel.toplantiFirmaId !=
          context.read<CalendarCubit>().secilenProjeFirmaID) {
        //context.read<DropdownCubit>().secimleriTemizle();
      }
      Navigator.of(context).pushReplacement(MaterialPageRoute(
          builder: (context) => CalendarDetailSecondView(
                cubit: widget.cubit,
                toplantiAd: toplantiAdiKucult(
                    widget.calendarModel.toplantiBaslik ?? ''),
                tfBaslik: tfToplantiAd.text,
                tfGundem: tfToplantiGundem.text,
                tfToplantiYeri: tfToplantiYeri.text,
                toplantiYoneticiId:
                    context.read<CalendarCubit>().secilenToplantiYoneticiID,
                tfToplantiAciklama: tfToplantiAciklama.text,
                alinanSure: tfToplantiSure.text,
                alinanTarih: dbSaat,
                toplantiID: widget.calendarModel.toplantiId ?? "",
                projeFirmaId: context.read<CalendarCubit>().secilenProjeFirmaID,
                projeid: context.read<CalendarCubit>().secilenProjeID,
                pgonderilecekUserIdler:
                    widget.calendarModel.toplantiUserIdler ?? ',',
                pgonderilecekYetkiliIdler:
                    widget.calendarModel.toplantiYetkiliIdler ?? ',',
              )));
      return;
    }
    ToastManager.instance.toastMessageService('Gerekli Alanlar Eksik');
  }

  @override
  void dispose() {
    super.dispose();
    tfToplantiAd.dispose();
    tfToplantiGundem.dispose();
    tfToplantiSure.dispose();
    tfToplantiYeri.dispose();
    tfToplantiAciklama.dispose();
  }
}
