part of 'login_cubit.dart';

// Cubit durumunu temsil eden sınıf
class LoginState extends Equatable {
  final bool isLoading;
  final bool isLoggedIn;
  final bool isFieldEmpty;
  final bool isCorrect;
  final bool isError;
  final bool isComplete;

  const LoginState({
    required this.isLoading,
    required this.isLoggedIn,
    required this.isFieldEmpty,
    required this.isCorrect,
    required this.isError,
    required this.isComplete,
  });

  factory LoginState.initial() {
    return const LoginState(
      isLoading: false,
      isLoggedIn: false,
      isFieldEmpty: false,
      isCorrect: false,
      isError: false,
      isComplete: false,
    );
  }

  LoginState copyWith({
    bool? isLoading,
    bool? isLoggedIn,
    bool? isFieldEmpty,
    bool? isCorrect,
    bool? isError,
    bool? isComplete,
  }) {
    return LoginState(
      isLoading: isLoading ?? this.isLoading,
      isLoggedIn: isLoggedIn ?? this.isLoggedIn,
      isFieldEmpty: isFieldEmpty ?? this.isFieldEmpty,
      isCorrect: isCorrect ?? this.isCorrect,
      isError: isError ?? this.isError,
      isComplete: isComplete ?? this.isComplete,
    );
  }

  @override
  List<Object?> get props =>
      [isLoading, isLoggedIn, isFieldEmpty, isCorrect, isError, isComplete];
}
