import 'package:dio/dio.dart';
import 'package:hamlemuhcrm/core/constants/url_services_constant.dart';
import 'package:hamlemuhcrm/core/extensions/log_extension.dart';
import 'package:hamlemuhcrm/features/auth/login/model/get_profile.dart';
import 'package:hamlemuhcrm/features/auth/login/model/login_response.dart';
import 'package:hamlemuhcrm/features/auth/login/model/token_control.dart';

class LoginRepository {
  final Dio dio = Dio();

  //BÜTÜN METOTLAR GÜNCELLENDİ token,loginuserid eklendi.....

  /////////////////////////////////// LOGİN & TOKEN  ////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

  Future<LoginResponseModel?> loginOlRepo(String eposta, String sifre) async {
    /*guncel token,loginid eklendi*/
    var url = URLAPIService.instance.girisYapURL;
    var veri = {"email": eposta, "password": sifre};
    try {
      var cevap = await dio.post(url, data: FormData.fromMap(veri));
      if (cevap.statusCode == 200) {
        return LoginResponseModel.fromJson(cevap.data);
      } else if (cevap.statusCode == 400) {
        return LoginResponseModel.fromJson(cevap.data);
      } else {
        throw Exception('Giris basarisiz');
      }
    } catch (e) {
      throw Exception('Giriş Başarısız 2 : $e');
    }
  }

  Future<TokenResponseModel?> tokenKontrolRepo(
      String token, String loginuserid) async {
    /*guncel token,loginid eklendi*/
    var url = URLAPIService.instance.tokenKontrolURL;
    var veri = {"token": token, "loginuserid": loginuserid};
    try {
      var cevap = await dio.post(url, data: FormData.fromMap(veri));
      if (cevap.statusCode == 200) {
        'Token Kontrol : ${cevap.data}'.log();
        return TokenResponseModel.fromJson(cevap.data);
      } else {
        throw Exception('Token Başarısız 1');
      }
    } catch (e) {
      throw Exception('Token Başarısız 2 : $e');
    }
  }

  Future<GetProfileModel?> profilGetir(String token, String loginuserid) async {
    /*guncel token,loginid eklendi*/
    var url = URLAPIService.instance.profilgetirURL;
    var veri = {"token": token, "loginuserid": loginuserid};
    try {
      var cevap = await dio.post(url, data: FormData.fromMap(veri));
      if (cevap.statusCode == 200) {
        return GetProfileModel.fromJson(cevap.data);
      } else {
        throw Exception("Hata oluştu");
      }
    } catch (e) {
      throw Exception("Hata Bad Request");
    }
  }
}
