import 'dart:convert';

import 'package:dio/dio.dart';

import 'package:hamlemuhcrm/core/extensions/log_extension.dart';
import 'package:hamlemuhcrm/core/init/network/network_manager.dart';
import 'package:hamlemuhcrm/features/home/model/istatistik.dart';
import 'package:hamlemuhcrm/core/constants/url_services_constant.dart';
import 'package:hamlemuhcrm/features/profile/model/profile_permission.dart';
import 'package:hamlemuhcrm/features/projects/model/project_count_model.dart';

class HomeRepository {
  final Dio dio = NetworkManager.instance.dio;

  //BÜTÜN METOTLAR GÜNCELLENDİ token,loginuserid eklendi.....

  /////////////////////////////////// İSTATİSTİKLER ////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

  Future<MusteriSayi> musteriSayisi(
      String firmaEkleyenUserId,
      String kayitliFirma,
      String userTip,
      String token,
      String loginuserid) async {
    /*guncel token,loginid eklendi*/
    var url = URLAPIService.instance.musteriSayisiURL;
    var veri = {
      "firma_ekleyen_user_id": firmaEkleyenUserId,
      "firma_firmuser_id": kayitliFirma,
      "user_tip": userTip,
      "token": token,
      "loginuserid": loginuserid,
    };

    try {
      var cevap = await dio.post(url, data: FormData.fromMap(veri));
      'musteri sayisi : ${cevap.data.toString()}'.log();
      return MusteriSayi.fromJson(json.decode(cevap.data));
    } catch (e) {
      throw Exception('HTTP Başarısız : $e');
    }
  }

  Future<PersonelSayi> personelSayisi(String userUserfirmId, String userTip,
      String token, String loginuserid) async {
    /*guncel token,loginid eklendi*/
    var url = URLAPIService.instance.personelSayisiURL;
    var veri = {
      "user_userfirm_id": userUserfirmId,
      "user_tip": userTip,
      "token": token,
      "loginuserid": loginuserid
    };
    try {
      var cevap = await dio.post(url, data: FormData.fromMap(veri));
      'personel sayisi : ${cevap.data.toString()}'.log();
      return PersonelSayi.fromJson(json.decode(cevap.data));
    } catch (e) {
      throw Exception('HTTP başarısız : $e');
    }
  }

  Future<ProjectCountModel> projeSayisi(
      String token, String loginuserid) async {
    var url = URLAPIService.instance.projeSayilarURL;
    var veri = {"token": token, "loginuserid": loginuserid};

    try {
      var cevap = await dio.post(url, data: FormData.fromMap(veri));
      if (cevap.statusCode == 200) {
        // Cevabı JSON dizesi olarak al
        String cevapJson = cevap.data;
        // JSON dizesini ayrıştır ve kullan
        Map<String, dynamic> responseData = json.decode(cevapJson);
        'projeler sayi : $cevapJson'.log();
        return ProjectCountModel.fromJson(responseData);
      } else {
        throw Exception('HTTP isteği başarısız oldu: ${cevap.statusCode}');
      }
    } catch (e) {
      "Hata oluştu: $e".log();
      throw Exception('Hata var: $e');
    }
  }

  Future<List<ProfilePermission>>? profilePermissonList(
      String loginuserid, String token) async {
    try {
      var url = URLAPIService.instance.profilIzinleriListeleURL;
      var veri = {'token': token, 'loginuserid': loginuserid};
      var response = await dio.post(url, data: FormData.fromMap(veri));
      if (response.statusCode == 200) {
        final Map<String, dynamic> responseMap = response.data is String
            ? json.decode(response.data)
            : response.data;
        final List<ProfilePermission> permissionList =
            List.from(responseMap['izin_almalar'])
                .map((item) => ProfilePermission.fromJson(item))
                .toList();
        return permissionList;
      } else {
        return [];
      }
    } catch (e) {
      return [];
    }
  }

  Future<void> viewUpdateUserPermission(
      String token, String loginuserid, String izinId) async {
    var url = URLAPIService.instance.profilIzinGoruntulemeURL;
    var veri = {'token': token, 'loginuserid': loginuserid, 'izin_id': izinId};
    var response = await dio.post(url, data: FormData.fromMap(veri));
    '${response.data}'.log();
  }
}
