import 'package:flutter/material.dart';
import 'package:hamlemuhcrm/core/extensions/responsive_extension.dart';

import '../constants/color_constants.dart';

class BottomSheetUpIndicator extends StatelessWidget {
  const BottomSheetUpIndicator({super.key});

  @override
  Widget build(BuildContext context) {
    EdgeInsets indicatorTopMarginSize(BuildContext context) =>
        EdgeInsets.only(top: context.dynamicHeight(.009));

    double indicatorContainerHeight(BuildContext context) =>
        context.dynamicHeight(.007);

    double indicatorContainerWidth(BuildContext context) =>
        context.dynamicWidth(.22);

    return Container(
      margin: indicatorTopMarginSize(context),
      height: indicatorContainerHeight(context),
      width: indicatorContainerWidth(context),
      alignment: Alignment.center,
      decoration: BoxDecoration(
          color: ColorsConstants.instance.appGrey,
          borderRadius: BorderRadius.circular(10)),
    );
  }
}
