import 'package:fluttertoast/fluttertoast.dart';

import '../constants/color_constants.dart';

class ToastManager {
  static ToastManager? _instance;
  static ToastManager get instance {
    _instance ??= ToastManager._init();
    return _instance!;
  }

  ToastManager._init();

  Future<void> toastMessageService(String msg) async {
    Fluttertoast.showToast(
      msg: msg,
      backgroundColor: ColorsConstants.instance.baseTheme,
      gravity: ToastGravity.CENTER,
      fontSize: 14,
    );
  }
}
