import 'package:equatable/equatable.dart';

import '../../data/repo/notification_repository.dart';
import '../../features/home/cubit/home_custom_cubit.dart';
import '../../features/notification/model/notification.dart';
import '../base/base_cubit.dart';

part 'notification_state.dart';

final class NotificationCubit extends BaseCubit<NotificationState> {
  late final HomeCustomCubit homeCubit;
  late final NotificationRepository repo;
  NotificationCubit() : super(NotificationState.initial()) {
    repo = NotificationRepository();
  }

  //bildirimlerin listesini servisten getirme
  Future<void> fetchNotifications(
      String bildirimUserFirmId, String loginuserid, String token) async {
    safeEmit(state.copyWith(
      isLoading: true,
      isComplete: false,
      isError: false,
      unViewedNotification: <NotificationModel>[],
      viewedNotification: <NotificationModel>[],
    ));
    final response =
        await repo.fetchNotifications(loginuserid, bildirimUserFirmId, token);

    if (response == null) {
      return safeEmit(state.copyWith(
        isError: true,
        isLoading: false,
        isComplete: false,
        unViewedNotification: <NotificationModel>[],
        viewedNotification: <NotificationModel>[],
      ));
    }

    List<NotificationModel> goruntulenmemisBildirimListesi = response
        .bildirimler!
        .where((element) => element.bildirimDurumu == "0")
        .toList();

    List<NotificationModel> goruntulenmisBildirimListesi = response.bildirimler!
        .where((element) => element.bildirimDurumu == "1")
        .toList();

    if (goruntulenmemisBildirimListesi.isNotEmpty &&
        goruntulenmisBildirimListesi.isNotEmpty) {
      goruntulenmemisBildirimListesi
          .sort((a, b) => b.bildirimTarih!.compareTo(a.bildirimTarih!));
      goruntulenmisBildirimListesi
          .sort((a, b) => b.bildirimTarih!.compareTo(a.bildirimTarih!));
    }

    await Future.delayed(const Duration(milliseconds: 400));

    safeEmit(
      state.copyWith(
        isLoading: false,
        isComplete: true,
        badgeCount: response.bildirimler
            ?.where((element) => element.bildirimDurumu == '0')
            .length,
        isError: false,
        unViewedNotification: goruntulenmemisBildirimListesi,
        viewedNotification: goruntulenmisBildirimListesi,
      ),
    );
  }

  //bildirimi okuduktan sonra servis ile okundu olarak kaydı güncelle
  Future<void> readNotifications(String loginuserid, String token,
      String bildirimId, String bildirimUserFirmId) async {
    await repo.readNotification(token, loginuserid, bildirimId);
  }
}
