class BaseResponseModel {
  final int? success;
  final String? message;

  BaseResponseModel({this.success, this.message});

  factory BaseResponseModel.fromJson(Map<String, dynamic> json) {
    return BaseResponseModel(
      success: json['success'],
      message: json['message'],
    );
  }

  @override
  bool operator ==(Object other) {
    if (identical(this, other)) return true;

    return other is BaseResponseModel &&
        other.success == success &&
        other.message == message;
  }

  @override
  int get hashCode => success.hashCode ^ message.hashCode;
}
