import 'package:flutter/material.dart';
import 'package:flutter_bloc/flutter_bloc.dart';
import 'package:hamlemuhcrm/core/extensions/log_extension.dart';
import 'package:hamlemuhcrm/features/auth/login/cubit/login_cubit.dart';
import 'package:hamlemuhcrm/features/projects/cubit/missions_cubit.dart';

import '../../../core/constants/color_constants.dart';
import '../model/filter_chip.dart';

class FilterMissionChip extends StatefulWidget {
  const FilterMissionChip({super.key});

  @override
  State<FilterMissionChip> createState() => _FilterMissionChipState();
}

class _FilterMissionChipState extends State<FilterMissionChip> {
  List<FilterChipModel> filterList = [
    FilterChipModel(index: 0, name: 'Ana Görevler'),
    FilterChipModel(index: 1, name: 'Ek Görevler'),
  ];

  ValueNotifier<int> activeIndex = ValueNotifier<int>(0);

  @override
  Widget build(BuildContext context) {
    final textTheme = Theme.of(context).textTheme;
    return Row(children: [
      ...List.generate(2, (index) {
        var chip = filterList[index];
        return ValueListenableBuilder(
          valueListenable: activeIndex,
          builder: (context, notifierValue, child) => InkWell(
            onTap: () {
              'activeIndex : ${activeIndex.value}'.log();
              'chipIndex : ${chip.index}'.log();
              activeIndex.value = chip.index;
              context.read<MissionsCubit>().tumGorevleriListele(
                  context.read<LoginCubit>().token,
                  context.read<LoginCubit>().id,
                  activeIndex.value);
            },
            splashColor: Colors.transparent,
            child: Container(
              margin: const EdgeInsets.all(5),
              decoration: BoxDecoration(
                  color: activeIndex.value == chip.index
                      ? ColorsConstants.instance.baseTheme
                      : Colors.grey.shade200,
                  borderRadius: BorderRadius.circular(14),
                  border: Border.all(
                      color: activeIndex.value == chip.index
                          ? Colors.black26
                          : Colors.grey.shade400,
                      width: 1.4)),
              child: Padding(
                padding:
                    const EdgeInsets.symmetric(horizontal: 10, vertical: 5),
                child: Text(
                  chip.name,
                  style: textTheme.titleSmall?.copyWith(
                    color: activeIndex.value == chip.index
                        ? Colors.white
                        : Colors.black45,
                  ),
                ),
              ),
            ),
          ),
        );
      })
    ]);
  }
}
