import 'package:flutter/material.dart';
import 'package:hamlemuhcrm/core/constants/color_constants.dart';

class EmployeeTypeHeadline extends StatelessWidget {
  final String employeeType;

  const EmployeeTypeHeadline({super.key, required this.employeeType});

  @override
  Widget build(BuildContext context) {
    return Padding(
      padding: const EdgeInsets.only(top: 10),
      child: Row(
        children: [
          Text(
            employeeType,
            style: Theme.of(context).textTheme.labelSmall?.copyWith(
                color: Colors.grey,
                fontWeight: FontWeight.bold,
                fontStyle: FontStyle.italic),
          ),
          Expanded(
            child: Divider(
              thickness: 0.5,
              indent: 10,
              color: ColorsConstants.instance.appGrey,
            ),
          ),
        ],
      ),
    );
  }
}
