import 'package:flutter/material.dart';
import 'package:hamlemuhcrm/core/constants/font_styles.dart';
import 'package:hamlemuhcrm/core/extensions/responsive_extension.dart';

class ConstContainer extends StatelessWidget {
  final String headLine;

  const ConstContainer({super.key, required this.headLine});

  @override
  Widget build(BuildContext context) {
    return Container(
      height: context.dynamicHeight(0.054),
      width: context.dynamicWidth(0.9),
      alignment: Alignment.centerLeft,
      padding: const EdgeInsets.symmetric(horizontal: 5),
      decoration: BoxDecoration(
          borderRadius: BorderRadius.circular(10),
          color: Colors.white,
          border: Border.all(color: Colors.grey.shade400)),
      child: Text(headLine, style: FontStyles.instance.projectbxDdyazi),
    );
  }
}
