import 'package:flutter/material.dart';
import 'package:intl/intl.dart';

import '../../../core/constants/color_constants.dart';

class CalendarWidget extends StatelessWidget {
  final DateFormat _dateFormat = DateFormat.yMd('tr');

  CalendarWidget({super.key});

  List<DateTime> _getWeeklyDates(DateTime currentDate) {
    final List<DateTime> dates = [];

    // 3 gün öncesi
    for (int i = -3; i < 0; i++) {
      dates.add(currentDate.add(Duration(days: i)));
    }

    // Bugün ve sonraki 3 gün
    for (int i = 0; i < 4; i++) {
      dates.add(currentDate.add(Duration(days: i)));
    }

    return dates;
  }

  List<String> _getWeekDayNames(DateTime currentDate) {
    final List<String> weekDayNames = [];
    final DateFormat dateFormat = DateFormat.E('tr');

    // 3 gün öncesi
    for (int i = -3; i < 0; i++) {
      final DateTime date = currentDate.add(Duration(days: i));
      weekDayNames.add(dateFormat.format(date));
    }

    // Bugün
    weekDayNames.add('Bugün');

    // Sonraki 3 gün
    for (int i = 1; i < 4; i++) {
      final DateTime date = currentDate.add(Duration(days: i));
      weekDayNames.add(dateFormat.format(date));
    }

    return weekDayNames;
  }

  Widget _buildDayWidget(DateTime date, bool isToday, String weekDayName) {
    final TextStyle textStyle = isToday
        ? TextStyle(color: ColorsConstants.instance.baseTheme)
        : const TextStyle();

    return Expanded(
      child: Column(
        children: [
          Text(
            weekDayName,
            style: textStyle,
          ),
          _emptyHighSpace,
          Text(
            _dateFormat.format(date).substring(0, 2),
            style: textStyle,
          ),
          _emptyHighSpace,
          Container(
            height: 5,
            width: 25,
            decoration: BoxDecoration(
                color: isToday
                    ? ColorsConstants.instance.baseTheme
                    : Colors.grey.shade300,
                borderRadius: BorderRadius.circular(10)),
          ),
        ],
      ),
    );
  }

  @override
  Widget build(BuildContext context) {
    final DateTime now = DateTime.now();
    final List<DateTime> weeklyDates = _getWeeklyDates(now);
    final List<String> weekDayNames = _getWeekDayNames(now);

    return Column(
      mainAxisAlignment: MainAxisAlignment.spaceAround,
      children: [
        Row(
          children: weeklyDates.asMap().entries.map((entry) {
            final int index = entry.key;
            final DateTime date = entry.value;
            final bool isToday = date.day == now.day &&
                date.month == now.month &&
                date.year == now.year;
            final String weekDayName = weekDayNames[index];

            return _buildDayWidget(date, isToday, weekDayName);
          }).toList(),
        ),
      ],
    );
  }

  Widget get _emptyHighSpace => const SizedBox(height: 10);
}
