import 'package:flutter/material.dart';
import 'package:flutter_bloc/flutter_bloc.dart';
import 'package:hamlemuhcrm/features/projects/model/initial_id_values_model.dart';
import 'package:percent_indicator/linear_percent_indicator.dart';

import '../../../../../core/constants/color_constants.dart';
import '../../../../core/constants/font_styles.dart';
import '../../../../core/cubits/dropdown_cubit.dart';
import '../../../../core/extensions/color_extension.dart';
import '../../../../core/extensions/date_time_enum_extension.dart';
import '../../../../core/extensions/responsive_extension.dart';
import '../../../../core/route/page_route.dart';
import '../../../../data/dropdown_models/project_stage_api.dart';
import '../../../auth/login/cubit/login_cubit.dart';
import '../../cubit/missions_cubit.dart';
import '../../cubit/projects_stage_cubit.dart';
import '../../model/asamalar.dart';
import '../../model/gorevler.dart';
import '../../model/projeler.dart';
import '../../widgets/calendar_widget.dart';
import '../missions_partial/model/mission_update_model.dart';
import '../missions_partial/project_add_main_mission.dart';
import '../missions_partial/project_additional_task_view_page.dart';
import '../missions_partial/project_detail_main_mission.dart';
import '../missions_partial/project_employee_note_mission.dart';
import '../missions_partial/project_update_main_mission.dart';
import '../stages_partial/project_stage_create_page.dart';
import '../stages_partial/project_stage_detail_page.dart';
import 'constants/project_constants.dart';

class ProjectContentPage extends StatefulWidget {
  final Projeler projeler;

  const ProjectContentPage({super.key, required this.projeler});

  @override
  State<ProjectContentPage> createState() => _ProjectContentPageState();
}

class _ProjectContentPageState extends State<ProjectContentPage> {
  bool isFinishPage = false;

  @override
  void initState() {
    isFinishPage = false;
    super.initState();
    fetchData();
  }

  @override
  void didChangeDependencies() {
    super.didChangeDependencies();
    setState(() {
      isFinishPage = true;
    });
  }

  @override
  Widget build(BuildContext context) {
    return isFinishPage
        ? Scaffold(
            backgroundColor: ColorsConstants.instance.backgroundColor,
            appBar: _appBar(context),
            body: Column(
              children: [
                Padding(
                  padding: EdgeInsets.symmetric(
                      horizontal: context.dynamicWidth(0.06)),
                  child: Row(
                    mainAxisAlignment: MainAxisAlignment.spaceBetween,
                    children: [
                      Column(
                        crossAxisAlignment: CrossAxisAlignment.start,
                        children: [
                          Text(
                            DateTimeEnums.tr.nowTime(),
                            style: TextStyle(
                                color: ColorsConstants.instance.baseTheme,
                                fontSize: 12),
                          ),
                          const Text(
                            ProjectConstants.projectTodayTxt,
                            style: TextStyle(
                                color: Colors.black54,
                                fontSize: 17,
                                fontWeight: FontWeight.bold),
                          )
                        ],
                      ),
                      SizedBox(
                        height: context.dynamicHeight(0.038),
                        child: TextButton(
                            onPressed: () {
                              Navigator.push(
                                      context,
                                      CustomPageRoute(
                                          child: ProjectStageCreatePage(
                                              proje: widget.projeler)))
                                  .then(
                                      (value) => value ? _pageRefresh() : null);
                            },
                            style: TextButton.styleFrom(
                                backgroundColor:
                                    ColorsConstants.instance.baseTheme),
                            child: const Row(
                              children: [
                                Icon(
                                  Icons.add,
                                  color: Colors.white,
                                  size: 11,
                                ),
                                SizedBox(width: 7),
                                Text(
                                  ProjectConstants.projectAddStageTxt,
                                  style: TextStyle(
                                      fontSize: 10, color: Colors.white),
                                ),
                              ],
                            )),
                      )
                    ],
                  ),
                ),
                SizedBox(height: context.dynamicHeight(0.02)),
                Padding(
                  padding: const EdgeInsets.symmetric(horizontal: 15),
                  child: CalendarWidget(),
                ),
                SizedBox(height: context.dynamicHeight(0.018)),
                Expanded(
                  flex: 3,
                  child: BlocBuilder<ProjectStageCubit, List<Asamalar>>(
                    builder: (context, asamaListesi) {
                      if (asamaListesi.isNotEmpty) {
                        return _scrollBar(
                          ListView.builder(
                              itemCount: asamaListesi.length,
                              physics: const PageScrollPhysics(),
                              itemBuilder: (context, indeks) {
                                var asama = asamaListesi[indeks];
                                var gelenAnaGorevListe = context
                                    .read<MissionsCubit>()
                                    .ilgiliAnaGorevListeGetir(asama.asamaId!);
                                var tumListe =
                                    context.read<MissionsCubit>().gelenListe;
                                if (asama.asamaOnay == '0') {
                                  return const SizedBox();
                                } else {
                                  return Container(
                                    margin: EdgeInsets.symmetric(
                                        horizontal: context.dynamicWidth(0.06),
                                        vertical: context.dynamicHeight(0.014)),
                                    padding: EdgeInsets.symmetric(
                                        horizontal: context.dynamicWidth(
                                            0.04)), //pano ic bosluk sag sol
                                    decoration: BoxDecoration(
                                      borderRadius: const BorderRadius.all(
                                          Radius.circular(10)),
                                      color: Colors.white,
                                      border: Border.all(
                                          color: Colors.grey.shade300,
                                          width: 1.1),
                                    ),
                                    height: context.dynamicHeight(0.35), //*//
                                    child: Column(
                                      children: [
                                        Container(
                                          decoration: const BoxDecoration(
                                            borderRadius: BorderRadius.only(
                                                topLeft: Radius.circular(10),
                                                topRight: Radius.circular(10)),
                                          ),
                                          height: context.dynamicHeight(0.06),
                                          child: Row(
                                            mainAxisAlignment:
                                                MainAxisAlignment.spaceEvenly,
                                            children: [
                                              Text(
                                                asama.asamaAd!,
                                                style: TextStyle(
                                                    fontWeight: FontWeight.w500,
                                                    fontSize: 11,
                                                    color: ColorsConstants
                                                        .instance.baseTheme),
                                              ),
                                              const Spacer(),
                                              _stageDetailButton(asama),
                                            ],
                                          ),
                                        ),
                                        _customDivider,
                                        Container(
                                            height: context
                                                .dynamicHeight(0.22), //*//
                                            decoration: const BoxDecoration(
                                              color: Colors.white,
                                              borderRadius: BorderRadius.only(
                                                  topLeft: Radius.circular(20),
                                                  topRight:
                                                      Radius.circular(15)),
                                            ),
                                            child: ListView.builder(
                                              padding: EdgeInsets.zero,
                                              physics:
                                                  const PageScrollPhysics(),
                                              itemCount:
                                                  gelenAnaGorevListe.length,
                                              itemBuilder: (context, ids) {
                                                var gorev =
                                                    gelenAnaGorevListe[ids];
                                                int ekGorevsayisi = 0;
                                                int tamamlananEkGorev = 0;
                                                ekGorevsayisi = tumListe
                                                    .where((element) =>
                                                        element.gorevUstId ==
                                                        gorev.gorevId)
                                                    .toList()
                                                    .length;
                                                tamamlananEkGorev = tumListe
                                                    .where((element) =>
                                                        element.gorevUstId ==
                                                            gorev.gorevId &&
                                                        element.gorevDurum ==
                                                            "1")
                                                    .toList()
                                                    .length;
                                                Color gelenRenk = Colors.amber;
                                                if (gorev.renketiketi != null &&
                                                    gorev.renketiketi != '') {
                                                  gelenRenk =
                                                      gelenRenk.toColorPicker(
                                                          gorev.renketiketi!);
                                                }
                                                double oran = (ekGorevsayisi >
                                                        0)
                                                    ? tamamlananEkGorev /
                                                        ekGorevsayisi.toDouble()
                                                    : 0.0;
                                                String yaklasikOran =
                                                    oran.toStringAsFixed(2);
                                                double gercekOran =
                                                    double.parse(yaklasikOran);

                                                //print('double oran : $gercekOran');
                                                if (gelenAnaGorevListe
                                                    .isNotEmpty) {
                                                  return InkWell(
                                                    onTap: () {
                                                      Navigator.push(
                                                          context,
                                                          CustomPageRoute(
                                                              child:
                                                                  ProjectTaskViewPage(
                                                            gorevler: gorev,
                                                          ))).then((value) {
                                                        if (value == null) {
                                                          return;
                                                        }
                                                        setState(() {
                                                          context
                                                              .read<
                                                                  MissionsCubit>()
                                                              .projeGorevListele(
                                                                  widget
                                                                      .projeler
                                                                      .projeId!,
                                                                  context
                                                                      .read<
                                                                          LoginCubit>()
                                                                      .token,
                                                                  context
                                                                      .read<
                                                                          LoginCubit>()
                                                                      .id,
                                                                  context
                                                                      .read<
                                                                          LoginCubit>()
                                                                      .userfirmId,
                                                                  context
                                                                      .read<
                                                                          LoginCubit>()
                                                                      .tip)
                                                              .whenComplete(() {
                                                            context
                                                                .read<
                                                                    ProjectStageCubit>()
                                                                .projeAsamaListele(
                                                                    widget
                                                                        .projeler
                                                                        .projeId!,
                                                                    context
                                                                        .read<
                                                                            LoginCubit>()
                                                                        .token,
                                                                    context
                                                                        .read<
                                                                            LoginCubit>()
                                                                        .id);
                                                          });
                                                        });
                                                      });
                                                    },
                                                    child: Container(
                                                      margin: EdgeInsets.all(
                                                          context.dynamicWidth(
                                                              0.02)),
                                                      height:
                                                          context.dynamicHeight(
                                                              0.08), //*//
                                                      decoration: BoxDecoration(
                                                          border: Border.all(
                                                              color: Colors.grey
                                                                  .withOpacity(
                                                                      0.3),
                                                              width: 1),
                                                          color: ColorsConstants
                                                              .instance
                                                              .backgroundColor,
                                                          borderRadius:
                                                              const BorderRadius
                                                                  .all(Radius
                                                                      .circular(
                                                                          8))),
                                                      child: Column(
                                                        mainAxisAlignment:
                                                            MainAxisAlignment
                                                                .center,
                                                        crossAxisAlignment:
                                                            CrossAxisAlignment
                                                                .start,
                                                        children: [
                                                          Row(
                                                            children: [
                                                              const SizedBox(
                                                                  width: 15),
                                                              Container(
                                                                height: context
                                                                    .dynamicHeight(
                                                                        0.05),
                                                                width: 5,
                                                                decoration:
                                                                    BoxDecoration(
                                                                        color:
                                                                            gelenRenk, //gorev renk kodu
                                                                        border: Border.all(
                                                                            color:
                                                                                Colors.black12,
                                                                            width: 1.2)),
                                                              ),
                                                              const SizedBox(
                                                                  width: 10),
                                                              Column(
                                                                crossAxisAlignment:
                                                                    CrossAxisAlignment
                                                                        .start,
                                                                mainAxisAlignment:
                                                                    MainAxisAlignment
                                                                        .center,
                                                                children: [
                                                                  Row(
                                                                    mainAxisAlignment:
                                                                        MainAxisAlignment
                                                                            .start,
                                                                    children: [
                                                                      Text(
                                                                          gorev.gorevAd!.length > 18
                                                                              ? gorev.gorevAd!.substring(0,
                                                                                  17)
                                                                              : gorev
                                                                                  .gorevAd!,
                                                                          style: TextStyle(
                                                                              fontWeight: FontWeight.bold,
                                                                              fontSize: 13,
                                                                              color: Colors.grey.shade700)),
                                                                    ],
                                                                  ),
                                                                  SizedBox(
                                                                    height: context
                                                                        .dynamicHeight(
                                                                            0.004),
                                                                  ),
                                                                  Row(
                                                                    children: [
                                                                      Column(
                                                                        crossAxisAlignment:
                                                                            CrossAxisAlignment.start,
                                                                        children: [
                                                                          SizedBox(
                                                                            width:
                                                                                context.dynamicWidth(0.3),
                                                                            child:
                                                                                Row(
                                                                              mainAxisAlignment: MainAxisAlignment.spaceBetween,
                                                                              children: [
                                                                                const Text(
                                                                                  ProjectConstants.projectProgressStatusTxt,
                                                                                  style: TextStyle(fontSize: 7),
                                                                                ),
                                                                                Text(
                                                                                  ' % ${gercekOran == 1.0 ? 100 : gercekOran.toString().replaceAll('0.', '')}',
                                                                                  style: const TextStyle(fontSize: 7),
                                                                                ),
                                                                              ],
                                                                            ),
                                                                          ),
                                                                          SizedBox(
                                                                            height:
                                                                                context.dynamicHeight(0.01),
                                                                            width:
                                                                                context.dynamicWidth(0.3),
                                                                            child:
                                                                                LinearPercentIndicator(
                                                                              lineHeight: 2.5,
                                                                              padding: EdgeInsets.zero,
                                                                              percent: gercekOran,
                                                                              barRadius: const Radius.circular(15),
                                                                              progressColor: Colors.green,
                                                                              backgroundColor: Colors.grey.shade400,
                                                                            ),
                                                                          ),
                                                                        ],
                                                                      ),
                                                                    ],
                                                                  ),
                                                                ],
                                                              ),
                                                              SizedBox(
                                                                width: context
                                                                    .dynamicWidth(
                                                                        0.03),
                                                              ),
                                                              Row(
                                                                children: [
                                                                  const Icon(
                                                                    Icons
                                                                        .checklist_rounded,
                                                                    size: 15,
                                                                    color: Colors
                                                                        .black38,
                                                                  ),
                                                                  SizedBox(
                                                                    width: context
                                                                        .dynamicWidth(
                                                                            0.01),
                                                                  ),
                                                                  Text(
                                                                    '${tamamlananEkGorev.toString()} / ${ekGorevsayisi.toString()}',
                                                                    style: const TextStyle(
                                                                        fontSize:
                                                                            10),
                                                                  ),
                                                                ],
                                                              ),
                                                              const Spacer(),
                                                              _employeeNoteButton(
                                                                  context,
                                                                  gorev),
                                                              widget.projeler
                                                                          .projeVerenUserId ==
                                                                      context
                                                                          .read<
                                                                              LoginCubit>()
                                                                          .id
                                                                  ? _updateMainMissionButton(
                                                                      gorev)
                                                                  : _detailMainMissionButton(
                                                                      gorev),
                                                              _emptyWidthSpace,
                                                            ],
                                                          ),
                                                        ],
                                                      ),
                                                    ),
                                                  );
                                                } else {
                                                  return const Center();
                                                }
                                              },
                                            )),
                                        _customDivider,
                                        _emptySpace,
                                        _addMissionButton(asama),
                                      ],
                                    ),
                                  );
                                }
                              }),
                        );
                      } else if (asamaListesi.isEmpty) {
                        return Center(
                          child: SizedBox(
                            height: context.dynamicHeight(0.3),
                            width: context.dynamicWidth(0.9),
                            child: const Column(
                              mainAxisAlignment: MainAxisAlignment.center,
                              children: [
                                SizedBox(height: 25),
                                Icon(Icons.clear),
                                SizedBox(height: 10),
                                Text(
                                  ProjectConstants.projectNotFoundStageTxt,
                                  style: TextStyle(fontSize: 17),
                                ),
                              ],
                            ),
                          ),
                        );
                      } else {
                        return const Center(child: CircularProgressIndicator());
                      }
                    },
                  ),
                ),
              ],
            ),
          )
        : Scaffold(body: _isLoadingBar);
  }

  void fetchData() {
    context
        .read<MissionsCubit>()
        .projeGorevListele(
            widget.projeler.projeId!,
            context.read<LoginCubit>().token,
            context.read<LoginCubit>().id,
            context.read<LoginCubit>().userfirmId,
            context.read<LoginCubit>().tip)
        .whenComplete(() => context.read<ProjectStageCubit>().projeAsamaListele(
            widget.projeler.projeId!,
            context.read<LoginCubit>().token,
            context.read<LoginCubit>().id));
  }

  Widget _updateMainMissionButton(Gorevler gorev) => GestureDetector(
        onTap: () {
          _editMission(
            gorev.gorevlilerAdlar ?? '',
            gorev.gorevsorumlularAdlar ?? '',
            gorev: MissionUpdateModel(
                gorevSorumlular: gorev.gorevsorumlular ?? '',
                gorevliler: gorev.gorevliler ?? '',
                loginuserID: context.read<LoginCubit>().id,
                token: context.read<LoginCubit>().token,
                userType: context.read<LoginCubit>().tip,
                gorevID: gorev.gorevId ?? "",
                gorevUserFirmId: gorev.gorevUserfirmId ?? "",
                projeId: widget.projeler.projeId ?? "0",
                gorevAd: gorev.gorevAd ?? "",
                gorevAciklama: gorev.gorevAciklama ?? "",
                dbSaatbaslangic: gorev.gorevBaslangicTarihi ?? "",
                dbSaatbitis: gorev.gorevBitisTarihi ?? "",
                renkKodu: gorev.renketiketi ?? "",
                asamaId: gorev.gorevDurum ?? ""),
          );
        },
        child: const Icon(
          size: 20,
          Icons.app_registration_sharp,
          color: Colors.black54,
        ),
      );

  Widget _detailMainMissionButton(Gorevler gorev) => GestureDetector(
        onTap: () {
          _detailMission(
            gorev.gorevlilerAdlar ?? '',
            gorev.gorevsorumlularAdlar ?? '',
            gorev: MissionUpdateModel(
                gorevSorumlular: gorev.gorevsorumlular ?? '',
                gorevliler: gorev.gorevliler ?? '',
                loginuserID: context.read<LoginCubit>().id,
                userType: context.read<LoginCubit>().tip,
                token: context.read<LoginCubit>().token,
                gorevID: gorev.gorevId ?? "",
                gorevUserFirmId: gorev.gorevUserfirmId ?? "",
                projeId: widget.projeler.projeId ?? "0",
                gorevAd: gorev.gorevAd ?? "",
                gorevAciklama: gorev.gorevAciklama ?? "",
                dbSaatbaslangic: gorev.gorevBaslangicTarihi ?? "",
                dbSaatbitis: gorev.gorevBitisTarihi ?? "",
                renkKodu: gorev.renketiketi ?? "",
                asamaId: gorev.gorevDurum ?? ""),
          );
        },
        child: const Icon(
          size: 20,
          Icons.notes_outlined,
          color: Colors.black54,
        ),
      );

  Future<void> _editMission(
      String gelenGorevliAdlar, String gelenGorevSorumluAdlar,
      {required MissionUpdateModel gorev}) async {
    var liste = await context.read<DropdownCubit>().processStage(gorev.projeId,
        context.read<LoginCubit>().token, context.read<LoginCubit>().id);
    _navigateToEditMission(
        gorev, liste, gelenGorevliAdlar, gelenGorevSorumluAdlar);
  }

  Future<void> _detailMission(
      String gelenGorevliAdlar, String gelenGorevSorumluAdlar,
      {required MissionUpdateModel gorev}) async {
    var liste = await context.read<DropdownCubit>().processStage(gorev.projeId,
        context.read<LoginCubit>().token, context.read<LoginCubit>().id);
    _navigateToDetailMission(
        gorev, liste, gelenGorevliAdlar, gelenGorevSorumluAdlar);
  }

  void _navigateToEditMission(MissionUpdateModel gorev, List<AsamalarDD>? liste,
      String gelenGorevliAdlar, String gelenGorevSorumluAdlar) {
    Navigator.push(
            context,
            CustomPageRoute(
                child: ProjectUpdateMainMission(
                    gelenGorevSorumluAdlar: gelenGorevSorumluAdlar,
                    gelenGorevliAdlar: gelenGorevliAdlar,
                    gorev: gorev,
                    asamalar: liste ?? [])))
        .then((value) {
      if (value == null) return;
      fetchData();
    });
  }

  void _navigateToDetailMission(
      MissionUpdateModel gorev,
      List<AsamalarDD>? liste,
      String gelenGorevliAdlar,
      String gelenGorevSorumluAdlar) {
    Navigator.push(
            context,
            CustomPageRoute(
                child: ProjectDetailMainMission(
                    gelenGorevSorumluAdlar: gelenGorevSorumluAdlar,
                    gelenGorevliAdlar: gelenGorevliAdlar,
                    gorev: gorev,
                    asamalar: liste ?? [])))
        .then((value) {
      if (value == null) return;
      fetchData();
    });
  }

  Widget get _emptySpace => SizedBox(
        height: context.dynamicHeight(0.013),
      );

  Widget get _emptyWidthSpace => SizedBox(
        width: context.dynamicWidth(0.02),
      );

  AppBar _appBar(BuildContext context) {
    return AppBar(
        backgroundColor: Colors.transparent,
        elevation: 0,
        title: Text(
            widget.projeler.projeAd!.length > 19
                ? widget.projeler.projeAd!.substring(0, 18)
                : widget.projeler.projeAd!,
            style: FontStyles.instance.appbarTitleStyle),
        centerTitle: true,
        actions: [
          IconButton(
              onPressed: () {},
              icon: const Icon(
                Icons.notifications_none_outlined,
                color: Colors.black,
              )),
        ],
        leading: IconButton(
          onPressed: () {
            FocusScope.of(context).unfocus();
            Navigator.pop(context);
          },
          icon: const Icon(
            Icons.arrow_back_ios_new,
            color: Colors.black87,
          ),
        ));
  }

  void _navigateToProject(
      BuildContext context, Asamalar asama, String projeAd) async {
    Navigator.push(
            context,
            MaterialPageRoute(
                builder: (context) =>
                    ProjectStageDetailPage(asama: asama, projeAd: projeAd)))
        .then((value) => value ? _pageRefresh() : null);
  }

  Widget _stageDetailButton(Asamalar asama) => IconButton(
        onPressed: () {
          _navigateToProject(context, asama, widget.projeler.projeAd ?? "");
        },
        tooltip: 'Aşama Detay',
        icon: Icon(
          Icons.more_horiz,
          color: ColorsConstants.instance.baseTheme,
          size: 14,
        ),
      );

  Widget _addMissionButton(Asamalar asama) {
    return Row(
      mainAxisAlignment: MainAxisAlignment.end,
      children: [
        SizedBox(
          height: context.dynamicHeight(0.035),
          child: TextButton(
            onPressed: () {
              _addMission(asama);
            },
            style: TextButton.styleFrom(
                backgroundColor: ColorsConstants.instance.baseTheme),
            child: _addMissionStyle,
          ),
        )
      ],
    );
  }

  Widget get _addMissionStyle => Row(
        children: [
          const Icon(
            Icons.add_circle,
            color: Colors.white,
            size: 10,
          ),
          const SizedBox(width: 8),
          Text(ProjectConstants.projectAddMissionTxt,
              style: Theme.of(context)
                  .textTheme
                  .titleMedium
                  ?.copyWith(color: Colors.white, fontSize: 9)),
        ],
      );

  void _addMission(Asamalar asama) {
    Navigator.push(
        context,
        MaterialPageRoute(
            builder: (context) => ProjectAddMainMission(
                initialModel: InitialIdValuesModel(
                    initialGorevlilerAdlar:
                        widget.projeler.projeGorevliIsimler ?? '',
                    initialGorevliIdler: widget.projeler.projeGorevliler ?? '',
                    initialSorumluAdlar:
                        widget.projeler.projeSorumluIsimler ?? '',
                    initialSorumluIdler: widget.projeler.projeSorumlular ?? ''),
                projeId: widget.projeler.projeId ?? "0",
                asamaId: asama.asamaId ?? "0"))).then(
        (value) => value ? fetchData() : null);
  }

  void _pageRefresh() {
    context
        .read<MissionsCubit>()
        .projeGorevListele(
            widget.projeler.projeId!,
            context.read<LoginCubit>().token,
            context.read<LoginCubit>().id,
            context.read<LoginCubit>().userfirmId,
            context.read<LoginCubit>().tip)
        .whenComplete(() {
      context
          .read<ProjectStageCubit>()
          .projeAsamaListele(widget.projeler.projeId!,
              context.read<LoginCubit>().token, context.read<LoginCubit>().id)
          .whenComplete(() {
        setState(() {
          isFinishPage = true;
        });
      });
    });
  }
}

void _navigateToEmployeeNote(
    BuildContext context, Gorevler gorev, String userId) {
  bool isEditNote = isEditNoteResult(
      userId, gorev.gorevliler ?? '', gorev.gorevsorumlular ?? '');

  Navigator.push(
      context,
      MaterialPageRoute(
          builder: (context) => MainMissionEmployeeNotes(
              isEditNote: isEditNote,
              mainMissionId: gorev.gorevId ?? '',
              mainMissionName: gorev.gorevAd ?? '')));
}

bool isEditNoteResult(String userId, String gorevliler, String sorumlular) {
  List<String> gorevliListe = gorevliler.split(',');
  List<String> sorumluListe = sorumlular.split(',');

  List<String> genel = [...gorevliListe, ...sorumluListe];

  if (genel.contains(userId)) {
    return true;
  }
  return false;
}

Widget _employeeNoteButton(BuildContext context, Gorevler gorev) => IconButton(
    onPressed: () {
      _navigateToEmployeeNote(context, gorev, context.read<LoginCubit>().id);
    },
    icon: const Icon(Icons.edit_note_sharp, size: 20, color: Colors.black54));

Widget get _customDivider => const Divider(
      height: 0,
      thickness: 1,
    );

Widget get _isLoadingBar => const Center(
      child: CircularProgressIndicator(),
    );

Widget _scrollBar(Widget child) {
  return Scrollbar(
    thickness: 6,
    radius: const Radius.circular(10),
    child: child,
  );
}
