import 'package:flutter/material.dart';
import 'package:flutter_bloc/flutter_bloc.dart';
import 'package:hamlemuhcrm/features/projects/tab_bar/custom_project_tab_bar.dart';

import 'package:percent_indicator/circular_percent_indicator.dart';

import '../../../core/constants/color_constants.dart';
import '../../../core/constants/font_styles.dart';
import '../../../core/extensions/responsive_extension.dart';
import '../../auth/login/cubit/login_cubit.dart';
import '../../home/cubit/home_custom_cubit.dart';

import '../cubit/missions_cubit.dart';
import '../cubit/project_cubit.dart';
import '../tab_bar/missions_tab_bar.dart';
import '../tab_bar/projects_tab_bar.dart';

class ProjectsPage extends StatefulWidget {
  const ProjectsPage({super.key});

  @override
  State<ProjectsPage> createState() => _ProjectsPageState();
}

class _ProjectsPageState extends State<ProjectsPage>
    with SingleTickerProviderStateMixin {
  late TabController tabController;

  TabController get getTabController => tabController;

  @override
  void initState() {
    debugPrint('project page initState çalıştı');
    tabController = TabController(length: 2, vsync: this);
    isFinish = false;
    tabController.addListener(changeIndexList);
    isFinish = true;
    super.initState();
  }

  bool isFinish = false;

  void changeIndexList() {
    switch (tabController.index) {
      case 0:
        context.read<ProjectCubit>().changeFilterProjectList(
            tabController.index,
            context.read<LoginCubit>().id,
            context.read<LoginCubit>().token,
            context.read<LoginCubit>().userfirmId,
            context.read<LoginCubit>().tip);
        return;
      case 1:
        context.read<MissionsCubit>().tumGorevleriListele(
            context.read<LoginCubit>().token, context.read<LoginCubit>().id, 0);
        return;
    }
  }

  @override
  void dispose() {
    tabController.dispose();
    super.dispose();
  }

  @override
  Widget build(BuildContext context) {
    return DefaultTabController(
      animationDuration: const Duration(seconds: 1),
      length: 2,
      child: Scaffold(
        body: Column(
          children: [
            Container(
              margin:
                  EdgeInsets.symmetric(horizontal: context.dynamicWidth(0.033)),
              height: context.dynamicHeight(0.1718),
              decoration: BoxDecoration(
                borderRadius: BorderRadius.circular(15),
                color: Colors.white,
                boxShadow: [
                  BoxShadow(
                      color: Colors.grey.withOpacity(0.5),
                      blurRadius: 6,
                      offset: const Offset(2, 3))
                ],
              ),
              child: Column(
                mainAxisAlignment: MainAxisAlignment.center,
                children: [
                  Row(
                    mainAxisAlignment: MainAxisAlignment.spaceEvenly,
                    children: [
                      CircularPercentIndicator(
                        radius: 50,
                        lineWidth: 12,
                        percent: 0.86,
                        center: const CircleAvatar(
                          radius: 26,
                          backgroundColor: Color(0xFFA6A6A6),
                          child: CircleAvatar(
                            backgroundColor: Color(0xFFD6D2D1),
                            radius: 22,
                          ),
                        ),
                        progressColor: ColorsConstants.instance.baseTheme,
                        backgroundColor: Colors.white,
                        circularStrokeCap: CircularStrokeCap.round,
                      ),
                      Column(
                        crossAxisAlignment: CrossAxisAlignment.start,
                        children: [
                          Text(
                            context.read<LoginCubit>().ad,
                            style: FontStyles.instance.robotoYazi,
                          ),
                          Text(
                            context.read<LoginCubit>().soyad,
                            style: FontStyles.instance.robotoYazi,
                          ),
                        ],
                      ),
                      Column(
                        children: [
                          // 'Projeler : ${context.read<HomeCustomCubit>().projeSayisi}'
                          _upBarButton(context,
                              'Projeler : ${context.watch<HomeCustomCubit>().projeSayisi}'),
                          SizedBox(height: context.dynamicHeight(0.01)),
                          // 'Görevler : ${context.read<HomeCustomCubit>().gorevSayisi}'
                          _upBarButton(context,
                              'Görevler : ${context.watch<HomeCustomCubit>().gorevSayisi}'),
                          SizedBox(height: context.dynamicHeight(0.01)),
                          // 'Ek Görevler : ${context.read<HomeCustomCubit>().ekGorevSayisi}'
                          _upBarButton(context,
                              'Ek Görevler : ${context.watch<HomeCustomCubit>().ekGorevSayisi}'),
                        ],
                      ),
                    ],
                  ),
                ],
              ),
            ),
            Expanded(
              child: Column(
                children: [
                  const SizedBox(height: 15),
                  Container(
                    margin: const EdgeInsets.symmetric(horizontal: 10),
                    decoration: BoxDecoration(
                        color: Colors.grey.shade200,
                        borderRadius: BorderRadius.circular(15)),
                    child: Column(
                      children: [
                        _tabBarContainer(context,
                            CustomProjectTabBar(tabController: tabController)),
                      ],
                    ),
                  ),
                  SizedBox(
                    height: context.dynamicHeight(0.01),
                  ),
                  isFinish
                      ? Expanded(
                          child: TabBarView(
                            controller: getTabController,
                            children: const [
                              ProjectTabBar(),
                              MissionTabBar(),
                            ],
                          ),
                        )
                      : _isLoadingBar,
                ],
              ),
            ),
          ],
        ),
      ),
    );
  }

  Widget _upBarButton(BuildContext context, String text) {
    return Container(
      height: context.dynamicHeight(0.038),
      width: context.dynamicWidth(0.32),
      decoration: BoxDecoration(
          borderRadius: BorderRadius.circular(10),
          border: Border.all(
              color:
                  const Color.fromARGB(255, 133, 133, 133).withOpacity(0.2))),
      child: Row(
        children: [
          SizedBox(width: context.dynamicWidth(0.01)),
          Icon(
            Icons.arrow_circle_right_outlined,
            color: ColorsConstants.instance.baseTheme,
            size: context.dynamicWidth(0.04),
          ),
          SizedBox(width: context.dynamicWidth(0.018)),
          Flexible(
            fit: FlexFit.loose,
            child: Text(
              text,
              style: FontStyles.instance.ortaYazi,
            ),
          ),
        ],
      ),
    );
  }

  Widget get _isLoadingBar => const Center(
        child: CircularProgressIndicator(),
      );

  Widget _tabBarContainer(BuildContext context, Widget child) {
    return Container(
      padding: const EdgeInsets.all(5),
      height: context.dynamicHeight(0.0558),
      child: child,
    );
  }
}
