import 'package:flutter/material.dart';
import 'package:flutter_bloc/flutter_bloc.dart';
import 'package:hamlemuhcrm/core/widgets/not_permission_widget.dart';
import '../../../../core/constants/color_constants.dart';
import '../../../../core/extensions/image_enum_extension.dart';
import '../../../../core/constants/font_styles.dart';
import '../../../../core/extensions/responsive_extension.dart';
import '../../../../data/dropdown_models/project_stage_api.dart';
import '../../cubit/project_cubit.dart';
import '../../widgets/employee_type_headline.dart';
import '../../widgets/multiselect_widgets/selected_employee_chip.dart';
import 'model/mission_update_model.dart';

import '../../widgets/stage_dropdowns.dart';
import 'project_detail_main_mission_mixin.dart';

class ProjectDetailMainMission extends StatefulWidget {
  final MissionUpdateModel gorev;
  final List<AsamalarDD> asamalar;
  final String gelenGorevSorumluAdlar;
  final String gelenGorevliAdlar;

  const ProjectDetailMainMission(
      {super.key,
      required this.gorev,
      required this.asamalar,
      required this.gelenGorevSorumluAdlar,
      required this.gelenGorevliAdlar});

  @override
  State<ProjectDetailMainMission> createState() => _ProjectDetailMainMission();
}

class _ProjectDetailMainMission extends State<ProjectDetailMainMission>
    with ProjectDetailMainMissionMixin {
  @override
  Widget build(BuildContext context) {
    return isFinish
        ? Scaffold(
            appBar: AppBar(
              backgroundColor: Colors.transparent,
              elevation: 0,
              title: Text(widget.gorev.gorevAd,
                  style: FontStyles.instance.appbarTitleStyle),
              centerTitle: true,
              leading: IconButton(
                  onPressed: () {
                    Navigator.pop(context, true);
                  },
                  icon: const Icon(
                    Icons.arrow_back_ios_new,
                    color: Colors.black54,
                    size: 20,
                  )),
            ),
            body: SingleChildScrollView(
              child: Column(
                children: [
                  SizedBox(
                      height: context.dynamicHeight(0.23),
                      child: ImageEnums.umission.toPageImage),
                  _emptyWidgetSpace(context),
                  Padding(
                    padding: EdgeInsets.symmetric(
                        horizontal: context.dynamicWidth(0.07)),
                    child: Column(
                      children: [
                        Column(
                          children: [
                            _headLine('Görev Adı'),
                            _emptyMiddleHeightSpace(context),
                            _missionNameContainer,
                          ],
                        ),
                        _emptyWidgetSpace(context),
                        Row(
                          mainAxisAlignment: MainAxisAlignment.spaceBetween,
                          children: [
                            Column(
                              crossAxisAlignment: CrossAxisAlignment.start,
                              children: [
                                _headLine('Başlangıç Tarihi'),
                                _emptyMiddleHeightSpace(context),
                                _dateContainer(gosterilenSaatbaslangic),
                              ],
                            ),
                            Column(
                              crossAxisAlignment: CrossAxisAlignment.start,
                              children: [
                                _headLine('Bitiş Tarihi'),
                                _emptyMiddleHeightSpace(context),
                                _dateContainer(gosterilenSaatbitis),
                              ],
                            ),
                          ],
                        ),
                        _emptyWidgetSpace(context),
                        Column(
                          children: [
                            _headLine('Görev Aşama'),
                            // AbsorbPointer sayesinde tıklama özelliği kapattık
                            AbsorbPointer(
                              absorbing: true,
                              child: StageDropdowns(
                                  asamalar: widget.asamalar,
                                  projeId: widget.gorev.projeId,
                                  asamaId: widget.gorev.asamaId),
                            )
                          ],
                        ),
                        _emptyWidgetSpace(context),
                        Row(
                          mainAxisAlignment: MainAxisAlignment.spaceBetween,
                          children: [
                            Column(
                              crossAxisAlignment: CrossAxisAlignment.start,
                              children: [
                                _headLine('Sorumlular'),
                                _emptySpace(context),
                                _selectedEmployeeContainer(secilenAmirList),
                              ],
                            ),
                            Column(
                              crossAxisAlignment: CrossAxisAlignment.start,
                              children: [
                                _headLine('Görevliler'),
                                _emptySpace(context),
                                _selectedEmployeeContainer(secilenPersonelList)
                              ],
                            ),
                          ],
                        ),
                        _emptyWidgetSpace(context),
                        context.read<ProjectCubit>().secilenAmirIdler.isNotEmpty
                            ? Column(children: [
                                const EmployeeTypeHeadline(
                                    employeeType: "Sorumlular"),
                                SelectedEmployeeWidget(
                                    selectedLeaders: context
                                        .read<ProjectCubit>()
                                        .secilenAmirAdlar)
                              ])
                            : const SizedBox.shrink(),
                        context
                                .read<ProjectCubit>()
                                .secilenPersonelIdler
                                .isNotEmpty
                            ? Column(children: [
                                const EmployeeTypeHeadline(
                                    employeeType: "Görevliler"),
                                SelectedEmployeeWidget(
                                    selectedLeaders: context
                                        .read<ProjectCubit>()
                                        .secilenPersonelAdlar),
                              ])
                            : const SizedBox.shrink(),
                        _emptyWidgetSpace(context),
                        Column(
                          children: [
                            _headLine('Açıklama'),
                            _emptyMiddleHeightSpace(context),
                            _descriptionContainer,
                          ],
                        ),
                        Row(
                          mainAxisAlignment: MainAxisAlignment.spaceBetween,
                          children: [
                            _showColorContainer,
                            const NotPermissionWidget(moduleName: 'Görevi'),
                          ],
                        ),
                      ],
                    ),
                  ),
                ],
              ),
            ),
          )
        : const Scaffold();
  }

  Widget get _missionNameContainer => Container(
        height: context.dynamicHeight(0.05),
        width: context.dynamicWidth(0.88),
        padding: const EdgeInsets.symmetric(horizontal: 7),
        alignment: Alignment.centerLeft,
        decoration: BoxDecoration(
            color: Colors.white,
            border: Border.all(color: Colors.grey.shade400),
            borderRadius: BorderRadius.circular(10)),
        child: SingleChildScrollView(
          scrollDirection: Axis.horizontal,
          child: Text(
            widget.gorev.gorevAd,
            style: FontStyles.instance.projectbxDdyazi,
          ),
        ),
      );

  Widget _selectedEmployeeContainer(List<String> list) => Container(
        height: context.dynamicHeight(0.055),
        width: context.dynamicWidth(0.40),
        padding: const EdgeInsets.symmetric(horizontal: 10),
        decoration: BoxDecoration(
          borderRadius: BorderRadius.circular(10),
          color: list.isNotEmpty ? Colors.grey.shade200 : Colors.white,
          border: Border.all(
            color: Colors.grey.withOpacity(0.6),
          ),
        ),
        child: Row(
          mainAxisAlignment: MainAxisAlignment.spaceBetween,
          children: [
            Text(
              list.isNotEmpty ? 'Seçildi' : '',
              style: const TextStyle(fontSize: 13.5),
            ),
            Icon(
              Icons.arrow_drop_down_sharp,
              size: 23,
              color: ColorsConstants.instance.baseTheme,
            )
          ],
        ),
      );

  Widget get _showColorContainer => Container(
        height: 25,
        width: 25,
        decoration: BoxDecoration(
            color: selectedcolor, borderRadius: BorderRadius.circular(2)),
      );

  Widget _dateContainer(String timeType) => Container(
        height: context.dynamicHeight(0.05),
        width: context.dynamicWidth(0.41),
        padding: const EdgeInsets.symmetric(horizontal: 10),
        decoration: BoxDecoration(
          borderRadius: BorderRadius.circular(10),
          color: Colors.white,
          border: Border.all(
            color: Colors.grey.withOpacity(0.6),
          ),
        ),
        child: Row(
          mainAxisAlignment: MainAxisAlignment.spaceBetween,
          children: [
            Text(timeType, style: FontStyles.instance.projectbxDdyazi),
            Icon(
              Icons.calendar_month_outlined,
              size: 23,
              color: ColorsConstants.instance.baseTheme,
            ),
          ],
        ),
      );

  Widget get _descriptionContainer => Container(
        padding: const EdgeInsets.all(5),
        height: context.dynamicHeight(0.11),
        width: context.dynamicWidth(1),
        decoration: BoxDecoration(
          color: Colors.white,
          borderRadius: BorderRadius.circular(10),
          border: Border.all(
            color: Colors.grey.withOpacity(0.6),
          ),
        ),
        child: SingleChildScrollView(
          child: Text(
            widget.gorev.gorevAciklama,
            style: FontStyles.instance.projectbxDdyazi,
          ),
        ),
      );

  Widget _emptySpace(BuildContext context) {
    return SizedBox(
      height: context.dynamicHeight(0.005),
    );
  }

  Widget _emptyMiddleHeightSpace(BuildContext context) {
    return SizedBox(
      height: context.dynamicHeight(0.01),
    );
  }

  Widget _emptyWidgetSpace(BuildContext context) {
    return SizedBox(
      height: context.dynamicHeight(0.02),
    );
  }

  Widget _headLine(String text) {
    return Row(
      children: [
        Text(
          text,
          style: FontStyles.instance.projectbxBaslik,
        ),
      ],
    );
  }
}
