import 'package:flutter/material.dart';
import 'package:hamlemuhcrm/core/constants/color_constants.dart';

class CustomProjectTabBar extends StatelessWidget {
  final TabController tabController;
  final void Function(int index)? onPressed;

  const CustomProjectTabBar(
      {super.key, required this.tabController, this.onPressed});

  @override
  Widget build(BuildContext context) {
    return TabBar(
      unselectedLabelColor: Colors.grey.shade500,
      labelColor: ColorsConstants.instance.baseTheme,
      tabAlignment: TabAlignment.fill,
      indicatorColor: Colors.white,
      dividerColor: Colors.transparent,
      indicatorSize: TabBarIndicatorSize.tab,
      indicator: BoxDecoration(
        color: Colors.white,
        borderRadius: BorderRadius.circular(10),
      ),
      controller: tabController,
      tabs: const [
        Tab(
          text: 'Projeler',
        ),
        Tab(
          text: 'Görevler',
        ),
      ],
    );
  }
}
