import 'package:flutter_bloc/flutter_bloc.dart';
import 'package:hamlemuhcrm/data/dropdown_models/project_stage_api.dart';
import 'package:hamlemuhcrm/data/repo/project_repository.dart';
import 'package:hamlemuhcrm/features/projects/model/asamalar.dart';

class ProjectStageCubit extends Cubit<List<Asamalar>> {
  ProjectStageCubit() : super(<Asamalar>[]);

  List<AsamalarDD> asamalarDD = [];

  var repo = ProjectRepository();

  Future<void> projeAsamaListele(
      String asamaProjeId, String token, String loginuserid) async {
    var liste =
        await repo.projeAsamalariListele(asamaProjeId, token, loginuserid);
    emit(liste ?? []);
  }

  Future<void> asamaEkle(
      String asamaProjeId,
      String asamaUserfirmId,
      String asamaAd,
      String olusturanaBildirim,
      String sorumluyaBildirim,
      String calisanaBildirim,
      String asamaArsiv,
      String token,
      String loginuserid) async {
    await repo.asamaEkle(
      asamaProjeId,
      asamaUserfirmId,
      asamaAd,
      olusturanaBildirim,
      sorumluyaBildirim,
      calisanaBildirim,
      asamaArsiv,
      token,
      loginuserid,
    );
  }

  Future<void> asamaGuncelle(
      String asamaId,
      String asamaAd,
      String olusturanaBildirim,
      String sorumluyaBildirim,
      String calisanaBildirim,
      String asamaArsiv,
      String token,
      String loginuserid) async {
    await repo.asamaGuncelle(asamaId, asamaAd, olusturanaBildirim,
        sorumluyaBildirim, calisanaBildirim, asamaArsiv, token, loginuserid);
  }

  // Future<void> fetchAllItems(
  //     String asamaProjectId, String token, String loginuserid) async {
  //   var liste = await repo.fetchAllStage(asamaProjectId, token, loginuserid);
  //   asamalarDD = liste ?? [];
  // }
}
