import 'package:equatable/equatable.dart';
import 'package:hamlemuhcrm/features/profile/model/profile_permission.dart';

class ProfileState extends Equatable {
  final List<ProfilePermission> permissionList;
  final bool isLoading;
  final bool isError;
  final bool isComplete;

  const ProfileState({
    required this.permissionList,
    required this.isLoading,
    required this.isError,
    required this.isComplete,
  });

  factory ProfileState.initial() {
    return const ProfileState(
      permissionList: <ProfilePermission>[],
      isLoading: false,
      isError: false,
      isComplete: false,
    );
  }

  ProfileState copyWith({
    List<ProfilePermission>? permissionList,
    bool? isLoading,
    bool? isError,
    bool? isComplete,
  }) {
    return ProfileState(
      permissionList: permissionList ?? this.permissionList,
      isLoading: isLoading ?? this.isLoading,
      isError: isError ?? this.isError,
      isComplete: isComplete ?? this.isComplete,
    );
  }

  @override
  List<Object?> get props => [permissionList, isLoading, isError, isComplete];
}
