import 'package:flutter/material.dart';
import 'package:url_launcher/url_launcher.dart';

import '../../../core/constants/color_constants.dart';
import '../../../core/constants/url_services_constant.dart';
import '../../../core/extensions/string_extension.dart';
import '../model/message.dart';

class MessageTile extends StatelessWidget {
  const MessageTile({
    Key? key,
    required this.message,
  }) : super(key: key);

  final Message message;

  static const _borderRadius = 26.0;

  // Karşı tarafın gönderdiği mesajlar sol tarafta olacak

  @override
  Widget build(BuildContext context) {
    bool isStart = message.kullaniciGonderenId == "0";
    bool isFile = message.mesajDosyalar != null &&
        message.mesajDosyalar!.trim().isNotEmpty;
    final theme = Theme.of(context);
    final webSiteUrl = Uri.parse(
        '${URLAPIService.instance.fileBaseURL}/upload-message/${message.mesajLink}');
    return isStart
        ? _firstMessage(theme, message)
        : _defaultMessage(context, isFile, webSiteUrl, theme);
  }

  Widget _firstMessage(ThemeData theme, Message message) => Center(
        child: Padding(
          padding: EdgeInsets.symmetric(
              vertical: _kFirstMessageVerticalPadding,
              horizontal: _kFirstMessageHorizontalPadding),
          child: Container(
            decoration: BoxDecoration(
              color: theme.colorScheme.secondary,
              borderRadius: BorderRadius.circular(12),
            ),
            child: Padding(
              padding:
                  const EdgeInsets.symmetric(vertical: 4.0, horizontal: 12),
              child: Text(
                "${message.mesaj} - ${message.mesajVerilmetarihi?.phpToTrDayOfTime}",
                style: TextStyle(
                  fontSize: 12,
                  fontWeight: FontWeight.bold,
                  color: theme.colorScheme.background,
                ),
              ),
            ),
          ),
        ),
      );

  Widget _defaultMessage(
          BuildContext context, bool isFile, Uri webSiteUrl, ThemeData theme) =>
      Align(
        alignment: Alignment.centerLeft,
        child: Container(
            decoration: BoxDecoration(
              color: ColorsConstants.instance.messageTileBaloonTheme,
              borderRadius: const BorderRadius.only(
                topLeft: Radius.circular(_borderRadius),
                topRight: Radius.circular(_borderRadius),
                bottomRight: Radius.circular(_borderRadius),
              ),
            ),
            padding: const EdgeInsets.all(10),
            margin: EdgeInsets.symmetric(
              vertical: _kMessageContainerVerticalPadding,
              horizontal: _kMessageContainerHorizontalPadding,
            ),
            child:
                _textContainer(theme.textTheme, isFile, message, webSiteUrl)),
      );

  double get _kFirstMessageHorizontalPadding => 16.0;
  double get _kFirstMessageVerticalPadding => 18.0;

  double get _kMessageContainerHorizontalPadding => 10.00;
  double get _kMessageContainerVerticalPadding => 5.0;

  Widget _fileContainer(Message message, Uri webSiteUrl) => Column(
        children: [
          TextButton.icon(
            icon: const Icon(
              Icons.archive_outlined,
              color: Colors.black26,
              size: 30,
            ),
            onPressed: () async {
              if (!await launchUrl(webSiteUrl)) {
                throw Exception('Could not launch $webSiteUrl');
              }
            },
            label: Text(
              ''.extractFileName(message.mesajDosyalar!),
              style: TextStyle(
                  decoration: TextDecoration.underline,
                  decorationColor: Colors.white,
                  color: ColorsConstants.instance.containerBorderGreyColor),
            ),
          ),
        ],
      );

  Widget _textContainer(
          TextTheme textTheme, bool isFile, Message message, Uri? webSiteUrl) =>
      Column(
        mainAxisSize: MainAxisSize.min,
        crossAxisAlignment: CrossAxisAlignment.start,
        children: [
          Text(
            message.mesajAtanAd ?? "Unkown",
            style: textTheme.labelMedium?.copyWith(
                fontWeight: FontWeight.bold,
                color: ColorsConstants.instance.baseTheme),
          ),
          isFile
              ? _fileContainer(message, webSiteUrl ?? Uri())
              : const SizedBox(),
          SelectableText(
            message.mesaj ?? "",
            style: textTheme.bodySmall
                ?.copyWith(color: Colors.black, fontWeight: FontWeight.w600),
          ),
          Row(
            mainAxisAlignment: MainAxisAlignment.end,
            children: [
              _messageTime(
                  message.mesajVerilmetarihi?.formattedHourMinutes ?? "--:--",
                  textTheme)
            ],
          ),
        ],
      );

  Widget _messageTime(String mesajSaati, TextTheme textTheme) => Text(
        mesajSaati,
        style: textTheme.labelSmall?.copyWith(
            color: ColorsConstants.instance.containerBorderGreyColor),
      );
}
