// ignore_for_file: public_member_api_docs, sort_constructors_first

import 'package:flutter/material.dart';
import 'package:hamlemuhcrm/core/constants/color_constants.dart';

import '../../../core/extensions/responsive_extension.dart';
import '../cubit/message_cubit.dart';
import '../view/group_create_view.dart';

class MessageRadiusBox extends StatelessWidget {
  final MessageCubit cubit;
  final ValueChanged tfChanged;

  const MessageRadiusBox({
    Key? key,
    required this.cubit,
    required this.tfChanged,
  }) : super(key: key);

  // Mesajlar modülü üst turuncu container alanı

  @override
  Widget build(BuildContext context) {
    return Container(
      height: context.dynamicHeight(0.1863),
      decoration: BoxDecoration(
        color: ColorsConstants.instance.baseTheme,
        borderRadius: BorderRadius.circular(20),
      ),
      child: Padding(
        padding: EdgeInsets.symmetric(horizontal: context.dynamicWidth(0.04)),
        child: Column(
          mainAxisAlignment: MainAxisAlignment.spaceEvenly,
          children: [
            // Dışarıdan aldığımız cubit'i grup oluşturma sayfasına gönderiyoruz ki oluşan grupta mesajlaşma olduğu zaman geriye dönüldüğünde ana modüldeki pencerelere yansısın
            _orangeBoxButton(context, cubit, Icons.add_circle, "Grup Oluştur"),
            Container(
              height: context.dynamicHeight(0.05),
              padding: const EdgeInsets.symmetric(horizontal: 6),
              alignment: Alignment.center,
              decoration: BoxDecoration(
                  borderRadius: BorderRadius.circular(10),
                  color: Colors.white,
                  boxShadow: [
                    BoxShadow(
                        color: Colors.grey.withOpacity(0.4),
                        blurRadius: 6,
                        offset: const Offset(1, 1))
                  ],
                  border: Border.all(
                      color: Colors.grey.withOpacity(0.4), width: 1.0)),
              child: Row(
                children: [
                  Flexible(
                    flex: 2,
                    child: TextFormField(
                      style: const TextStyle(color: Colors.grey),
                      magnifierConfiguration:
                          TextMagnifierConfiguration.disabled,
                      onChanged: tfChanged,
                      decoration: const InputDecoration(
                          focusedBorder:
                              OutlineInputBorder(borderSide: BorderSide.none),
                          border:
                              OutlineInputBorder(borderSide: BorderSide.none),
                          icon: Icon(
                            Icons.search,
                            color: Colors.grey,
                            size: 25,
                          ),
                          contentPadding: EdgeInsets.symmetric(horizontal: 3),
                          hintText: 'Arama',
                          hintStyle:
                              TextStyle(fontSize: 16, color: Colors.grey)),
                    ),
                  ),
                ],
              ),
            ),
          ],
        ),
      ),
    );
  }
}

Widget _orangeBoxButton(BuildContext context, MessageCubit cubit, IconData icon,
        String headLine) =>
    InkWell(
      highlightColor: Colors.grey.shade50,
      onTap: () {
        Navigator.push(
            context,
            MaterialPageRoute(
                builder: (context) => GroupCreateView(cubit: cubit)));
      },
      child: Container(
        height: context.dynamicHeight(0.05),
        width: context.dynamicWidth(0.4),
        padding: const EdgeInsets.symmetric(horizontal: 10),
        decoration: BoxDecoration(
            color: const Color(0xFFFFFFFF),
            borderRadius: BorderRadius.circular(10),
            border:
                Border.all(color: Colors.grey.withOpacity(0.4), width: 1.0)),
        child: Row(
          mainAxisAlignment: MainAxisAlignment.start,
          children: [
            Padding(
              padding: const EdgeInsets.only(left: 7, right: 7),
              child: Icon(
                icon,
                color: ColorsConstants.instance.baseTheme,
                size: 25,
              ),
            ),
            const SizedBox(width: 5),
            Text(headLine, style: Theme.of(context).textTheme.bodyMedium),
          ],
        ),
      ),
    );
