class UploadFile {
  String? dosyaklasoru;
  String? dosyaadi;
  String? dosyaurl;
  String? ikonurl;
  String? dosyauzantisi;
  String? mesajformat;

  UploadFile({
    this.dosyaklasoru,
    this.dosyaadi,
    this.dosyaurl,
    this.ikonurl,
    this.dosyauzantisi,
    this.mesajformat,
  });

  factory UploadFile.fromJson(Map<String, dynamic> json) {
    return UploadFile(
      dosyaklasoru: json['dosyaklasoru'] as String?,
      dosyaadi: json['dosyaadi'] as String?,
      dosyaurl: json['dosyaurl'] as String?,
      ikonurl: json['ikonurl'] as String?,
      dosyauzantisi: json['dosyauzantisi'] as String?,
      mesajformat: json['mesajformat'] as String?,
    );
  }

  @override
  String toString() =>
      "FileUpload(dosyaklasoru: $dosyaklasoru,dosyaadi: $dosyaadi,dosyaurl: $dosyaurl,ikonurl: $ikonurl,dosyauzantisi: $dosyauzantisi,mesajformat: $mesajformat)";

  @override
  int get hashCode => Object.hash(
      dosyaklasoru, dosyaadi, dosyaurl, ikonurl, dosyauzantisi, mesajformat);

  @override
  bool operator ==(Object other) =>
      identical(this, other) ||
      other is UploadFile &&
          runtimeType == other.runtimeType &&
          dosyaklasoru == other.dosyaklasoru &&
          dosyaadi == other.dosyaadi &&
          dosyaurl == other.dosyaurl &&
          ikonurl == other.ikonurl &&
          dosyauzantisi == other.dosyauzantisi &&
          mesajformat == other.mesajformat;
}
