import 'dart:convert';

import 'package:dio/dio.dart';
import 'package:dropdown_button2/dropdown_button2.dart';
import 'package:flutter/material.dart';
import 'package:flutter/services.dart';
import 'package:flutter_bloc/flutter_bloc.dart';
import 'package:flutter_cupertino_datetime_picker/flutter_cupertino_datetime_picker.dart';
import 'package:intl/intl.dart';
import 'package:hamlemuhcrm/core/extensions/log_extension.dart';
import '../../../data/dropdown_models/personal_getdata_api.dart';
import '../../../core/constants/url_services_constant.dart';
import '../constants/employee_constants.dart';
import '../cubit/employee_cubit.dart';
import '../../auth/login/cubit/login_cubit.dart';
import '../../../core/constants/font_styles.dart';
import '../../../core/extensions/responsive_extension.dart';

import '../../../core/constants/app_constants.dart';
import '../../../core/constants/color_constants.dart';
import '../../../core/utility/toast_manager.dart';
import '../constants/employee_textfield_input.dart';

class EmployeeAddPage extends StatefulWidget {
  const EmployeeAddPage({super.key});

  @override
  State<EmployeeAddPage> createState() => _EmployeeAddPageState();
}

class _EmployeeAddPageState extends State<EmployeeAddPage> {
  String cevrilmisTarih = "";
  final tfAd = TextEditingController();
  final tfSoyad = TextEditingController();
  final tfMail = TextEditingController();
  final tfSifre = TextEditingController();
  final tfCepTel = TextEditingController();
  final tfTCNo = TextEditingController();
  final tfAdres = TextEditingController();
  final _addEmployeeKey = GlobalKey<FormState>();
  String dbSaat = '';
  String gosterilenSaat = '';
  final Map<String, String> askerlikDD = {
    '-1': 'Muaf',
    '0': 'Yapılmadı',
    '1': 'Yapıldı',
  };
  String? secilenAskerlik = "1";

  //////////////////////////////////////////////////////////////////////////////
  var gelenUnvanlar;
  String? _secilenUnvan;
  String gonderilenUnvanID = "0";

  Future<void> unvanData(String token, String loginuserid) async {
    var unvanURL = "${URLAPIService.baseURL}/mobil/api/dd/unvan_dd_pdo.php";
    var veri = {"token": token, "loginuserid": loginuserid};
    var unvanlarCevap =
        await Dio().post(unvanURL, data: FormData.fromMap(veri));
    if (unvanlarCevap.statusCode == 200) {
      var data = json.decode(unvanlarCevap.data);
      // 'unvanlar' anahtarını kontrol edin ve boş olup olmadığını kontrol edin
      if (data != null &&
          data.containsKey('unvanlar') &&
          data['unvanlar'].isNotEmpty) {
        setState(() {
          gelenUnvanlar = data; // Veri uygun formatta ve boş değil
        });
      } else {
        setState(() {
          gelenUnvanlar = {
            "unvanlar": []
          }; // Boş bir listeyle güvenli bir şekilde başlat
        });
      }
    } else {}
  }

  Widget unvanDD() {
    List<UnvanDDModel> unvanListesi = List<UnvanDDModel>.from(
      gelenUnvanlar["unvanlar"].map(
        (i) {
          return UnvanDDModel.fromJSON(i);
        },
      ),
    );

    return DropdownButtonHideUnderline(
      child: DropdownButton2(
        hint: Text(
          "",
          style: FontStyles.instance.projectbxDdyazi,
        ), //Data1
        isExpanded: true,
        items: unvanListesi.map((unvan) {
          return DropdownMenuItem(
            value: unvan.unvanId,
            child: Text(unvan.unvanAd ?? '',
                style: FontStyles.instance.projectbxDdyazi), //value
          );
        }).toList(),
        value: _secilenUnvan,
        onChanged: (newValue) {
          setState(() {
            _secilenUnvan = newValue.toString();
            gonderilenUnvanID = _secilenUnvan!;
            "_secilen UnvanID == $_secilenUnvan".log();
          });
        },
        buttonStyleData: ButtonStyleData(
          height: context.dynamicHeight(0.053),
          padding: const EdgeInsets.only(right: 10),
          decoration: BoxDecoration(
            borderRadius: BorderRadius.circular(10),
            color: Colors.white,
            border: Border.all(color: Colors.grey.shade400),
          ),
          elevation: 0,
        ),
        iconStyleData: IconStyleData(
          icon: const Icon(
            Icons.keyboard_arrow_down_outlined, //ilk icon
          ),
          openMenuIcon: const Icon(
              Icons.keyboard_arrow_left_outlined), //açıldıktan sonraki icon
          iconSize: 23,
          iconEnabledColor: ColorsConstants.instance.baseTheme,
          iconDisabledColor: Colors.white,
        ),
        dropdownStyleData: DropdownStyleData(
          maxHeight: context.dynamicHeight(0.17),
          isOverButton: false,
          padding: null,
          decoration: BoxDecoration(
            borderRadius: BorderRadius.circular(10),
            color: ColorsConstants
                .instance.backgroundColor, //açılır menü arkaplan rengi
          ),
          elevation: 8,
          scrollbarTheme: ScrollbarThemeData(
            thumbColor: MaterialStateColor.resolveWith((states) =>
                ColorsConstants
                    .instance.baseTheme), //dropdown scroll rengi değiştirme
            radius: const Radius.circular(10),
            thickness: MaterialStateProperty.all<double>(6),
            thumbVisibility: MaterialStateProperty.all<bool>(true),
          ),
        ),
        menuItemStyleData: MenuItemStyleData(
          padding: EdgeInsets.only(left: context.dynamicWidth(0.03)),
          height: context.dynamicHeight(0.05),
        ),
      ),
    );
  }
//////////////////////////////////////////////////////////////////////////////

  bool isFinish = false;

  Future<void> unvanCek() async {
    isFinish = false;
    await unvanData(
        context.read<LoginCubit>().token, context.read<LoginCubit>().id);
    isFinish = true;
  }

  @override
  void initState() {
    unvanCek();
    super.initState();
  }

  void trTariheCevir(String tarih) async {
    final DateFormat format = DateFormat.yMd('tr');
    if (tarih != '0') {
      cevrilmisTarih = format.format(DateTime.parse(tarih));
    }
  }

  @override
  Widget build(BuildContext context) {
    return Scaffold(
      //resizeToAvoidBottomInset: false,
      appBar: appBar(context),
      body: isFinish
          ? SingleChildScrollView(
              child: Form(
                key: _addEmployeeKey,
                child: Padding(
                  padding: EdgeInsets.symmetric(
                      horizontal: context.dynamicWidth(0.05)),
                  child: Column(
                    children: [
                      //buildAvatar(),
                      _emptyHeightSpace,
                      _headLine('Adı', context),
                      _emptyHeightSpace,
                      Container(
                        height: context.dynamicHeight(0.05),
                        alignment: Alignment.center,
                        decoration: BoxDecoration(
                            color: Colors.white,
                            border: Border.all(color: Colors.grey.shade400),
                            borderRadius: BorderRadius.circular(10)),
                        child: TextFormField(
                            inputFormatters: [
                              LengthLimitingTextInputFormatter(25)
                            ],
                            style: FontStyles.instance.projectbxDdyazi,
                            magnifierConfiguration:
                                TextMagnifierConfiguration.disabled,
                            validator: (value) {
                              if (value!.isEmpty ||
                                  !RegExp(r"^[a-zA-Z]+(([',. -][a-zA-Z ])?[a-zA-Z]*)*$")
                                      .hasMatch(value)) {
                                tfAd.text = 'geçersiz';
                                ScaffoldMessenger.of(context).showSnackBar(
                                  SnackBar(
                                    backgroundColor: ColorsConstants
                                        .instance.backgroundColor,
                                    content: const Text(
                                      'Geçerli bir isim girin..',
                                    ),
                                    behavior: SnackBarBehavior.floating,
                                    action: SnackBarAction(
                                      label: "Tamam",
                                      textColor: Colors.white,
                                      onPressed: () {},
                                    ),
                                  ),
                                );
                              }
                              return null;
                            },
                            textInputAction: TextInputAction.done,
                            cursorColor: ColorsConstants.instance.baseTheme,
                            controller: tfAd,
                            decoration: EmployeeTextFieldInput(
                                context,
                                EmployeeConstants
                                    .employeeAddPageLastNameHintTxt)),
                      ),
                      _emptyHeightSpace,
                      _headLine('Soyadı', context),
                      _emptyHeightSpace,
                      Container(
                        height: context.dynamicHeight(0.05),
                        alignment: Alignment.center,
                        decoration: BoxDecoration(
                            color: Colors.white,
                            border: Border.all(color: Colors.grey.shade400),
                            borderRadius: BorderRadius.circular(10)),
                        child: TextFormField(
                          inputFormatters: [
                            LengthLimitingTextInputFormatter(20)
                          ],
                          style: FontStyles.instance.projectbxDdyazi,
                          magnifierConfiguration:
                              TextMagnifierConfiguration.disabled,
                          validator: (value) {
                            if (value!.isEmpty ||
                                !RegExp(r"^[a-zA-Z]+(([',. -][a-zA-Z ])?[a-zA-Z]*)*$")
                                    .hasMatch(value)) {
                              tfSoyad.text = 'geçersiz';
                              ScaffoldMessenger.of(context).showSnackBar(
                                SnackBar(
                                  backgroundColor:
                                      ColorsConstants.instance.backgroundColor,
                                  content: const Text(
                                    'Geçerli bir soyisim girin..',
                                  ),
                                  behavior: SnackBarBehavior.floating,
                                  action: SnackBarAction(
                                    label: "Tamam",
                                    textColor: Colors.white,
                                    onPressed: () {},
                                  ),
                                ),
                              );
                            }
                            return null;
                          },
                          textInputAction: TextInputAction.done,
                          cursorColor: ColorsConstants.instance.baseTheme,
                          controller: tfSoyad,
                          decoration: EmployeeTextFieldInput(context,
                              EmployeeConstants.employeeAddPageSurnameHintTxt),
                        ),
                      ),
                      _emptyHeightSpace,
                      _headLine('Mail Adresi', context),
                      _emptyHeightSpace,
                      Container(
                        height: context.dynamicHeight(0.05),
                        alignment: Alignment.center,
                        decoration: BoxDecoration(
                            color: Colors.white,
                            border: Border.all(color: Colors.grey.shade400),
                            borderRadius: BorderRadius.circular(10)),
                        child: TextFormField(
                          magnifierConfiguration:
                              TextMagnifierConfiguration.disabled,
                          validator: (value) {
                            if (value!.isEmpty ||
                                !RegExp(r"^[a-zA-Z0-9.a-zA-Z0-9.!#$%&'*+-/=?^_`{|}~]+@[a-zA-Z0-9]+\.[a-zA-Z]+")
                                    .hasMatch(value)) {
                              tfMail.text = 'geçersiz';
                              ScaffoldMessenger.of(context).showSnackBar(
                                SnackBar(
                                  backgroundColor:
                                      ColorsConstants.instance.backgroundColor,
                                  content: const Text(
                                    'Geçerli bir mail adresi girin..',
                                  ),
                                  behavior: SnackBarBehavior.floating,
                                  action: SnackBarAction(
                                    label: "Tamam",
                                    textColor: Colors.white,
                                    onPressed: () {},
                                  ),
                                ),
                              );
                            }
                            return null;
                          },
                          inputFormatters: [
                            LengthLimitingTextInputFormatter(50)
                          ],
                          style: FontStyles.instance.employeebxDdyazi,
                          textInputAction: TextInputAction.done,
                          cursorColor: ColorsConstants.instance.baseTheme,
                          controller: tfMail,
                          decoration: EmployeeTextFieldInput(context,
                              EmployeeConstants.employeeAddPageMailHintTxt),
                        ),
                      ),
                      _emptyHeightSpace,
                      _headLine('Şifre', context),
                      _emptyHeightSpace,
                      Container(
                        height: context.dynamicHeight(0.05),
                        width: context.dynamicWidth(1),
                        alignment: Alignment.center,
                        decoration: BoxDecoration(
                            color: Colors.white,
                            border: Border.all(color: Colors.grey.shade400),
                            borderRadius: BorderRadius.circular(10)),
                        child: TextFormField(
                          obscureText: true,
                          magnifierConfiguration:
                              TextMagnifierConfiguration.disabled,
                          validator: (value) {
                            if (value!.isEmpty || value.length < 4) {
                              tfSifre.text = 'geçersiz';
                              ScaffoldMessenger.of(context).showSnackBar(
                                SnackBar(
                                  backgroundColor:
                                      ColorsConstants.instance.backgroundColor,
                                  content: const Text(
                                    'Geçerli bir sifre girin..',
                                  ),
                                  behavior: SnackBarBehavior.floating,
                                  action: SnackBarAction(
                                    label: "Tamam",
                                    textColor: Colors.white,
                                    onPressed: () {},
                                  ),
                                ),
                              );
                            }
                            return null;
                          },
                          inputFormatters: [
                            LengthLimitingTextInputFormatter(50)
                          ],
                          style: FontStyles.instance.employeebxDdyazi,
                          textInputAction: TextInputAction.done,
                          cursorColor: ColorsConstants.instance.baseTheme,
                          controller: tfSifre,
                          decoration: EmployeeTextFieldInput(context,
                              EmployeeConstants.employeeAddPagePasswordHintTxt),
                        ),
                      ),
                      _emptyHeightSpace,
                      _headLine('Ünvan', context),
                      _emptyHeightSpace,
                      unvanDD(),
                      _emptyHeightSpace,
                      _headLine('Cep Telefonu', context),
                      _emptyHeightSpace,
                      Container(
                        height: context.dynamicHeight(0.05),
                        width: context.dynamicWidth(1),
                        alignment: Alignment.center,
                        decoration: BoxDecoration(
                            color: Colors.white,
                            border: Border.all(color: Colors.grey.shade400),
                            borderRadius: BorderRadius.circular(10)),
                        child: TextFormField(
                          magnifierConfiguration:
                              TextMagnifierConfiguration.disabled,
                          validator: (value) {
                            if (value!.isEmpty ||
                                !RegExp(r'^\s*(?:\+?(\d{1,3}))?[-. (]*(\d{3})[-. )]*(\d{3})[-. ]*(\d{4})(?: *x(\d+))?\s*$')
                                    .hasMatch(value) ||
                                value.length != 11) {
                              tfCepTel.text = 'geçersiz';
                              ScaffoldMessenger.of(context).showSnackBar(
                                SnackBar(
                                  backgroundColor:
                                      ColorsConstants.instance.backgroundColor,
                                  content: const Text(
                                    'Geçerli bir telefon numarası girin..',
                                  ),
                                  behavior: SnackBarBehavior.floating,
                                  action: SnackBarAction(
                                    label: "Tamam",
                                    textColor: Colors.white,
                                    onPressed: () {},
                                  ),
                                ),
                              );
                            }
                            return null;
                          },
                          inputFormatters: [
                            LengthLimitingTextInputFormatter(11)
                          ],
                          style: FontStyles.instance.employeebxDdyazi,
                          textInputAction: TextInputAction.done,
                          cursorColor: ColorsConstants.instance.baseTheme,
                          controller: tfCepTel,
                          decoration: EmployeeTextFieldInput(
                              context,
                              EmployeeConstants
                                  .employeeAddPageTelephoneHintTxt),
                        ),
                      ),
                      _emptyHeightSpace,
                      _headLine('TC No', context),
                      _emptyHeightSpace,
                      Container(
                        height: context.dynamicHeight(0.05),
                        alignment: Alignment.center,
                        decoration: BoxDecoration(
                            color: Colors.white,
                            border: Border.all(color: Colors.grey.shade400),
                            borderRadius: BorderRadius.circular(10)),
                        child: TextFormField(
                          magnifierConfiguration:
                              TextMagnifierConfiguration.disabled,
                          validator: (value) {
                            if (value!.isEmpty ||
                                !RegExp(r'^\s*(?:\+?(\d{1,3}))?[-. (]*(\d{3})[-. )]*(\d{3})[-. ]*(\d{4})(?: *x(\d+))?\s*$')
                                    .hasMatch(value) ||
                                value.length != 11) {
                              tfTCNo.text = 'geçersiz';
                              ScaffoldMessenger.of(context).showSnackBar(
                                SnackBar(
                                  backgroundColor:
                                      ColorsConstants.instance.backgroundColor,
                                  content: const Text(
                                    'Geçerli bir tc no girin..',
                                  ),
                                  behavior: SnackBarBehavior.floating,
                                  action: SnackBarAction(
                                    label: "Tamam",
                                    textColor: Colors.white,
                                    onPressed: () {},
                                  ),
                                ),
                              );
                            }
                            return null;
                          },
                          inputFormatters: [
                            LengthLimitingTextInputFormatter(11)
                          ],
                          style: FontStyles.instance.employeebxDdyazi,
                          textInputAction: TextInputAction.done,
                          cursorColor: ColorsConstants.instance.baseTheme,
                          controller: tfTCNo,
                          decoration: EmployeeTextFieldInput(
                              context, '11 haneyi girin..'),
                        ),
                      ),
                      _emptyHeightSpace,
                      Row(
                        mainAxisAlignment: MainAxisAlignment.spaceBetween,
                        children: [
                          Column(
                            crossAxisAlignment: CrossAxisAlignment.start,
                            children: [
                              _headLine('İşe Giriş Tarihi', context),
                              SizedBox(
                                height: context.dynamicHeight(0.01),
                              ),
                              Container(
                                  height: context.dynamicHeight(0.05),
                                  width: context.dynamicWidth(0.42),
                                  alignment: Alignment.center,
                                  decoration: BoxDecoration(
                                    borderRadius: BorderRadius.circular(10),
                                    color: Colors.white,
                                    border:
                                        Border.all(color: Colors.grey.shade400),
                                  ),
                                  child: Row(
                                    children: [
                                      const SizedBox(width: 10),
                                      Text(
                                        gosterilenSaat,
                                        style:
                                            FontStyles.instance.employeetbxYazi,
                                      ),
                                      const Spacer(),
                                      IconButton(
                                          onPressed: () {
                                            dateTimePickerWidget(context);
                                          },
                                          padding: EdgeInsets.zero,
                                          tooltip: 'Tarih Seç',
                                          icon: Icon(
                                            Icons.calendar_month_outlined,
                                            size: 23,
                                            color: ColorsConstants
                                                .instance.baseTheme,
                                          )),
                                    ],
                                  )), //buraya işe başlama tarihi gelecek.
                            ],
                          ),
                          Column(
                            crossAxisAlignment: CrossAxisAlignment.start,
                            children: [
                              _headLine('Askerlik Durumu', context),
                              SizedBox(
                                height: context.dynamicHeight(0.01),
                              ),
                              //buraya askerlik durumu dropdown gelecek..
                              DropdownButtonHideUnderline(
                                child: DropdownButton2(
                                  isExpanded: true,
                                  value: secilenAskerlik,
                                  items: askerlikDD.entries
                                      .map((entry) => DropdownMenuItem<String>(
                                            value: entry.key,
                                            child: Text(
                                              entry.value,
                                              style: FontStyles
                                                  .instance.employeetbxYazi,
                                            ),
                                          ))
                                      .toList(),
                                  onChanged: (value) {
                                    secilenAskerlik = value;
                                    setState(() {
                                      //context.read<CustomersCubit>().secilenGorusmeTipi = selectedValue!;
                                    });
                                    'Seçilen Deger DD : $value'.log();
                                  },
                                  buttonStyleData: ButtonStyleData(
                                    height: context.dynamicHeight(0.05),
                                    width: context.dynamicWidth(0.42),
                                    padding: const EdgeInsets.symmetric(
                                        horizontal: 10),
                                    decoration: BoxDecoration(
                                        borderRadius: BorderRadius.circular(10),
                                        color: Colors.white,
                                        border:
                                            Border.all(color: Colors.black26)),
                                    elevation: 0,
                                  ),
                                  iconStyleData: IconStyleData(
                                    icon: const Icon(
                                      Icons
                                          .keyboard_arrow_down_outlined, //ilk icon
                                    ),
                                    openMenuIcon: const Icon(Icons
                                        .keyboard_arrow_left_outlined), //açıldıktan sonraki icon
                                    iconSize: 23,
                                    iconEnabledColor:
                                        ColorsConstants.instance.baseTheme,
                                    iconDisabledColor: Colors.white,
                                  ),
                                  dropdownStyleData: DropdownStyleData(
                                    maxHeight: context.dynamicHeight(0.17),
                                    isOverButton: false,
                                    width: context.dynamicWidth(0.38),
                                    padding: null,
                                    decoration: BoxDecoration(
                                      borderRadius: BorderRadius.circular(10),
                                      color: ColorsConstants.instance
                                          .backgroundColor, //açılır menü arkaplan rengi
                                    ),
                                    elevation: 8,
                                    offset: const Offset(0, 0),
                                    scrollbarTheme: ScrollbarThemeData(
                                      thumbColor: MaterialStateColor.resolveWith(
                                          (states) => ColorsConstants.instance
                                              .baseTheme), //dropdown scroll rengi değiştirme
                                      radius: const Radius.circular(10),
                                      thickness:
                                          MaterialStateProperty.all<double>(6),
                                      thumbVisibility:
                                          MaterialStateProperty.all<bool>(true),
                                    ),
                                  ),
                                  menuItemStyleData: const MenuItemStyleData(
                                    height: 35,
                                    padding:
                                        EdgeInsets.symmetric(horizontal: 14),
                                  ),
                                ),
                              ),
                            ],
                          ),
                        ],
                      ),
                      _emptyHeightSpace,
                      _headLine('Adres', context),
                      _emptyHeightSpace,
                      Container(
                        height: context.dynamicHeight(0.15),
                        width: context.dynamicWidth(1),
                        padding: const EdgeInsets.symmetric(horizontal: 4),
                        alignment: Alignment.center,
                        decoration: BoxDecoration(
                            color: Colors.white,
                            border: Border.all(color: Colors.grey.shade400),
                            borderRadius: BorderRadius.circular(10)),
                        child: TextFormField(
                          inputFormatters: [
                            LengthLimitingTextInputFormatter(100)
                          ],
                          textInputAction: TextInputAction.next,
                          maxLines: 5,
                          style: FontStyles.instance.employeetbxYazi,
                          cursorColor: ColorsConstants.instance.baseTheme,
                          controller: tfAdres,
                          decoration:
                              const InputDecoration(border: InputBorder.none),
                        ),
                      ),
                      _emptyHeightSpace,
                      _headLine('Dosya', context, isRequired: false),
                      _emptyHeightSpace,
                      Container(
                          height: context.dynamicHeight(0.15),
                          padding: const EdgeInsets.all(10),
                          decoration: BoxDecoration(
                              color: Colors.white,
                              border: Border.all(color: Colors.grey.shade400),
                              borderRadius: BorderRadius.circular(10)),
                          child: const Row(
                            mainAxisAlignment: MainAxisAlignment.spaceEvenly,
                            children: [
                              Icon(
                                Icons.post_add_outlined,
                                size: 40,
                                color: Colors.grey,
                              ),
                              Text(
                                'Dosya yüklemek için buraya tıklayın.\nDosya formatı PDF,PNG,JPG, GIF en \nfazla 10MB.',
                                style: TextStyle(
                                    color: Colors.grey,
                                    fontSize: 11,
                                    letterSpacing: 0.5),
                                textAlign: TextAlign.left,
                              ),
                            ],
                          )),
                      _emptyHeightSpace,
                      _employeeAddButton,
                      SizedBox(
                        height: context.dynamicHeight(0.05),
                      ),
                    ],
                  ),
                ),
              ),
            )
          : _isLoadingBar,
    );
  }

  Widget get _emptyHeightSpace => SizedBox(
        height: context.dynamicHeight(0.016),
      );

  AppBar appBar(BuildContext context) {
    return AppBar(
        backgroundColor: Colors.transparent,
        elevation: 0,
        title: Text(EmployeeConstants.employeeAddPageTitleTxt,
            style: FontStyles.instance.appbarTitleStyle),
        centerTitle: true,
        actions: [
          IconButton(
              onPressed: () {},
              icon: const Icon(
                Icons.notifications_none_outlined,
                color: Colors.black,
              )),
        ],
        leading: IconButton(
          onPressed: () {
            FocusScope.of(context).unfocus();
            Navigator.pop(context);
          },
          icon: const Icon(
            Icons.arrow_back_ios_new,
            color: Colors.black87,
          ),
        ));
  }

  Widget get _employeeAddButton => Row(
        mainAxisAlignment: MainAxisAlignment.end,
        children: [
          SizedBox(
            height: context.dynamicHeight(0.05),
            width: context.dynamicWidth(0.25),
            child: TextButton(
              onPressed: () {
                if (dbSaat == '') {
                  ToastManager.instance
                      .toastMessageService('İşe Giriş Tarihi Seçin');
                }
                if (tfAdres.text == '') {
                  ToastManager.instance.toastMessageService('Adres Girin');
                }
                if (tfAd.text != 'geçersiz' &&
                    tfAd.text != '' &&
                    tfSoyad.text != 'geçersiz' &&
                    tfSoyad.text != '' &&
                    tfMail.text != 'geçersiz' &&
                    tfMail.text != '' &&
                    tfSifre.text != 'geçersiz' &&
                    tfSifre.text != '' &&
                    tfCepTel.text != 'geçersiz' &&
                    tfCepTel.text != '' &&
                    tfTCNo.text != 'geçersiz' &&
                    tfTCNo.text != '' &&
                    tfAdres.text != 'geçersiz' &&
                    tfAdres.text != '' &&
                    dbSaat != '') {
                  context.read<EmployeeCubit>().personelEkle(
                      context.read<LoginCubit>().userfirmId,
                      tfAd.text,
                      tfSoyad.text,
                      tfMail.text,
                      tfSifre.text,
                      tfCepTel.text,
                      tfAdres.text,
                      dbSaat,
                      tfTCNo.text,
                      secilenAskerlik!,
                      gonderilenUnvanID,
                      context.read<LoginCubit>().token,
                      context.read<LoginCubit>().id,
                      context.read<LoginCubit>().tip);
                  ToastManager.instance.toastMessageService('Personel Eklendi');
                  context
                      .read<EmployeeCubit>()
                      .personelListele(
                          context.read<LoginCubit>().userfirmId,
                          context.read<LoginCubit>().token,
                          context.read<LoginCubit>().id)
                      .whenComplete(() {
                    Future.delayed(const Duration(seconds: 2), () {
                      Navigator.pushNamed(context, '/');
                    });
                  });
                } else {
                  ToastManager.instance
                      .toastMessageService('Personel Eklenemedi!');
                }
              },
              style: TextButton.styleFrom(
                backgroundColor: ColorsConstants.instance.baseTheme,
                shape: RoundedRectangleBorder(
                  borderRadius: BorderRadius.circular(10),
                ),
              ),
              child: Text(
                ApplicationConstants.instance.moduleSaveTxt,
                style: const TextStyle(color: Colors.white),
              ),
            ),
          ),
        ],
      );

  Widget buildAvatar() {
    return SizedBox(
      height: context.dynamicHeight(0.18),
      width: context.dynamicWidth(0.38), //üst kısım sayfada kapladığı genişlik
      child: Stack(children: [
        Container(
          height: context.dynamicHeight(0.2),
          decoration: BoxDecoration(
              color: Colors.grey.shade400,
              shape: BoxShape.circle,
              border: Border.all(color: ColorsConstants.instance.baseTheme)),
          child: Container(
            alignment: Alignment.center,
            decoration: BoxDecoration(
                shape: BoxShape.circle,
                border: Border.all(
                    color: ColorsConstants.instance.baseTheme, width: 3)),
          ),
        ),
        Positioned(
          bottom: 0,
          right: 4,
          child: Container(
            height: 30,
            width: 30,
            decoration: BoxDecoration(
              color: ColorsConstants.instance.baseTheme,
              shape: BoxShape.circle,
            ),
            child: IconButton(
              padding: const EdgeInsets.all(0),
              icon: const Icon(
                Icons.add_a_photo_rounded,
                color: Colors.white,
                size: 14,
              ),
              onPressed: () {
                setState(() {});
              },
            ),
          ),
        ),
      ]),
    );
  }

  dateTimePickerWidget(BuildContext context) {
    return DatePicker.showDatePicker(
      context,
      dateFormat: 'dd/MM/yyyy',
      locale: DateTimePickerLocale.tr,
      initialDateTime: DateTime.now(),
      minDateTime: DateTime(2005),
      maxDateTime: DateTime(2100),
      pickerTheme: DateTimePickerTheme(
        backgroundColor: ColorsConstants.instance.backgroundColor,
        confirm: Text(
          'Yeni Tarih Seç',
          style: TextStyle(color: ColorsConstants.instance.baseTheme),
        ),
      ),
      onMonthChangeStartWithFirstDate: true,
      onConfirm: (dateTime, List<int> index) {
        DateTime selectdate = dateTime;
        final selIOS = DateFormat('yyyy-MM-dd HH:mm').format(selectdate);
        setState(() {
          dbSaat = '$selIOS:00';
          gosterilenSaat = dbSaat.substring(0, 16);
          final DateFormat format = DateFormat.yMd('tr');
          var trTarih = format.format(DateTime.parse(gosterilenSaat));
          gosterilenSaat = trTarih;
          dbSaat.log();
          gosterilenSaat.log();
        });
      },
    );
  }
}

Widget _headLine(String headline, BuildContext context,
    {bool isRequired = true}) {
  return Row(
    children: [
      Text(
        headline,
        style: TextStyle(
            color: ColorsConstants.instance.baseTheme,
            fontSize: 11,
            fontWeight: FontWeight.w500),
      ),
      isRequired
          ? Row(
              children: [
                SizedBox(
                  width: context.dynamicWidth(0.01),
                ),
                Text(
                  '(zorunlu)',
                  style: FontStyles.instance.employeetbxRequired,
                )
              ],
            )
          : const SizedBox.shrink()
    ],
  );
}

Widget get _isLoadingBar => const Center(
      child: CircularProgressIndicator(),
    );
