import 'package:flutter/material.dart';
import 'package:flutter/services.dart';
import 'package:flutter_bloc/flutter_bloc.dart';
import 'package:hamlemuhcrm/core/widgets/user_type_widget.dart';
import 'package:hamlemuhcrm/features/home/cubit/home_custom_cubit.dart';
import 'package:hamlemuhcrm/features/auth/login/cubit/login_cubit.dart';
import 'package:hamlemuhcrm/features/auth/login/view/login_view.dart';
import 'package:hamlemuhcrm/core/extensions/responsive_extension.dart';

import '../../../core/constants/app_constants.dart';
import '../../../core/constants/color_constants.dart';

class DrawerMenu extends StatefulWidget {
  const DrawerMenu({super.key});

  @override
  State<DrawerMenu> createState() => _DrawerMenuState();
}

class _DrawerMenuState extends State<DrawerMenu> {
  @override
  Widget build(BuildContext context) {
    final textTheme = Theme.of(context).textTheme;
    return Column(
      children: [
        ListTile(
          title: Text(ApplicationConstants.instance.homePageTxt,
              style: textTheme.bodyMedium),
          leading: Container(
            height: context.dynamicWidth(0.07),
            width: context.dynamicWidth(0.07),
            decoration: BoxDecoration(
              borderRadius: BorderRadius.circular(6),
              color: ColorsConstants.instance.baseTheme.withOpacity(0.25),
            ),
            child: const Icon(Icons.home_filled, color: Colors.black38),
          ),
          onTap: () {
            context
                .read<HomeCustomCubit>()
                .setSecilenBodyIndeks(0); //Anasayfa Modülü
            Navigator.pop(context);
          },
        ),
        ListTile(
          title: Text(ApplicationConstants.instance.projectModuleTxt,
              style: textTheme.bodyMedium),
          leading: Container(
            height: context.dynamicWidth(0.07),
            width: context.dynamicWidth(0.07),
            decoration: BoxDecoration(
              borderRadius: BorderRadius.circular(6),
              color: ColorsConstants.instance.baseTheme.withOpacity(0.25),
            ),
            child: const Icon(Icons.checklist_rounded, color: Colors.black38),
          ),
          onTap: () {
            context
                .read<HomeCustomCubit>()
                .setSecilenBodyIndeks(1); //Projeler Modülü
            Navigator.pop(context);
          },
        ),
        ListTile(
          title: Text(ApplicationConstants.instance.calendarModuleTxt,
              style: textTheme.bodyMedium),
          leading: Container(
            height: context.dynamicWidth(0.07),
            width: context.dynamicWidth(0.07),
            decoration: BoxDecoration(
              borderRadius: BorderRadius.circular(6),
              color: ColorsConstants.instance.baseTheme.withOpacity(0.25),
            ),
            child: const Icon(Icons.calendar_month_outlined,
                color: Colors.black38),
          ),
          onTap: () {
            context
                .read<HomeCustomCubit>()
                .setSecilenBodyIndeks(2); //Toplantılar Modülü
            Navigator.pop(context);
          },
        ),
        ListTile(
          title: Text(ApplicationConstants.instance.customersModuleTxt,
              style: textTheme.bodyMedium),
          leading: Container(
            height: context.dynamicWidth(0.07),
            width: context.dynamicWidth(0.07),
            decoration: BoxDecoration(
              borderRadius: BorderRadius.circular(6),
              color: ColorsConstants.instance.baseTheme.withOpacity(0.25),
            ),
            child: const Icon(Icons.people_alt_outlined, color: Colors.black38),
          ),
          onTap: () {
            context
                .read<HomeCustomCubit>()
                .setSecilenBodyIndeks(3); //Müşteriler & Aktiviteler Modülü
            Navigator.pop(context);
          },
        ),
        ListTile(
          title: Text(ApplicationConstants.instance.profilePageTxt,
              style: textTheme.bodyMedium),
          leading: Container(
              height: context.dynamicWidth(0.07),
              width: context.dynamicWidth(0.07),
              decoration: BoxDecoration(
                borderRadius: BorderRadius.circular(6),
                color: ColorsConstants.instance.baseTheme.withOpacity(0.25),
              ),
              child: const Icon(Icons.account_circle_rounded,
                  color: Colors.black38)),
          onTap: () {
            context
                .read<HomeCustomCubit>()
                .setSecilenBodyIndeks(4); //Profil Yönetimi Modülü
            Navigator.pop(context);
          },
        ),
        ListTile(
          title: Text(ApplicationConstants.instance.humanResourcesModuleTxt,
              style: textTheme.bodyMedium),
          leading: Container(
            height: context.dynamicWidth(0.07),
            width: context.dynamicWidth(0.07),
            decoration: BoxDecoration(
              borderRadius: BorderRadius.circular(6),
              color: ColorsConstants.instance.baseTheme.withOpacity(0.25),
            ),
            child: const Icon(Icons.note_alt_outlined, color: Colors.black38),
          ),
          onTap: () {
            context
                .read<HomeCustomCubit>()
                .setSecilenBodyIndeks(5); //Personel Yönetimi Modülü
            Navigator.pop(context);
          },
        ),
        ListTile(
          title: Text(ApplicationConstants.instance.messageModuleTxt,
              style: textTheme.bodyMedium),
          leading: Container(
            height: context.dynamicWidth(0.07),
            width: context.dynamicWidth(0.07),
            decoration: BoxDecoration(
              borderRadius: BorderRadius.circular(6),
              color: ColorsConstants.instance.baseTheme.withOpacity(0.25),
            ),
            child: const Icon(Icons.message_outlined, color: Colors.black38),
          ),
          onTap: () {
            context
                .read<HomeCustomCubit>()
                .setSecilenBodyIndeks(7); //Mesajlar Modülü
            Navigator.pop(context);
          },
        ),
        ListTile(
          title: Text(ApplicationConstants.instance.signoutSessionTxt,
              style: textTheme.bodyMedium),
          leading: Container(
            height: context.dynamicWidth(0.07),
            width: context.dynamicWidth(0.07),
            decoration: BoxDecoration(
              borderRadius: BorderRadius.circular(6),
              color: ColorsConstants.instance.baseTheme.withOpacity(0.25),
            ),
            child: const Icon(Icons.exit_to_app, color: Colors.black38),
          ),
          onTap: () {
            showDialog(
                context: context,
                builder: (context) {
                  return AlertDialog(
                    shape: const RoundedRectangleBorder(
                        borderRadius: BorderRadius.all(Radius.circular(15))),
                    content: SizedBox(
                      height: context.dynamicHeight(0.15),
                      width: context.dynamicWidth(0.65),
                      child: Column(
                        children: [
                          Icon(
                            Icons.person_remove_alt_1_outlined,
                            color: ColorsConstants.instance.baseTheme,
                            size: 20,
                          ),
                          const Divider(
                            color: Colors.grey,
                          ),
                          const Spacer(),
                          const Text(
                            'Mevcut oturumdan çıkılsın mı ?',
                            textAlign: TextAlign.center,
                          )
                        ],
                      ),
                    ),
                    actions: [
                      Row(
                        mainAxisAlignment: MainAxisAlignment.center,
                        children: [
                          SizedBox(
                            height: context.dynamicHeight(0.05),
                            width: context.dynamicWidth(0.25),
                            child: TextButton(
                              onPressed: () {
                                Navigator.pop(context);
                              },
                              style: TextButton.styleFrom(
                                backgroundColor: Colors.grey.shade300,
                                side: BorderSide(
                                    color: Colors.black.withOpacity(0.3)),
                              ),
                              child: Text(
                                'İptal',
                                style: TextStyle(color: Colors.orange.shade900),
                              ),
                            ),
                          ),
                          SizedBox(
                            width: context.dynamicWidth(0.05),
                          ),
                          SizedBox(
                            height: context.dynamicHeight(0.05),
                            width: context.dynamicWidth(0.25),
                            child: TextButton(
                              onPressed: () {
                                context
                                    .read<LoginCubit>()
                                    .kayitliBilgileriSil()
                                    .whenComplete(() => Navigator.of(context)
                                        .pushAndRemoveUntil(
                                            MaterialPageRoute(
                                                builder: (context) =>
                                                    const LoginView()),
                                            (route) => false));
                              },
                              style: TextButton.styleFrom(
                                  backgroundColor: Colors.orange.shade900,
                                  side: BorderSide(
                                      color: Colors.black.withOpacity(0.3))),
                              child: const Text(
                                'Kapat',
                                style: TextStyle(color: Colors.white),
                              ),
                            ),
                          ),
                        ],
                      ),
                      SizedBox(
                        height: context.dynamicHeight(0.04),
                      ),
                    ],
                  );
                });
          },
        ),
        ListTile(
          title: Text(ApplicationConstants.instance.closeAppTxt,
              style: textTheme.bodyMedium),
          leading: Container(
            height: context.dynamicWidth(0.07),
            width: context.dynamicWidth(0.07),
            decoration: BoxDecoration(
              borderRadius: BorderRadius.circular(6),
              color: ColorsConstants.instance.baseTheme.withOpacity(0.25),
            ),
            child: Icon(Icons.power_settings_new_rounded,
                color: Colors.red.shade500),
          ),
          onTap: exitToAppShowDialog,
        ),
        const Divider(),
        UserTypeChip(isAdmin: context.read<LoginCubit>().tip == "1"),
      ],
    );
  }

  void exitToAppShowDialog() {
    showDialog<void>(
        context: context,
        builder: (context) {
          return AlertDialog(
            shape: const RoundedRectangleBorder(
                borderRadius: BorderRadius.all(Radius.circular(15))),
            content: SizedBox(
              height: context.dynamicHeight(0.15),
              width: context.dynamicWidth(0.65),
              child: Column(
                children: [
                  Icon(
                    Icons.power_settings_new_rounded,
                    color: ColorsConstants.instance.baseTheme,
                    size: 20,
                  ),
                  const Divider(
                    color: Colors.grey,
                  ),
                  const Spacer(),
                  const Text(
                    'Uygulamadan çıkmak istediğinize emin misiniz ?',
                    textAlign: TextAlign.center,
                  )
                ],
              ),
            ),
            actions: [
              Row(
                mainAxisAlignment: MainAxisAlignment.center,
                children: [
                  SizedBox(
                    height: context.dynamicHeight(0.05),
                    width: context.dynamicWidth(0.25),
                    child: TextButton(
                      onPressed: () {
                        Navigator.pop(context);
                      },
                      style: TextButton.styleFrom(
                        backgroundColor: Colors.grey.shade300,
                        side: BorderSide(color: Colors.black.withOpacity(0.3)),
                      ),
                      child: Text(
                        'İptal',
                        style: TextStyle(color: Colors.orange.shade900),
                      ),
                    ),
                  ),
                  SizedBox(
                    width: context.dynamicWidth(0.05),
                  ),
                  SizedBox(
                    height: context.dynamicHeight(0.05),
                    width: context.dynamicWidth(0.25),
                    child: TextButton(
                      onPressed: () {
                        SystemNavigator.pop();
                      },
                      style: TextButton.styleFrom(
                          backgroundColor: Colors.orange.shade900,
                          side:
                              BorderSide(color: Colors.black.withOpacity(0.3))),
                      child: const Text(
                        'Çıkış Yap',
                        style: TextStyle(color: Colors.white),
                      ),
                    ),
                  ),
                ],
              ),
              SizedBox(
                height: context.dynamicHeight(0.04),
              ),
            ],
          );
        });
  }
}
