import 'package:flutter/material.dart';
import 'package:flutter_bloc/flutter_bloc.dart';

import '../../../core/constants/color_constants.dart';
import '../cubit/home_custom_cubit.dart';

class CustomBottomNavigationBar extends StatefulWidget {
  final bool isBottomBar;
  final int currentIndex;

  const CustomBottomNavigationBar(
      {super.key, required this.isBottomBar, required this.currentIndex});
  @override
  State<CustomBottomNavigationBar> createState() =>
      _CustomBottomNavigationBarState();
}

class _CustomBottomNavigationBarState extends State<CustomBottomNavigationBar> {
  final List<BottomNavigationBarItem> listItems = [
    const BottomNavigationBarItem(
        icon: Icon(
          Icons.home_filled,
          size: 25,
        ),
        label: ''),
    const BottomNavigationBarItem(
        icon: Icon(
          Icons.checklist_rounded,
          size: 25,
        ),
        label: ''),
    const BottomNavigationBarItem(
        icon: Icon(
          Icons.calendar_month_outlined,
          size: 25,
        ),
        label: ''),
    const BottomNavigationBarItem(
        icon: Icon(
          Icons.people_alt_outlined,
          size: 25,
        ),
        label: ''),
  ];

  @override
  Widget build(BuildContext context) {
    final colorTheme = Theme.of(context).colorScheme;
    return BottomNavigationBar(
      type: BottomNavigationBarType.fixed,
      showSelectedLabels: false,
      showUnselectedLabels: false,
      items: listItems,
      currentIndex: widget.currentIndex,
      selectedItemColor: ColorsConstants.instance.baseTheme,
      unselectedItemColor: colorTheme.outlineVariant,
      onTap: (indeks) => bottomOnTap(context, indeks),
    );
  }

  void bottomOnTap(BuildContext context, int selectedIndex) {
    context.read<HomeCustomCubit>().cubitSecilenIndeks = selectedIndex;
    context.read<HomeCustomCubit>().setSecilenBodyIndeks(selectedIndex);
  }
}
