import 'package:flutter/material.dart';
import 'package:flutter/services.dart';
import 'package:hamlemuhcrm/core/extensions/responsive_extension.dart';

class MailTextField extends StatefulWidget {
  final String aciklama;
  final double yukseklik;
  final int satirSayisi;
  final bool kenarlik;
  final bool golge;
  final Color arkaplanRengi;
  final bool tekSatirMi;
  final TextEditingController textEditingController;
  final int kisitlama;

  const MailTextField(
      {super.key,
      required this.aciklama,
      required this.yukseklik,
      required this.satirSayisi,
      required this.kenarlik,
      required this.golge,
      required this.arkaplanRengi,
      required this.tekSatirMi,
      required this.textEditingController,
      required this.kisitlama});

  @override
  State<MailTextField> createState() => _MailTextFieldState();
}

class _MailTextFieldState extends State<MailTextField> {
  @override
  Widget build(BuildContext context) {
    return Container(
      height: widget.yukseklik,
      padding: widget.tekSatirMi
          ? const EdgeInsets.symmetric(horizontal: 8)
          : const EdgeInsets.symmetric(horizontal: 8),
      alignment: Alignment.center,
      decoration: BoxDecoration(
          color: widget.arkaplanRengi,
          borderRadius: BorderRadius.circular(10),
          border: widget.kenarlik
              ? Border.all(color: Colors.grey.withOpacity(0.2), width: 1.1)
              : Border.all(color: Colors.transparent),
          boxShadow: [
            BoxShadow(
                color: widget.golge
                    ? Colors.grey.withOpacity(0.22)
                    : Colors.transparent,
                blurRadius: 4,
                offset: const Offset(0, 4))
          ]),
      child: TextFormField(
        controller: widget.textEditingController,
        maxLines: widget.satirSayisi,
        textInputAction: TextInputAction.next,
        inputFormatters: [LengthLimitingTextInputFormatter(widget.kisitlama)],
        magnifierConfiguration: TextMagnifierConfiguration.disabled,
        validator: (value) {
          if (value!.isEmpty ||
              !RegExp(r'^[^@]+@[^@]+\.[^@]+').hasMatch(value)) {
            return 'Lütfen geçerli bir mail adresi girin';
          } else {
            return null;
          }
        },
        style: const TextStyle(
          color: Colors.grey,
          fontSize: 14.0,
        ),
        decoration: InputDecoration(
          border: const OutlineInputBorder(borderSide: BorderSide.none),
          contentPadding: EdgeInsets.symmetric(
            horizontal: context.dynamicWidth(0.01),
          ),
          hintText: widget.aciklama,
          hintStyle: const TextStyle(fontSize: 9.0, color: Colors.grey),
        ),
      ),
    );
  }
}
