import 'package:flutter/material.dart';
import 'package:hamlemuhcrm/core/extensions/responsive_extension.dart';

import '../resources/custom_tf_input_decoration.dart';

class CustomActivityTextField extends StatefulWidget {
  final IconData icon;
  final String icYazi;
  final Color iconRenk;
  final double yukseklik;
  final TextEditingController tf;

  const CustomActivityTextField(
      {super.key,
      required this.icon,
      required this.icYazi,
      required this.iconRenk,
      required this.yukseklik,
      required this.tf});

  @override
  State<CustomActivityTextField> createState() =>
      _CustomActivityTextFieldState();
}

class _CustomActivityTextFieldState extends State<CustomActivityTextField> {
  @override
  Widget build(BuildContext context) {
    return Center(
      child: Column(
        children: [
          Container(
            height: context.dynamicHeight(widget.yukseklik),
            decoration: BoxDecoration(
                borderRadius: BorderRadius.circular(8),
                color: Colors.white,
                border: Border.all(
                    width: 1.1, color: Colors.grey.withOpacity(0.25))),
            alignment: Alignment.center,
            child: Row(
              crossAxisAlignment: CrossAxisAlignment.center,
              children: [
                Flexible(
                  flex: 2,
                  child: TextFormField(
                      controller: widget.tf,
                      style:
                          const TextStyle(color: Colors.grey, fontSize: 13.0),
                      decoration: CustomTfInputDecoration(
                          hintTxt: widget.icYazi,
                          icon: widget.icon,
                          iconRenk: widget.iconRenk)),
                ),
              ],
            ),
          ),
        ],
      ),
    );
  }
}
