import 'package:flutter/material.dart';
import 'package:flutter_bloc/flutter_bloc.dart';
import 'package:google_fonts/google_fonts.dart';
import 'package:hamlemuhcrm/core/constants/app_constants.dart';
import 'package:hamlemuhcrm/core/extensions/image_enum_extension.dart';
import 'package:hamlemuhcrm/features/customers/cubit/company_personal_cubit.dart';
import 'package:hamlemuhcrm/features/customers/model/firma_yetkililer.dart';
import 'package:hamlemuhcrm/features/auth/login/cubit/login_cubit.dart';
import 'package:hamlemuhcrm/features/customers/widgets/int_textfield.dart';
import 'package:hamlemuhcrm/features/customers/widgets/mail_textfield.dart';
import 'package:hamlemuhcrm/features/customers/widgets/string_textfield.dart';
import 'package:hamlemuhcrm/core/extensions/responsive_extension.dart';

import '../../../../core/constants/color_constants.dart';

class UpdatePerson extends StatefulWidget {
  final FirmaYetkililer yetkili;
  final String firmaIsmi;
  final String firmaID;
  const UpdatePerson(
      {super.key,
      required this.yetkili,
      required this.firmaIsmi,
      required this.firmaID});

  @override
  State<UpdatePerson> createState() => _UpdatePersonState();
}

class _UpdatePersonState extends State<UpdatePerson> {
  final _uPersonKey = GlobalKey<FormState>();

  @override
  void initState() {
    super.initState();
    tcKisiAdSoyad.text = widget.yetkili.yetkiliAdsoyad!;
    tcKisiBirim.text = widget.yetkili.yetkiliIlgilibirim!;
    tcKisiCepNo.text = widget.yetkili.yetkiliGsm!;
    tcKisiMail.text = widget.yetkili.yetkiliMail!;
    tcKisiNot.text = widget.yetkili.yetkiliNot!;
  }

  final TextEditingController tcKisiAdSoyad = TextEditingController();
  final TextEditingController tcKisiBirim = TextEditingController();
  final TextEditingController tcKisiCepNo = TextEditingController();
  final TextEditingController tcKisiMail = TextEditingController();
  final TextEditingController tcKisiNot = TextEditingController();

  @override
  Widget build(BuildContext context) {
    return Scaffold(
      appBar: _appbar(context),
      body: SingleChildScrollView(
        child: Padding(
          padding:
              EdgeInsets.symmetric(horizontal: context.dynamicHeight(0.03)),
          child: Column(
            children: [
              const SizedBox(height: 4),
              Container(
                width: context.dynamicWidth(1),
                decoration: BoxDecoration(
                    borderRadius: BorderRadius.circular(15),
                    color: Colors.white,
                    boxShadow: [
                      BoxShadow(
                        color: Colors.grey.withOpacity(0.2),
                        blurRadius: 7,
                        offset: const Offset(4, 5),
                      )
                    ]),
                child: Padding(
                  padding:
                      const EdgeInsets.symmetric(vertical: 10, horizontal: 17),
                  child: Form(
                    key: _uPersonKey,
                    child: Column(
                      mainAxisAlignment: MainAxisAlignment.center,
                      children: [
                        SizedBox(
                            height: context.dynamicHeight(0.25),
                            child: ImageEnums.uemployee.toPageImage),
                        _headLine('Ad Soyad'),
                        const SizedBox(height: 5),
                        StringTextField(
                          textEditingController: tcKisiAdSoyad,
                          aciklama: '',
                          yukseklik: context.dynamicHeight(0.05),
                          satirSayisi: 1,
                          kenarlik: true,
                          golge: false,
                          arkaplanRengi:
                              ColorsConstants.instance.backgroundColor,
                          tekSatirMi: true,
                          kisitlama: 30,
                        ),
                        const SizedBox(height: 10),
                        _headLine('İlgili Birim'),
                        const SizedBox(height: 5),
                        StringTextField(
                          textEditingController: tcKisiBirim,
                          aciklama: '',
                          yukseklik: context.dynamicHeight(0.05),
                          satirSayisi: 1,
                          kenarlik: true,
                          golge: false,
                          arkaplanRengi:
                              ColorsConstants.instance.backgroundColor,
                          tekSatirMi: true,
                          kisitlama: 37,
                        ),
                        const SizedBox(height: 10),
                        _headLine('Mail Adresi'),
                        const SizedBox(height: 5),
                        MailTextField(
                          textEditingController: tcKisiMail,
                          aciklama: '',
                          yukseklik: context.dynamicHeight(0.05),
                          satirSayisi: 1,
                          kenarlik: true,
                          golge: false,
                          arkaplanRengi:
                              ColorsConstants.instance.backgroundColor,
                          tekSatirMi: true,
                          kisitlama: 70,
                        ),
                        const SizedBox(height: 10),
                        _headLine('Cep No'),
                        const SizedBox(height: 5),
                        IntTextField(
                          textEditingController: tcKisiCepNo,
                          aciklama: '',
                          yukseklik: context.dynamicHeight(0.05),
                          satirSayisi: 1,
                          kenarlik: true,
                          golge: false,
                          arkaplanRengi:
                              ColorsConstants.instance.backgroundColor,
                          tekSatirMi: true,
                          kisitlama: 11,
                        ),
                        const SizedBox(height: 10),
                        _headLine('Not'),
                        const SizedBox(height: 5),
                        StringTextField(
                          textEditingController: tcKisiNot,
                          aciklama: '',
                          yukseklik: context.dynamicHeight(0.09),
                          satirSayisi: 3,
                          kenarlik: true,
                          golge: false,
                          arkaplanRengi:
                              ColorsConstants.instance.backgroundColor,
                          tekSatirMi: false,
                          kisitlama: 100,
                        ),
                        const SizedBox(height: 14),
                        Row(
                            mainAxisAlignment: MainAxisAlignment.end,
                            children: [
                              Container(
                                height: context.dynamicHeight(0.05),
                                decoration: BoxDecoration(
                                    color: ColorsConstants.instance.baseTheme,
                                    borderRadius: BorderRadius.circular(10),
                                    boxShadow: [
                                      BoxShadow(
                                        color: Colors.grey.withOpacity(0.4),
                                        blurRadius: 8,
                                        offset: const Offset(1, 1),
                                      )
                                    ]),
                                child: TextButton(
                                    onPressed: () {
                                      ScaffoldMessenger.of(context)
                                          .showSnackBar(
                                        SnackBar(
                                          content: Text(
                                              "${tcKisiAdSoyad.text} kaldırılsın mı?"),
                                          backgroundColor: ColorsConstants
                                              .instance.baseTheme,
                                          action: SnackBarAction(
                                            label: "Evet",
                                            textColor: Colors.white,
                                            onPressed: () {
                                              context
                                                  .read<CompanyPersonalCubit>()
                                                  .yetkiliSil(
                                                      widget.yetkili.yetkiliID!,
                                                      context
                                                          .read<LoginCubit>()
                                                          .id,
                                                      context
                                                          .read<LoginCubit>()
                                                          .token);
                                              Future.delayed(
                                                  const Duration(
                                                      milliseconds: 800), () {
                                                context
                                                    .read<
                                                        CompanyPersonalCubit>()
                                                    .yetkiliListele(
                                                        widget.firmaID,
                                                        context
                                                            .read<LoginCubit>()
                                                            .token,
                                                        context
                                                            .read<LoginCubit>()
                                                            .id)
                                                    .whenComplete(() {
                                                  Navigator.pop(context, true);
                                                });
                                              });
                                            },
                                          ),
                                        ),
                                      );
                                    },
                                    style: TextButton.styleFrom(
                                        backgroundColor: Colors.transparent,
                                        shape: RoundedRectangleBorder(
                                          borderRadius:
                                              BorderRadius.circular(10),
                                        )),
                                    child: Padding(
                                      padding: const EdgeInsets.symmetric(
                                          horizontal: 10.0),
                                      child: Text(
                                        ApplicationConstants
                                            .instance.moduleDeleteTxt,
                                        style: const TextStyle(
                                            color: Colors.white),
                                      ),
                                    )),
                              ),
                              const SizedBox(width: 15),
                              Container(
                                height: context.dynamicHeight(0.05),
                                decoration: BoxDecoration(
                                    color: ColorsConstants.instance.baseTheme,
                                    borderRadius: BorderRadius.circular(10),
                                    boxShadow: [
                                      BoxShadow(
                                        color: Colors.grey.withOpacity(0.4),
                                        blurRadius: 8,
                                        offset: const Offset(1, 1),
                                      )
                                    ]),
                                child: TextButton(
                                    onPressed: () {
                                      if (tcKisiAdSoyad.text != '' &&
                                          tcKisiBirim.text != '' &&
                                          tcKisiMail.text != '' &&
                                          tcKisiNot.text != '' &&
                                          tcKisiCepNo.text != '') {
                                        context
                                            .read<CompanyPersonalCubit>()
                                            .yetkiliGuncelle(
                                                widget.yetkili.yetkiliID ?? '',
                                                tcKisiAdSoyad.text,
                                                tcKisiBirim.text,
                                                tcKisiCepNo.text,
                                                tcKisiMail.text,
                                                tcKisiNot.text,
                                                context.read<LoginCubit>().id,
                                                context
                                                    .read<LoginCubit>()
                                                    .token)
                                            .whenComplete(() {
                                          if (mounted) {
                                            _showSnackbarMessage(
                                                'Yetkili Güncellendi..');
                                          }
                                          Future.delayed(
                                              const Duration(
                                                  milliseconds: 1900), () {
                                            Navigator.pop(context, true);
                                          });
                                        });
                                      }
                                    },
                                    style: TextButton.styleFrom(
                                        backgroundColor: Colors.transparent,
                                        shape: RoundedRectangleBorder(
                                          borderRadius:
                                              BorderRadius.circular(10),
                                        )),
                                    child: Padding(
                                      padding: const EdgeInsets.symmetric(
                                          horizontal: 10.0),
                                      child: Text(
                                        ApplicationConstants
                                            .instance.moduleUpdateTxt,
                                        style: const TextStyle(
                                            color: Colors.white),
                                      ),
                                    )),
                              ),
                            ]),
                      ],
                    ),
                  ),
                ),
              ),
              const SizedBox(height: 15),
            ],
          ),
        ),
      ),
    );
  }

  AppBar _appbar(BuildContext context) {
    return AppBar(
      backgroundColor: Colors.transparent,
      elevation: 0,
      title: Text('${widget.yetkili.yetkiliAdsoyad!} ( ${widget.firmaIsmi} )',
          style: GoogleFonts.inter(
              color: Colors.black, fontWeight: FontWeight.w400, fontSize: 16)),
      centerTitle: true,
      leading: IconButton(
          onPressed: () {
            //Navigator.of(context).popUntil((route) => route.isFirst);
            Navigator.pop(context, true);
          },
          icon: const Icon(
            Icons.arrow_back_ios_new,
            color: Colors.black54,
            size: 20,
          )),
    );
  }

  Widget _headLine(String title) {
    return Row(
      mainAxisAlignment: MainAxisAlignment.start,
      children: [
        Text(
          title,
          style: const TextStyle(color: Colors.grey, fontSize: 11),
        )
      ],
    );
  }

  void _showSnackbarMessage(String msg) {
    ScaffoldMessenger.of(context).showSnackBar(
      SnackBar(
        backgroundColor: ColorsConstants.instance.baseTheme,
        content: Text(
          msg,
        ),
        behavior: SnackBarBehavior.floating,
        action: SnackBarAction(
          label: "Tamam",
          textColor: Colors.white,
          onPressed: () {},
        ),
      ),
    );
  }
}
