import 'package:flutter/material.dart';
import 'package:flutter_bloc/flutter_bloc.dart';
import 'package:google_fonts/google_fonts.dart';
import 'package:hamlemuhcrm/core/constants/font_styles.dart';
import 'package:hamlemuhcrm/core/extensions/image_enum_extension.dart';
import 'package:hamlemuhcrm/core/extensions/responsive_extension.dart';
import 'package:hamlemuhcrm/features/auth/login/cubit/login_cubit.dart';
import 'package:hamlemuhcrm/features/customers/cubit/company_personal_cubit.dart';
import 'package:hamlemuhcrm/features/customers/model/firma_yetkililer.dart';
import 'package:hamlemuhcrm/features/customers/view/companies/update_person.dart';
import 'package:hamlemuhcrm/features/customers/widgets/orange_box.dart';

import '../../../../core/constants/color_constants.dart';

class ListPerson extends StatefulWidget {
  final String firmaId;
  final String firmaAd;
  const ListPerson({super.key, required this.firmaId, required this.firmaAd});

  @override
  State<ListPerson> createState() => _ListPersonState();
}

class _ListPersonState extends State<ListPerson> {
  final _listPersonKey = GlobalKey<FormState>();

  bool isFinish = false;
  @override
  void initState() {
    super.initState();
    isFinish = false;
    context
        .read<CompanyPersonalCubit>()
        .yetkiliListele(widget.firmaId, context.read<LoginCubit>().token,
            context.read<LoginCubit>().id)
        .whenComplete(() {
      isFinish = true;
    });
  }

  void _yetkiliListesi() {
    context.read<CompanyPersonalCubit>().yetkiliListele(widget.firmaId,
        context.read<LoginCubit>().token, context.read<LoginCubit>().id);
  }

  @override
  Widget build(BuildContext context) {
    return Scaffold(
      appBar: AppBar(
        backgroundColor: Colors.transparent,
        elevation: 0,
        title: Text(
            'Kişi Listesi (${context.watch<CompanyPersonalCubit>().firmaAd})',
            style:
                GoogleFonts.inter(fontWeight: FontWeight.w400, fontSize: 16)),
        centerTitle: true,
        actions: [
          IconButton(
              onPressed: () {},
              icon: const Icon(
                Icons.notifications_none_outlined,
              )),
        ],
        leading: IconButton(
            onPressed: () {
              Navigator.pop(context, true);
            },
            icon: const Icon(
              Icons.arrow_back_ios_new,
              size: 20,
            )),
      ),
      body: SingleChildScrollView(
        child: Column(
          children: [
            Padding(
              padding:
                  EdgeInsets.symmetric(horizontal: context.dynamicWidth(0.045)),
              child: Form(
                key: _listPersonKey,
                child: Column(
                  mainAxisAlignment: MainAxisAlignment.center,
                  children: [
                    OrangeBox(id: widget.firmaId, firmaAd: widget.firmaAd),
                    const SizedBox(height: 15),
                    isFinish
                        ? SizedBox(
                            height: context.dynamicHeight(0.7),
                            child: BlocBuilder<CompanyPersonalCubit,
                                    List<FirmaYetkililer>>(
                                builder: (context, yetkililer) {
                              if (yetkililer.isNotEmpty) {
                                return ListView.builder(
                                    itemCount: yetkililer.length,
                                    itemBuilder: (context, indeks) {
                                      var yetkili = yetkililer[indeks];
                                      return InkWell(
                                        onTap: () {
                                          Navigator.push(
                                              context,
                                              MaterialPageRoute(
                                                  builder: (context) =>
                                                      UpdatePerson(
                                                          yetkili: yetkili,
                                                          firmaIsmi: context
                                                              .read<
                                                                  CompanyPersonalCubit>()
                                                              .firmaAd,
                                                          firmaID: widget
                                                              .firmaId))).then(
                                              (value) {
                                            if (value) {
                                              if (mounted) {
                                                setState(() {
                                                  _yetkiliListesi();
                                                });
                                              }
                                            } else if (value == null) {
                                              null;
                                            } else {
                                              null;
                                            }
                                          });
                                        },
                                        child: Container(
                                          height: context.dynamicHeight(0.08),
                                          margin: const EdgeInsets.symmetric(
                                              vertical: 5),
                                          decoration: BoxDecoration(
                                            borderRadius:
                                                BorderRadius.circular(5),
                                            boxShadow: [
                                              BoxShadow(
                                                  color: Colors.grey
                                                      .withOpacity(0.2),
                                                  blurRadius: 7,
                                                  offset: const Offset(1, 1))
                                            ],
                                            color: Colors.white,
                                          ),
                                          child: Row(
                                            children: [
                                              Container(
                                                width: 5,
                                                height:
                                                    context.dynamicHeight(0.08),
                                                decoration: BoxDecoration(
                                                  borderRadius:
                                                      const BorderRadius.only(
                                                          topLeft:
                                                              Radius.circular(
                                                                  5),
                                                          bottomLeft:
                                                              Radius.circular(
                                                                  5)),
                                                  color: ColorsConstants
                                                      .instance
                                                      .customColors[indeks],
                                                ),
                                              ),
                                              const SizedBox(width: 10),
                                              Text(yetkili.yetkiliAdsoyad!,
                                                  style: FontStyles
                                                      .instance.ortaYazi),
                                              const Spacer(),
                                              Container(
                                                margin: EdgeInsets.only(
                                                    right: context
                                                        .dynamicWidth(0.04)),
                                                width:
                                                    context.dynamicWidth(0.07),
                                                height:
                                                    context.dynamicHeight(0.06),
                                                child: Stack(
                                                  alignment:
                                                      Alignment.centerLeft,
                                                  children: [
                                                    CircleAvatar(
                                                        radius: 22,
                                                        backgroundColor:
                                                            Colors.white,
                                                        child: ImageEnums
                                                            .cemployee
                                                            .toPageImage),
                                                  ],
                                                ),
                                              ),
                                            ],
                                          ),
                                        ),
                                      );
                                    });
                              } else {
                                return const Center(
                                  child: Column(
                                    mainAxisAlignment: MainAxisAlignment.start,
                                    children: [
                                      SizedBox(height: 25),
                                      Text(
                                        'Kişi Bulunamadı',
                                        style: TextStyle(fontSize: 17),
                                      ),
                                    ],
                                  ),
                                );
                              }
                            }),
                          )
                        : _isLoadingBar,
                  ],
                ),
              ),
            ),
            const SizedBox(height: 15),
          ],
        ),
      ),
    );
  }
}

Widget get _isLoadingBar => const Center(
      child: CircularProgressIndicator(),
    );
