import 'package:flutter/material.dart';
import 'package:flutter_bloc/flutter_bloc.dart';
import 'package:google_fonts/google_fonts.dart';
import 'package:hamlemuhcrm/core/constants/font_styles.dart';
import 'package:hamlemuhcrm/core/extensions/responsive_extension.dart';
import 'package:hamlemuhcrm/core/route/page_route.dart';
import 'package:hamlemuhcrm/features/auth/login/cubit/login_cubit.dart';
import 'package:hamlemuhcrm/features/customers/cubit/customers_cubit.dart';
import 'package:hamlemuhcrm/features/customers/model/firmalar.dart';
import 'package:hamlemuhcrm/features/customers/view/activities/company_activity_page.dart';
import 'package:hamlemuhcrm/features/customers/view/companies/update_company.dart';
import 'package:hamlemuhcrm/features/customers/widgets/shimmer_container.dart';

import '../../../core/constants/color_constants.dart';

class CompanysTabBar extends StatefulWidget {
  const CompanysTabBar({super.key});

  @override
  State<CompanysTabBar> createState() => _CompanysTabBarState();
}

class _CompanysTabBarState extends State<CompanysTabBar> {
  late bool isFinish;

  @override
  void initState() {
    isFinish = false;
    context
        .read<CustomersCubit>()
        .kisifirmalariListele(
            context.read<LoginCubit>().tip,
            context.read<LoginCubit>().token,
            context.read<LoginCubit>().id,
            context.read<LoginCubit>().userfirmId,
            2)
        .whenComplete(() => isFinish = true);
    super.initState();
  }

  @override
  Widget build(BuildContext context) {
    return Scaffold(
      body: BlocBuilder<CustomersCubit, List<Firmalar>>(
          builder: (context, firmalarListesi) {
        if (firmalarListesi.isNotEmpty) {
          return _scrollBar(
            ListView.builder(
                physics: const PageScrollPhysics(),
                itemCount: firmalarListesi.length,
                itemBuilder: (context, indeks) {
                  var firma = firmalarListesi[indeks];
                  bool arsiv;
                  arsiv = firma.firmaOnay == '0';
                  return Padding(
                    padding: const EdgeInsets.symmetric(vertical: 8),
                    child: InkWell(
                      onTap: () {
                        context.read<CustomersCubit>().firmaAktiviteleri = true;
                        Navigator.push(
                            context,
                            CustomPageRoute(
                                direction: AxisDirection.left,
                                child: CompanyActivityPage(firma: firma)));
                      },
                      child: isFinish
                          ? Container(
                              padding: const EdgeInsets.only(right: 10),
                              margin:
                                  const EdgeInsets.symmetric(horizontal: 15),
                              decoration: BoxDecoration(
                                  borderRadius: BorderRadius.circular(5),
                                  color: Colors.white,
                                  boxShadow: [
                                    BoxShadow(
                                        color: Colors.grey.withOpacity(0.5),
                                        offset: const Offset(0.4, 0.5),
                                        blurRadius: 7)
                                  ]),
                              child: Row(
                                children: [
                                  Container(
                                    width: 10,
                                    height: context.dynamicHeight(0.092),
                                    decoration: BoxDecoration(
                                      borderRadius: const BorderRadius.only(
                                          topLeft: Radius.circular(5),
                                          bottomLeft: Radius.circular(5)),
                                      color: arsiv
                                          ? Colors.grey.withOpacity(0.8)
                                          : ColorsConstants.instance.baseTheme
                                              .withOpacity(0.2),
                                    ),
                                  ),
                                  const SizedBox(width: 20),
                                  const Icon(Icons.task_alt_outlined),
                                  const SizedBox(width: 10),
                                  Text(
                                      firma.firmaIsim.length > 25
                                          ? "${firma.firmaIsim.substring(0, 24)}..."
                                          : firma.firmaIsim,
                                      style: FontStyles.instance.ortaYazi),
                                  const Spacer(),
                                  TextButton(
                                      onPressed: () => _updateCompany(firma),
                                      style: TextButton.styleFrom(
                                          alignment: Alignment.center,
                                          minimumSize: const Size(30, 30),
                                          backgroundColor: ColorsConstants
                                              .instance.backgroundColor,
                                          shape: RoundedRectangleBorder(
                                            borderRadius:
                                                BorderRadius.circular(8),
                                            side: BorderSide(
                                                color: Colors.grey
                                                    .withOpacity(0.5),
                                                width: 1.2),
                                          )),
                                      child: Padding(
                                        padding: EdgeInsets.symmetric(
                                            horizontal:
                                                context.dynamicWidth(0.012)),
                                        child: Text(
                                          'Firma Bilgisi',
                                          style: GoogleFonts.roboto(
                                              color: Colors.grey.shade600,
                                              fontSize: 11),
                                        ),
                                      )),
                                ],
                              ),
                            )
                          : ShimmerContainer(
                              color: Colors.grey,
                              opacity: 0.3,
                              height: context.dynamicHeight(0.092),
                              width: context.dynamicWidth(0.92),
                            ),
                    ),
                  );
                }),
          );
        } else {
          return _notFoundMessage;
        }
      }),
    );
  }

  void _updateCompany(Firmalar firma) {
    Navigator.push(
        context, CustomPageRoute(child: UpdateCompany(firma: firma)));
  }

  Widget get _notFoundMessage => Center(
        child: Column(
          mainAxisAlignment: MainAxisAlignment.start,
          children: [
            SizedBox(height: context.dynamicWidth(0.023)),
            const Text(
              'Firma Bulunamadı',
              style: TextStyle(fontSize: 17),
            ),
          ],
        ),
      );

  Widget _scrollBar(Widget child) {
    return Scrollbar(
      thickness: 6,
      radius: const Radius.circular(10),
      child: child,
    );
  }
}
