import 'package:flutter_bloc/flutter_bloc.dart';
import 'package:hamlemuhcrm/core/extensions/log_extension.dart';
import 'package:hamlemuhcrm/data/repo/company_personal_repository.dart';
import 'package:hamlemuhcrm/features/customers/model/firma_yetkililer.dart';

class CompanyPersonalCubit extends Cubit<List<FirmaYetkililer>> {
  CompanyPersonalCubit() : super(<FirmaYetkililer>[]);

  var repo = CompanyPersonalRepository();
  String firmaAd = "";
  bool yetkiliVarMiVariable = false;
  List<FirmaYetkililer> yetkiliListesi = [];
  String ilkYetkili = '';

  Future<void> yetkiliListele(
      String yetkiliFirmaId, String token, String loginuserid) async {
    var liste = await repo.yetkiliListele(yetkiliFirmaId, token, loginuserid);
    yetkiliListesi = liste!;
    emit(liste);
  }

  Future<void> yetkiliAra(String aramaKelimesi) async {
    var liste = <FirmaYetkililer>[];
    for (var element in yetkiliListesi) {
      if (element.yetkiliAdsoyad!
          .toLowerCase()
          .contains(aramaKelimesi.toLowerCase())) {
        liste.add(element);
      }
    }
    emit(liste);
  }

  Future<void> yetkiliEkle(
      String yetkiliFirmaId,
      String yetkiliUserFirmId,
      String yetkiliAdSoyad,
      String yetkiliIlgiliBirim,
      String yetkiliGsm,
      String yetkiliMail,
      String yetkiliNot,
      String loginuserid,
      String token) async {
    await repo.yetkiliEkle(
        yetkiliFirmaId,
        yetkiliUserFirmId,
        yetkiliAdSoyad,
        yetkiliIlgiliBirim,
        yetkiliGsm,
        yetkiliMail,
        yetkiliNot,
        loginuserid,
        token);
  }

  Future<void> yetkiliSil(
      String yetkiliId, String loginuserid, String token) async {
    await repo.yetkiliSil(yetkiliId, loginuserid, token);
  }

  Future<void> yetkiliGuncelle(
      String yetkiliId,
      String yetkiliAdsoyad,
      String yetkiliIlgiliBirim,
      String yetkiliGsm,
      String yetkiliMail,
      String yetkiliNot,
      String loginuserid,
      String token) async {
    await repo.yetkiliGuncelle(yetkiliId, yetkiliAdsoyad, yetkiliIlgiliBirim,
        yetkiliGsm, yetkiliMail, yetkiliNot, loginuserid, token);
  }

  Future<void> yetkiliKontrol(
      String calisanID, String token, String loginuserid) async {
    String cevap = await repo.yetkilikontrolEt(token, loginuserid);
    cevap.log();
    List<String> ilksayiyiAl = cevap.substring(1).split(',');
    ilkYetkili = ilksayiyiAl[0];
    'yetkiliKontrol : ilkyetkiliID : $ilkYetkili'.log();
    if (cevap.contains(calisanID)) {
      yetkiliVarMiVariable = true;
    } else {
      yetkiliVarMiVariable = false;
    }
  }
}
