import 'package:dropdown_button2/dropdown_button2.dart';
import 'package:flutter/material.dart';
import 'package:flutter_bloc/flutter_bloc.dart';
import 'package:hamlemuhcrm/core/constants/color_constants.dart';
import 'package:hamlemuhcrm/core/cubits/dropdown_cubit.dart';
import 'package:hamlemuhcrm/core/extensions/responsive_extension.dart';
import 'package:hamlemuhcrm/features/calendar/cubit/calendar_cubit.dart';

import '../../../core/constants/font_styles.dart';
import '../../../data/dropdown_models/personal_getdata_api.dart';

class SelectProjectDropdown extends StatefulWidget {
  final String? initialProjectIDValue;
  const SelectProjectDropdown({super.key, this.initialProjectIDValue});

  @override
  State<SelectProjectDropdown> createState() => _SelectProjectDropdownState();
}

class _SelectProjectDropdownState extends State<SelectProjectDropdown> {
  String? _secilenProjeId;

  bool isFinish = false;

  @override
  void initState() {
    changeLoading();
    setInitialValue();
    changeLoading();
    super.initState();
  }

  void changeLoading() {
    setState(() {
      isFinish = !isFinish;
    });
  }

  void setInitialValue() {
    if (widget.initialProjectIDValue != null &&
        widget.initialProjectIDValue != '' &&
        widget.initialProjectIDValue != '0') {
      _secilenProjeId = widget.initialProjectIDValue;
      context.read<CalendarCubit>().secilenProjeID =
          widget.initialProjectIDValue!;
    }
  }

  @override
  Widget build(BuildContext context) {
    return !isFinish
        ? BlocBuilder<DropdownCubit, DropdownState>(
            builder: (context, state) {
              return DropdownButtonHideUnderline(
                child: DropdownButton2(
                  hint: Text(
                    "",
                    style: FontStyles.instance.meetGeneralStyle,
                  ), //Data1
                  isExpanded: true,
                  items: state.projeler.map((proje) {
                    return DropdownMenuItem(
                      value: proje.projeId,
                      onTap: () {
                        // burada projenin firma id'sini o firmanın yetkili listesini getirmesi için göndericez..
                        setCubitValues(proje);
                        debugPrint(proje.projeFirmaId);
                      },
                      child: Text(proje.projeAd,
                          style: FontStyles.instance.meetGeneralStyle), //value
                    );
                  }).toList(),
                  value: _secilenProjeId,
                  onChanged: (newValue) {
                    setState(() {
                      _secilenProjeId = newValue.toString();
                      context.read<CalendarCubit>().secilenProjeID =
                          _secilenProjeId ?? '0';
                      debugPrint("_secilen projeID == $_secilenProjeId");
                    });
                  },
                  buttonStyleData: ButtonStyleData(
                    height: context.dynamicHeight(0.05),
                    padding: const EdgeInsets.only(right: 10),
                    decoration: BoxDecoration(
                        borderRadius: BorderRadius.circular(10),
                        color: Colors.white,
                        border: Border.all(color: Colors.grey.shade400)),
                  ),
                  iconStyleData: IconStyleData(
                    icon: const Icon(
                      Icons.keyboard_arrow_down_outlined, //ilk icon
                    ),
                    openMenuIcon: const Icon(Icons
                        .keyboard_arrow_left_outlined), //açıldıktan sonraki icon
                    iconSize: 23,
                    iconEnabledColor: ColorsConstants.instance.baseTheme,
                    iconDisabledColor: Colors.white,
                  ),
                  dropdownStyleData: DropdownStyleData(
                    maxHeight: context.dynamicHeight(0.17),
                    offset: const Offset(0, 0),
                    decoration: BoxDecoration(
                      borderRadius: BorderRadius.circular(10),
                      color: ColorsConstants.instance
                          .backgroundColor, //açılır menü arkaplan rengi
                    ),
                    scrollbarTheme: ScrollbarThemeData(
                      thumbColor: MaterialStateColor.resolveWith((states) =>
                          ColorsConstants.instance
                              .baseTheme), //dropdown scroll rengi değiştirme
                      radius: const Radius.circular(10),
                      thickness: MaterialStateProperty.all<double>(6),
                      thumbVisibility: MaterialStateProperty.all<bool>(true),
                    ),
                  ),
                  menuItemStyleData: const MenuItemStyleData(
                    height: 35,
                    padding: EdgeInsets.symmetric(horizontal: 14),
                  ),
                ),
              );
            },
          )
        : Container(
            height: context.dynamicHeight(0.054),
            width: context.dynamicWidth(0.9),
            padding: const EdgeInsets.symmetric(horizontal: 10),
            decoration: BoxDecoration(
                borderRadius: BorderRadius.circular(10),
                color: Colors.white,
                border: Border.all(color: Colors.grey.shade400)),
          );
  }

  void setCubitValues(ProjeDDModel proje) {
    context.read<CalendarCubit>().secilenProjeFirmaID = proje.projeFirmaId;
    context.read<CalendarCubit>().secilenProjeID = proje.projeId;
  }
}
