import 'package:flutter/material.dart';
import 'package:flutter_bloc/flutter_bloc.dart';
import 'package:hamlemuhcrm/core/extensions/log_extension.dart';
import 'package:hamlemuhcrm/core/extensions/string_extension.dart';
import 'package:hamlemuhcrm/features/auth/login/cubit/login_cubit.dart';
import 'package:hamlemuhcrm/features/calendar/cubit/calendar_cubit.dart';
import 'package:hamlemuhcrm/features/calendar/cubit/calendar_state.dart';

import '../../../core/constants/color_constants.dart';
import '../../projects/model/filter_chip.dart';

class FilterMeetingChip extends StatefulWidget {
  const FilterMeetingChip({super.key});

  @override
  State<FilterMeetingChip> createState() => _FilterMeetingChipState();
}

class _FilterMeetingChipState extends State<FilterMeetingChip> {
  List<FilterChipModel> filterList = [
    FilterChipModel(index: 0, name: 'Bu Hafta'),
    FilterChipModel(index: 1, name: 'Bu Ay'),
  ];

  late DateTime now = DateTime.now();
  late final String firstDayOfMonth =
      "${now.year}-${now.month.toString().padLeft(2, '0')}-01";
  late final String lastDayOfMonth =
      "${now.year}-${now.month.toString().padLeft(2, '0')}-${DateTime(now.year, now.month + 1, 0).day.toString().padLeft(2, '0')}";

  @override
  void initState() {
    now = DateTime.now();
    super.initState();
  }

  @override
  Widget build(BuildContext context) {
    final textTheme = Theme.of(context).textTheme;
    return Row(children: [
      ...List.generate(2, (index) {
        var chip = filterList[index];
        return BlocBuilder<CalendarCubit, CalendarState>(
            builder: (context, state) {
          return InkWell(
            onTap: () {
              context.read<CalendarCubit>().filterChangeValue(chip.index);
              'activeIndex : ${state.filterIndex}'.log();
              'chipIndex : ${chip.index}'.log();
              switch (chip.index) {
                case 0:
                  context.read<CalendarCubit>().filterMeetings(
                      context.read<LoginCubit>().token,
                      context.read<LoginCubit>().id,
                      DateTime.now()
                          .phpDateTimeConvertExtension(DateTime.now()),
                      isWeek: true);
                case 1:
                  context.read<CalendarCubit>().fetchMonthMeets(
                      context.read<LoginCubit>().token,
                      context.read<LoginCubit>().id,
                      firstDayOfMonth,
                      lastDayOfMonth);
              }
            },
            splashColor: Colors.transparent,
            child: Container(
              margin: const EdgeInsets.all(5),
              decoration: BoxDecoration(
                  color: state.filterIndex == chip.index
                      ? ColorsConstants.instance.baseTheme
                      : Colors.grey.shade200,
                  borderRadius: BorderRadius.circular(14),
                  border: Border.all(
                      color: state.filterIndex == chip.index
                          ? Colors.black26
                          : Colors.grey.shade400,
                      width: 1.4)),
              child: Padding(
                padding:
                    const EdgeInsets.symmetric(horizontal: 10, vertical: 5),
                child: Text(
                  chip.name,
                  style: textTheme.titleSmall?.copyWith(
                    color: state.filterIndex == chip.index
                        ? Colors.white
                        : Colors.black45,
                  ),
                ),
              ),
            ),
          );
        });
      })
    ]);
  }
}
