import 'dart:math';

import 'package:flutter/material.dart';

import 'package:hamlemuhcrm/core/extensions/image_enum_extension.dart';
import 'package:hamlemuhcrm/core/extensions/responsive_extension.dart';
import 'package:hamlemuhcrm/data/dropdown_models/personal_getdata_api.dart';

import '../../../../core/constants/font_styles.dart';

class ProfileCustomersLeaderCardItem extends StatelessWidget {
  final YetkiliDDModel model;
  const ProfileCustomersLeaderCardItem({super.key, required this.model});

  @override
  Widget build(BuildContext context) {
    return Container(
      height: context.dynamicHeight(0.09),
      margin: EdgeInsets.symmetric(
          vertical: context.dynamicHeight(0.01),
          horizontal: context.dynamicWidth(0.04)),
      decoration: BoxDecoration(
        borderRadius: BorderRadius.circular(5),
        boxShadow: [
          BoxShadow(
              color: Colors.grey.withOpacity(0.4),
              blurRadius: 7,
              offset: const Offset(1, 5))
        ],
        color: Colors.white,
      ),
      child: Row(
        children: [
          Container(
            width: 5,
            height: context.dynamicHeight(0.09),
            decoration: BoxDecoration(
              borderRadius: const BorderRadius.only(
                  topLeft: Radius.circular(5), bottomLeft: Radius.circular(5)),
              color: Color((Random().nextDouble() * 0xFFFFFF).toInt())
                  .withOpacity(1.0),
            ),
          ),
          const SizedBox(width: 10),
          Text(model.yetkiliAdSoyad, style: FontStyles.instance.ortaYazi),
          const Spacer(),
          Container(
            margin: EdgeInsets.only(right: context.dynamicWidth(0.04)),
            width: context.dynamicWidth(0.14),
            height: context.dynamicHeight(0.06),
            child: Stack(
              alignment: Alignment.centerLeft,
              children: [
                CircleAvatar(
                  radius: 20,
                  backgroundColor: Colors.grey.shade400,
                  child: ImageEnums.question.toPageImage,
                )
              ],
            ),
          ),
        ],
      ),
    );
  }
}
