import 'package:flutter/material.dart';
import 'package:flutter_bloc/flutter_bloc.dart';
import 'package:hamlemuhcrm/core/cubits/dropdown_cubit.dart';
import 'package:hamlemuhcrm/features/calendar/tab_bar/widgets/profile_employee_card_item.dart';

class EmployeeListTabBar extends StatefulWidget {
  const EmployeeListTabBar({super.key});

  @override
  State<EmployeeListTabBar> createState() => _EmployeeListTabBarState();
}

class _EmployeeListTabBarState extends State<EmployeeListTabBar> {
  @override
  void initState() {
    super.initState();
    debugPrint("employee list tab bar initState çalıştı");
  }

  @override
  Widget build(BuildContext context) {
    return BlocBuilder<DropdownCubit, DropdownState>(
      builder: (context, state) {
        return BlocBuilder<DropdownCubit, DropdownState>(
            builder: (context, state) {
          switch (state.isComplete && !state.isLoading) {
            case true:
              return state.secilenCalisanlar.isNotEmpty
                  ? ListView.builder(
                      itemCount: state.secilenCalisanlar.length,
                      itemBuilder: (context, index) {
                        return ProfileEmployeeCardItem(
                            model: state.secilenCalisanlar[index]);
                      })
                  : _emptyListWidget;
            case false:
              return _emptyListWidget;
          }
        });
      },
    );
  }

  Widget get _emptyListWidget => Center(
        child: Text('Boş Liste',
            style: Theme.of(context)
                .textTheme
                .titleMedium
                ?.copyWith(color: Colors.grey)),
      );
}
