import 'dart:async';

import 'package:dio/dio.dart';
import 'package:flutter_bloc/flutter_bloc.dart';
import 'package:hamlemuhcrm/core/enum/user_enum.dart';

import '../../../../core/constants/url_services_constant.dart';
import '../../../../core/init/cache/cache_manager.dart';
import '../../../../core/utility/toast_manager.dart';
import '../../../home/cubit/home_custom_cubit.dart';
import '../../../profile/model/profile_detail.dart';
import '../../login/cubit/login_cubit.dart';

part 'splash_state.dart';

class SplashCubit extends Cubit<SplashState> {
  // Cubit'in başlangıç durumunu initial olarak ayarlayalım
  SplashCubit(this._loginScreenCubit, this._homeCustomCubit)
      : super(SplashState.initial);

  //token
  late String id;
  late String message;
  late String durum;
  late String userFirmId;
  late String tip;
  late String userimage;
  late String iseGirisTarihi;
  late String unvanId;
  late String unvanAd;
  late String hakkettigiyillikizingunsayisi;
  late String kullanilmisyillikizingunsayisi;
  late String kalanyillikizinhakkigunsayisi;

  ////getprofile
  late String ad;
  late String soyad;
  late String email;
  late String ceptelefon;
  late String bildirimMail;

  final LoginCubit _loginScreenCubit;
  final HomeCustomCubit _homeCustomCubit;

  void setNewProfileValues(ProfileDetail detail) async {
    ceptelefon = detail.telNumber;
  }

  Future<void> getUserInfo() async {
    // Durumu loading olarak güncelleyelim
    emit(SplashState.loading);

    String tokenSP =
        await CacheManager.instance.getValue(UserEnum.token.toName);
    String loginidSP =
        await CacheManager.instance.getValue(UserEnum.loginid.toName);

    // Token ve loginid değerlerinin boş olup olmadığını kontrol edelim
    if (tokenSP.isNotEmpty && loginidSP.isNotEmpty) {
      // API'ye istek atalım
      try {
        var url = URLAPIService.instance.tokenKontrolURL;
        var veri = {
          'token': tokenSP,
          'loginuserid': loginidSP,
        };
        var response = await Dio().post(url, data: FormData.fromMap(veri));

        // Cevabın durum kodunu kontrol edelim
        if (response.statusCode == 200) {
          // Cevabın içeriğini json olarak çözelim
          var gelenData = response.data;
          // Cevaptaki state değerine göre işlem yapalım
          if (gelenData['state'] == '1') {
            // Başarılı cevap geldiyse, kullanıcı bilgilerini değişkenlere atayalım
            id = gelenData['id'] ?? '';
            message = gelenData['message'] ?? '';
            durum = gelenData['state'] ?? '';
            ad = gelenData['first_name'] ?? '';
            soyad = gelenData['last_name'] ?? '';
            email = gelenData['email'] ?? '';
            bildirimMail = gelenData['bildirim_email_adresi'] ?? email ?? '';
            ceptelefon = gelenData['ceptelefon'] ?? '';
            userFirmId = gelenData['userfirm_id'] ?? '';
            tip = gelenData['tip'] ?? '';
            userimage = gelenData['userimage'] ?? '';
            iseGirisTarihi = gelenData['ise_giris_tarihi'] ?? '';
            unvanId = gelenData['unvan_id'] ?? '';
            unvanAd = gelenData['unvan_ad'] ?? '';
            hakkettigiyillikizingunsayisi =
                gelenData['hakkettigiyillikizingunsayisi'] ?? '';
            kullanilmisyillikizingunsayisi =
                gelenData['kullanilmisyillikizingunsayisi'] ?? '';
            kalanyillikizinhakkigunsayisi =
                gelenData['kalanyillikizinhakkigunsayisi'] ?? '';

            //gelen değerleri loginScreen içindeki kısımlara aktaralım
            _loginScreenCubit.setUserInfo(
              id: id,
              message: message,
              token: tokenSP,
              ad: ad,
              durum: durum,
              userfirmId: userFirmId,
              tip: tip,
              userimage: userimage,
              iseGirisTarihi: iseGirisTarihi,
              unvanId: unvanId,
              unvanAd: unvanAd,
              hakkettigiYillikizingunSayisi: hakkettigiyillikizingunsayisi,
              kullanilmisYillikIzinGunSayisi: kullanilmisyillikizingunsayisi,
              kalanyillikizinhakkigunsayisi: kalanyillikizinhakkigunsayisi,
              soyad: soyad,
              email: email,
              bildirimMail: bildirimMail,
              ceptelefon: ceptelefon,
            );
            _homeCustomCubit.personelSayisiGetir(
                userFirmId, tip, tokenSP, loginidSP);
            _homeCustomCubit.projeSayisiGetir(tokenSP, loginidSP);
            _homeCustomCubit.musteriSayisiGetir(
                id, userFirmId, tip, tokenSP, loginidSP);
            await Future.delayed(
                const Duration(milliseconds: 2200),
                () => emit(SplashState
                    .success)); // Login ekranını bekletmek için daha sonra kullanılabilir
          } else if (gelenData['state'] == '0') {
            ToastManager.instance.toastMessageService("Yeniden oturum açın !");
            emit(SplashState.failure);
          }
        }
      } catch (error) {
        throw Exception('splash exception : ${error.toString()}');
      }
    } else {
      emit(SplashState.failure);
    }
  }
}
