import 'dart:convert';

import 'package:dio/dio.dart';
import 'package:hamlemuhcrm/core/constants/url_services_constant.dart';
import 'package:hamlemuhcrm/core/extensions/log_extension.dart';
import 'package:hamlemuhcrm/features/permissions/model/izinler.dart';
import 'package:hamlemuhcrm/features/permissions/model/izinler_cevap.dart';

class PermissionRepository {
  final Dio dio = Dio();

  //BÜTÜN METOTLAR GÜNCELLENDİ token,loginuserid eklendi.....

  Future<void> izinTalepEt(
      String kayitliFirmaID,
      String loginuserid,
      String baslangicTarihi,
      String bitisTarihi,
      String izinTip,
      String yerineBakacakPersonelID,
      String onaylayacakUserID,
      String aciklama,
      String token) async {
/*guncel token,loginid eklendi*/
    var url = URLAPIService.instance.izinTalepEtURL;
    var veri = {
      "izin_userfirm_id": kayitliFirmaID,
      "loginuserid": loginuserid,
      "izin_yerine_bakacak_user": yerineBakacakPersonelID,
      "izin_baslama_tarihi": baslangicTarihi,
      "izin_isbasi_tarihi": bitisTarihi,
      "izin_tipi": izinTip,
      "izin_aciklama": aciklama,
      "izin_onay_user_id": onaylayacakUserID,
      "token": token,
    };
    var cevap = await dio.post(url, data: FormData.fromMap(veri));
    'izin Talep Durumu : ${cevap.data.toString()}'.log();
  }

  List<Izinler>? parseIzinler(String cevap) {
    /*Parse*/
    return IzinlerCevap.fromJson(json.decode(cevap)).izinler;
  }

  Future<List<Izinler>?> izinListele(String token, String loginuserid) async {
    /*guncel token,loginid eklendi*/
    var url = URLAPIService.instance.izinListeleURL;
    var veri = {"token": token, "loginuserid": loginuserid};
    var cevap = await dio.post(url, data: FormData.fromMap(veri));
    'izinler : ${cevap.data.toString()}'.log();
    return parseIzinler(cevap.data.toString());
  }

  Future<void> izinCevapla(
      String izinId, String izinDurum, String token, String loginuserid) async {
    /*guncel token,loginid eklendi*/
    var url = URLAPIService.instance.izinCevaplaURL;
    var veri = {
      'izin_id': izinId,
      'izin_durum': izinDurum,
      "token": token,
      "loginuserid": loginuserid
    };
    var cevap = await dio.post(url, data: FormData.fromMap(veri));
    'izin cevaplama : ${cevap.data.toString()}'.log();
  }
}
