import 'dart:async';
import 'dart:convert';

import 'package:dio/dio.dart';
import 'package:hamlemuhcrm/core/extensions/log_extension.dart';

import '../../core/base/base_response.dart';
import '../../core/constants/url_services_constant.dart';
import '../../features/customers/model/firmalar.dart';
import '../../features/customers/model/firmalar_cevap.dart';

class CustomersRepository {
  final Dio dio = Dio();

  //BÜTÜN METOTLAR GÜNCELLENDİ token,loginuserid eklendi.....

  /*Parse*/ List<Firmalar> parseFirmaCevap(String cevap) {
    return FirmalarCevap.fromJson(json.decode(cevap)).firmalar;
  }

  Future<List<Firmalar>> kisiFirmalariListele(String userTip, String token,
      String loginuserid, String userfirmid) async {
    try {
      /*guncel token,loginid eklendi*/
      var url = URLAPIService.instance.kisiFirmaListeleURL;
      var veri = {
        "user_tip": userTip,
        "token": token,
        "loginuserid": loginuserid,
        "userfirmid": userfirmid,
      };
      var cevap = await dio.post(url, data: FormData.fromMap(veri));
      if (cevap.statusCode == 200) {
        return FirmalarCevap.fromJson(json.decode(cevap.data)).firmalar;
      }
    } catch (e) {
      return [];
    }
    return [];
  }

  Future<List<Firmalar>> kisiArsivFirmaListele(String userTip, String token,
      String loginuserid, String userfirmid) async {
    /*guncel token,loginid eklendi*/
    var url = URLAPIService.instance.kisiArsivFirmaListeleURL;
    var veri = {
      "user_tip": userTip,
      "token": token,
      "loginuserid": loginuserid,
      "userfirmid": userfirmid,
    };
    var cevap = await dio.post(url, data: FormData.fromMap(veri));
    return parseFirmaCevap(cevap.data.toString());
  }

  Future<BaseResponseModel?> firmaEkle(
    /*guncel token,loginid eklendi*/
    String firmaFirmUserId,
    String firmaIsim,
    String firmaWeb,
    String firmaMail,
    String firmaVergiDairesi,
    String firmaVergiNo,
    String firmaTelefon,
    String firmaBirincilAdresi,
    String loginuserid,
    String firmaIl,
    String firmaIlce,
    String token,
  ) async {
    try {
      var url = URLAPIService.instance.firmaEkleURL;
      var veri = {
        "firma_firmuser_id": firmaFirmUserId,
        "firma_isim": firmaIsim,
        "firma_web": firmaWeb,
        "firma_e_mail": firmaMail,
        "firma_vergi_dairesi": firmaVergiDairesi,
        "firma_vergi_no": firmaVergiNo,
        "firma_telefon": firmaTelefon,
        "firma_birincil_adresi": firmaBirincilAdresi,
        "loginuserid":
            loginuserid, //firma_ekleyen_user_id ye karşılık olarak bu gönderilecek
        "firma_il": firmaIl,
        "firma_ilce": firmaIlce,
        "token": token,
      };
      var cevap = await dio.post(url, data: FormData.fromMap(veri));

      'firmaEkle : ${cevap.data}'.log();

      if (cevap.data is Map<String, dynamic>) {
        'firmaEkle 1.condition: ${cevap.data}'.log();
        return BaseResponseModel.fromJson(cevap.data);
      } else if (cevap.data is String) {
        'firmaEkle 2.condition: ${cevap.data}'.log();
        final Map<String, dynamic> responseData = jsonDecode(cevap.data);
        return BaseResponseModel.fromJson(responseData);
      } else {
        'firmaEkle 3.condition: ${cevap.data}'.log();
        return null;
      }
    } catch (e) {
      return BaseResponseModel(message: 'Hata Oluştu', success: 0);
    }
  }

  Future<void> firmaGuncelle(
      /*guncel token,loginid eklendi*/
      String firmaId,
      String firmaIsim,
      String firmaWeb,
      String firmaMail,
      String firmaVergiDairesi,
      String firmaVergiNo,
      String firmaTelefon,
      String firmaBirincilAdresi,
      String loginuserid,
      String firmaIl,
      String firmaIlce,
      String token) async {
    var url = URLAPIService.instance.firmaGuncelleURL;
    var veri = {
      "firma_id": firmaId,
      "firma_isim": firmaIsim,
      "firma_web": firmaWeb,
      "firma_e_mail": firmaMail,
      "firma_vergi_dairesi": firmaVergiDairesi,
      "firma_vergi_no": firmaVergiNo,
      "firma_telefon": firmaTelefon,
      "firma_birincil_adresi": firmaBirincilAdresi,
      "loginuserid": loginuserid,
      "firma_il": firmaIl,
      "firma_ilce": firmaIlce,
      "token": token,
    };
    var cevap = await dio.post(url, data: FormData.fromMap(veri));
    "Firma Güncelle : ${cevap.data.toString()}".log();
  }

  Future<void> firmArsivle(
      String firmaId, String token, String loginuserid) async {
    /*guncel token,loginid eklendi*/
    var url = URLAPIService.instance.firmaArsivleURL;
    var veri = {
      "firma_id": firmaId,
      "token": token,
      "loginuserid": loginuserid
    };
    var cevap = await dio.post(url, data: FormData.fromMap(veri));
    "Firma Arşivle : ${cevap.data.toString()}".log();
  }

  Future<void> firmArsivdenCikar(
      String firmaId, String token, String loginuserid) async {
    /*guncel token,loginid eklendi*/
    var url = URLAPIService.instance.firmaArsivdenCikarURL;
    var veri = {
      "firma_id": firmaId,
      "token": token,
      "loginuserid": loginuserid
    };
    var cevap = await dio.post(url, data: FormData.fromMap(veri));
    "Firmayı Arşivden Çıkar : ${cevap.data.toString()}".log();
  }
}
