import 'dart:convert';

import 'package:dio/dio.dart';
import 'package:hamlemuhcrm/core/extensions/log_extension.dart';

import '../../core/constants/url_services_constant.dart';
import '../../core/init/network/network_manager.dart';
import '../../features/calendar/model/calendar_model.dart';
import '../../features/calendar/model/calendar_response_model.dart';
import '../../features/calendar/model/new_meet_model.dart';
import '../../features/calendar/model/suggestion_model.dart';
import '../../features/calendar/model/suggestion_response_model.dart';
import '../../features/calendar/model/update_meet_model.dart';

class CalendarRepository {
  final Dio dio = NetworkManager.instance.dio;

  Future<List<CalendarModel>> fetchMeets(
      String token, String loginuserid, String selectedDate,
      {bool isWeek = false}) async {
    var url = isWeek
        ? URLAPIService.instance.toplantiHaftayaGoreListeleURL
        : URLAPIService.instance.toplantiGuneGoreListeleURL;
    var veri = {
      "token": token,
      "loginuserid": loginuserid,
      "toplanti_tarihi": selectedDate
    };
    final response = await dio.post(url, data: FormData.fromMap(veri));
    final responseData =
        jsonDecode(response.data); // response.data üzerinden işlem yapılıyor
    final calendarResponse = CalendarResponseModel.fromJson(responseData);
    return calendarResponse.toplantilar ?? [];
  }

  Future<List<CalendarModel>> fetchMonthMeets(String token, String loginuserid,
      String monthFirstDate, String monthLastDate) async {
    var url = URLAPIService.instance.toplantiAyaGoreListeleURL;
    var veri = {
      "token": token,
      "loginuserid": loginuserid,
      "baslangic": monthFirstDate,
      "bitis": monthLastDate
    };
    final response = await dio.post(url, data: FormData.fromMap(veri));
    final responseData =
        jsonDecode(response.data); // response.data üzerinden işlem yapılıyor
    final calendarResponse = CalendarResponseModel.fromJson(responseData);
    return calendarResponse.toplantilar ?? [];
  }

  Future<void> viewUpdateMeet(
      String token, String loginuserid, String toplantiId) async {
    var url = URLAPIService.instance.toplantiGoruntulemeURL;
    var veri = {
      "token": token,
      "loginuserid": loginuserid,
      "toplanti_id": toplantiId
    };
    final response = await dio.post(url, data: FormData.fromMap(veri));
    '${response.data}'.log();
  }

  Future<void> addNewMeet(NewMeetModel model) async {
    var url = URLAPIService.instance.yeniToplantiEkleURL;
    final response =
        await dio.post(url, data: FormData.fromMap(model.toJson()));
    '${response.data}'.log();
  }

  Future<void> updateMeets(UpdateMeetModel updateMeetModel) async {
    var url = URLAPIService.instance.toplantiGuncelleURL;
    await dio.post(url, data: FormData.fromMap(updateMeetModel.toJson()));
  }

  Future<List<SuggestionModel>> fetchSuggestions(String token,
      String loginuserid, String gundemToplantiId, String toplantiDurum) async {
    var url = URLAPIService.instance.gundemListeleURL;
    var veri = {
      "token": token,
      "loginuserid": loginuserid,
      "togundem_toplanti_id": gundemToplantiId,
      "togundem_durum": toplantiDurum,
    };

    final response = await dio.post(url, data: FormData.fromMap(veri));

    final responseData =
        jsonDecode(response.data); // response.data üzerinden işlem yapılıyor
    final gundemlerResponse = SuggestionResponseModel.fromJson(responseData);

    return gundemlerResponse.gundemler ?? [];
  }

  Future<void> addNewSuggestion(String loginUserId, String token,
      String userFirmId, String toplantiId, String gundemMetni) async {
    var url = URLAPIService.instance.gundemOnerisiEkleURL;
    var veri = {
      "loginuserid": loginUserId,
      "token": token,
      "togundem_userfirm_id": userFirmId,
      "togundem_toplanti_id": toplantiId,
      "togundem_metin": gundemMetni
    };
    await dio.post(url, data: FormData.fromMap(veri));
  }

  Future<void> acceptSuggestion(
      String loginUserId, String token, String gundemId, String cevap) async {
    var url = URLAPIService.instance.gundemOnaylaVeyaSilURL;
    var veri = {
      "loginuserid": loginUserId,
      "token": token,
      "togundem_id": gundemId,
      "togundem_onay": cevap,
    };
    await dio.post(url, data: FormData.fromMap(veri));
  }

  Future<Response> fetchAllYetkiliDD(
      String yetkiliFirmaId, String token, String loginuserid) async {
    var url = URLAPIService.instance.yetkiliListeleDDURL;
    var veri = {
      "yetkili_firma_id": yetkiliFirmaId,
      "token": token,
      "loginuserid": loginuserid
    };
    var response = await dio.post(url, data: FormData.fromMap(veri));
    return response;
  }

  Future<Response> fetchAllCalisanDD(
      String userfirmid, String token, String loginuserid) async {
    var url = URLAPIService.instance.calisanListeleDDURL;
    var veri = {
      "user_userfirm_id": userfirmid,
      "token": token,
      "loginuserid": loginuserid
    };
    var response = await dio.post(url, data: FormData.fromMap(veri));
    return response;
  }
}
